/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.DocumentId;
import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.feed.client.FeedException;
import ai.vespa.feed.client.HttpRequest;
import ai.vespa.feed.client.HttpRequestStrategy;
import ai.vespa.feed.client.HttpResponse;
import ai.vespa.feed.client.OperationParameters;
import ai.vespa.feed.client.OperationStats;
import ai.vespa.feed.client.RequestStrategy;
import ai.vespa.feed.client.Result;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.hc.core5.net.URIBuilder;

class HttpFeedClient
implements FeedClient {
    private static final JsonFactory factory = new JsonFactory();
    private final Map<String, Supplier<String>> requestHeaders;
    private final RequestStrategy requestStrategy;
    private final AtomicBoolean closed = new AtomicBoolean();

    HttpFeedClient(FeedClientBuilder builder) throws IOException {
        this(builder, new HttpRequestStrategy(builder));
    }

    HttpFeedClient(FeedClientBuilder builder, RequestStrategy requestStrategy) {
        this.requestHeaders = new HashMap<String, Supplier<String>>(builder.requestHeaders);
        this.requestStrategy = requestStrategy;
    }

    @Override
    public CompletableFuture<Result> put(DocumentId documentId, String documentJson, OperationParameters params) {
        return this.send("POST", documentId, Objects.requireNonNull(documentJson), params);
    }

    @Override
    public CompletableFuture<Result> update(DocumentId documentId, String updateJson, OperationParameters params) {
        return this.send("PUT", documentId, Objects.requireNonNull(updateJson), params);
    }

    @Override
    public CompletableFuture<Result> remove(DocumentId documentId, OperationParameters params) {
        return this.send("DELETE", documentId, null, params);
    }

    @Override
    public OperationStats stats() {
        return this.requestStrategy.stats();
    }

    @Override
    public void close(boolean graceful) {
        this.closed.set(true);
        if (graceful) {
            this.requestStrategy.await();
        }
        this.requestStrategy.destroy();
    }

    private void ensureOpen() {
        if (this.requestStrategy.hasFailed()) {
            this.close();
        }
        if (this.closed.get()) {
            throw new IllegalStateException("Client is closed, no further operations may be sent");
        }
    }

    private CompletableFuture<Result> send(String method, DocumentId documentId, String operationJson, OperationParameters params) {
        this.ensureOpen();
        String path = HttpFeedClient.operationPath(documentId, params).toString();
        HttpRequest request = new HttpRequest(method, path, this.requestHeaders, operationJson.getBytes(StandardCharsets.UTF_8));
        return this.requestStrategy.enqueue(documentId, request).thenApply(response -> HttpFeedClient.toResult(request, response, documentId));
    }

    static Result toResult(HttpRequest request, HttpResponse response, DocumentId documentId) {
        Result.Type type;
        switch (response.code()) {
            case 200: {
                type = Result.Type.success;
                break;
            }
            case 412: {
                type = Result.Type.conditionNotMet;
                break;
            }
            case 502: 
            case 504: 
            case 507: {
                type = Result.Type.failure;
                break;
            }
            default: {
                type = null;
            }
        }
        String message = null;
        String trace = null;
        try {
            String name;
            JsonParser parser = factory.createParser(response.body());
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new IllegalArgumentException("Expected '" + (Object)((Object)JsonToken.START_OBJECT) + "', but found '" + (Object)((Object)parser.currentToken()) + "' in: " + new String(response.body(), StandardCharsets.UTF_8));
            }
            block15: while ((name = parser.nextFieldName()) != null) {
                switch (name) {
                    case "message": {
                        message = parser.nextTextValue();
                        continue block15;
                    }
                    case "trace": {
                        trace = parser.nextTextValue();
                        continue block15;
                    }
                }
                parser.nextToken();
            }
            if (parser.currentToken() != JsonToken.END_OBJECT) {
                throw new IllegalArgumentException("Expected '" + (Object)((Object)JsonToken.END_OBJECT) + "', but found '" + (Object)((Object)parser.currentToken()) + "' in: " + new String(response.body(), StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (type == null) {
            throw new FeedException("Status " + response.code() + " executing '" + request + "': " + (message == null ? new String(response.body(), StandardCharsets.UTF_8) : message));
        }
        return new Result(type, documentId, message, trace);
    }

    static List<String> toPath(DocumentId documentId) {
        ArrayList<String> path = new ArrayList<String>();
        path.add("document");
        path.add("v1");
        path.add(documentId.namespace());
        path.add(documentId.documentType());
        if (documentId.number().isPresent()) {
            path.add("number");
            path.add(Long.toUnsignedString(documentId.number().getAsLong()));
        } else if (documentId.group().isPresent()) {
            path.add("group");
            path.add(documentId.group().get());
        } else {
            path.add("docid");
        }
        path.add(documentId.userSpecific());
        return path;
    }

    static URI operationPath(DocumentId documentId, OperationParameters params) {
        URIBuilder url = new URIBuilder();
        url.setPathSegments(HttpFeedClient.toPath(documentId));
        if (params.createIfNonExistent()) {
            url.addParameter("create", "true");
        }
        params.testAndSetCondition().ifPresent(condition -> url.addParameter("condition", (String)condition));
        params.timeout().ifPresent(timeout -> url.addParameter("timeout", timeout.toMillis() + "ms"));
        params.route().ifPresent(route -> url.addParameter("route", (String)route));
        params.tracelevel().ifPresent(tracelevel -> url.addParameter("tracelevel", Integer.toString(tracelevel)));
        try {
            return url.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}

