/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.Cluster;
import ai.vespa.feed.client.OperationStats;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;

public class BenchmarkingCluster
implements Cluster {
    private final Cluster delegate;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = new Thread(runnable, "cluster-stats-collector");
        thread.setDaemon(true);
        return thread;
    });
    private final AtomicLong requests = new AtomicLong();
    private long results = 0L;
    private long responses = 0L;
    private final long[] responsesByCode = new long[600];
    private long exceptions = 0L;
    private long totalLatencyMillis = 0L;
    private long minLatencyMillis = Long.MAX_VALUE;
    private long maxLatencyMillis = 0L;
    private long bytesSent = 0L;
    private long bytesReceived = 0L;

    public BenchmarkingCluster(Cluster delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void dispatch(SimpleHttpRequest request, CompletableFuture<SimpleHttpResponse> vessel) {
        this.requests.incrementAndGet();
        long startMillis = System.currentTimeMillis();
        this.delegate.dispatch(request, vessel);
        vessel.whenCompleteAsync((response, thrown) -> {
            ++this.results;
            if (thrown == null) {
                ++this.responses;
                int n = response.getCode();
                this.responsesByCode[n] = this.responsesByCode[n] + 1L;
                long latency = System.currentTimeMillis() - startMillis;
                this.totalLatencyMillis += latency;
                this.minLatencyMillis = Math.min(this.minLatencyMillis, latency);
                this.maxLatencyMillis = Math.max(this.maxLatencyMillis, latency);
                this.bytesSent += request.getBodyBytes() == null ? 0L : (long)request.getBodyBytes().length;
                this.bytesReceived += response.getBodyBytes() == null ? 0L : (long)response.getBodyBytes().length;
            } else {
                ++this.exceptions;
            }
        }, (Executor)this.executor);
    }

    @Override
    public OperationStats stats() {
        try {
            try {
                return this.executor.submit(this::getStats).get();
            }
            catch (RejectedExecutionException ignored) {
                this.executor.awaitTermination(10L, TimeUnit.SECONDS);
                return this.getStats();
            }
        }
        catch (InterruptedException | ExecutionException ignored) {
            throw new RuntimeException(ignored);
        }
    }

    private OperationStats getStats() {
        HashMap<Integer, Long> responses = new HashMap<Integer, Long>();
        for (int code = 0; code < this.responsesByCode.length; ++code) {
            if (this.responsesByCode[code] <= 0L) continue;
            responses.put(code, this.responsesByCode[code]);
        }
        return new OperationStats(this.requests.get(), responses, this.exceptions, this.requests.get() - this.results, this.responses == 0L ? 0L : this.totalLatencyMillis / this.responses, this.minLatencyMillis, this.maxLatencyMillis, this.bytesSent, this.bytesReceived);
    }

    @Override
    public void close() {
        this.delegate.close();
        this.executor.shutdown();
    }
}

