/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.DocumentId;
import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.OperationParameters;
import ai.vespa.feed.client.Result;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class JsonStreamFeeder
implements Closeable {
    private final FeedClient client;
    private final OperationParameters protoParameters;
    private static final JsonFactory factory = new JsonFactory();

    private JsonStreamFeeder(FeedClient client, OperationParameters protoParameters) {
        this.client = client;
        this.protoParameters = protoParameters;
    }

    public static Builder builder(FeedClient client) {
        return new Builder(client);
    }

    public void feed(InputStream jsonStream) throws IOException {
        this.feed(jsonStream, 0x4000000, false);
    }

    BenchmarkResult benchmark(InputStream jsonStream) throws IOException {
        return this.feed(jsonStream, 0x4000000, true).get();
    }

    Optional<BenchmarkResult> feed(InputStream jsonStream, int size, boolean benchmark) throws IOException {
        CompletableFuture<Result> result;
        RingBufferStream buffer = new RingBufferStream(jsonStream, size);
        buffer.expect(JsonToken.START_ARRAY);
        AtomicInteger okCount = new AtomicInteger();
        AtomicInteger failedCount = new AtomicInteger();
        long startTime = System.nanoTime();
        AtomicReference thrown = new AtomicReference();
        while ((result = buffer.next()) != null) {
            result.whenComplete((r, t) -> {
                if (t != null) {
                    failedCount.incrementAndGet();
                    if (!benchmark) {
                        thrown.set(t);
                    }
                } else {
                    okCount.incrementAndGet();
                }
            });
            if (thrown.get() == null) continue;
            JsonStreamFeeder.sneakyThrow((Throwable)thrown.get());
        }
        if (!benchmark) {
            return Optional.empty();
        }
        Duration duration = Duration.ofNanos(System.nanoTime() - startTime);
        double throughPut = (double)okCount.get() / (double)duration.toMillis() * 1000.0;
        return Optional.of(new BenchmarkResult(okCount.get(), failedCount.get(), duration, throughPut));
    }

    static <T extends Throwable> void sneakyThrow(Throwable thrown) throws T {
        throw thrown;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    static class BenchmarkResult {
        final int okCount;
        final int errorCount;
        final Duration duration;
        final double throughput;

        BenchmarkResult(int okCount, int errorCount, Duration duration, double throughput) {
            this.okCount = okCount;
            this.errorCount = errorCount;
            this.duration = duration;
            this.throughput = throughput;
        }
    }

    public static class Builder {
        final FeedClient client;
        OperationParameters parameters = OperationParameters.empty();

        private Builder(FeedClient client) {
            this.client = Objects.requireNonNull(client);
        }

        public Builder withTimeout(Duration timeout) {
            this.parameters = this.parameters.timeout(timeout);
            return this;
        }

        public Builder withRoute(String route) {
            this.parameters = this.parameters.route(route);
            return this;
        }

        public Builder withTracelevel(int tracelevel) {
            this.parameters = this.parameters.tracelevel(tracelevel);
            return this;
        }

        public JsonStreamFeeder build() {
            return new JsonStreamFeeder(this.client, this.parameters);
        }
    }

    private class RingBufferStream
    extends InputStream {
        private final byte[] b = new byte[1];
        private final InputStream in;
        private final byte[] data;
        private final int size;
        private final Object lock = new Object();
        private final JsonParser parser;
        private Throwable thrown = null;
        private long tail = 0L;
        private long pos = 0L;
        private long head = 0L;
        private boolean done = false;
        private final byte[] prefix = "{\"fields\":".getBytes(StandardCharsets.UTF_8);

        RingBufferStream(InputStream in, int size) {
            this.in = in;
            this.data = new byte[size];
            this.size = size;
            new Thread(this::fill, "feed-reader").start();
            try {
                this.parser = factory.createParser(this);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public int read() throws IOException {
            return this.read(this.b, 0, 1) == -1 ? -1 : this.b[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buffer, int off, int len) throws IOException {
            try {
                int ready;
                Object object = this.lock;
                synchronized (object) {
                    while ((ready = (int)(this.head - this.pos)) == 0 && !this.done) {
                        this.lock.wait();
                    }
                }
                if (this.thrown != null) {
                    throw new RuntimeException("Error reading input", this.thrown);
                }
                if (ready == 0) {
                    return -1;
                }
                ready = Math.min(ready, len);
                int offset = (int)(this.pos % (long)this.size);
                int length = Math.min(ready, this.size - offset);
                System.arraycopy(this.data, offset, buffer, off, length);
                if (length < ready) {
                    System.arraycopy(this.data, 0, buffer, off + length, ready - length);
                }
                this.pos += (long)ready;
                return ready;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted waiting for data: " + e.getMessage());
            }
        }

        void expect(JsonToken token) throws IOException {
            if (this.parser.nextToken() != token) {
                throw new IllegalArgumentException("Expected '" + (Object)((Object)token) + "' at offset " + this.parser.getTokenLocation().getByteOffset() + ", but found '" + (Object)((Object)this.parser.currentToken()) + "' (" + this.parser.getText() + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<Result> next() throws IOException {
            long start = 0L;
            long end = -1L;
            FeedClient.OperationType type = null;
            DocumentId id = null;
            OperationParameters parameters = JsonStreamFeeder.this.protoParameters;
            switch (this.parser.nextToken()) {
                case END_ARRAY: {
                    return null;
                }
                case START_OBJECT: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected token '" + (Object)((Object)this.parser.currentToken()) + "' at offset " + this.parser.getTokenLocation().getByteOffset());
                }
            }
            block37: while (true) {
                switch (this.parser.nextToken()) {
                    case FIELD_NAME: {
                        switch (this.parser.getText()) {
                            case "id": 
                            case "put": {
                                type = FeedClient.OperationType.PUT;
                                id = this.readId();
                                continue block37;
                            }
                            case "update": {
                                type = FeedClient.OperationType.UPDATE;
                                id = this.readId();
                                continue block37;
                            }
                            case "remove": {
                                type = FeedClient.OperationType.REMOVE;
                                id = this.readId();
                                continue block37;
                            }
                            case "condition": {
                                parameters = parameters.testAndSetCondition(this.readString());
                                continue block37;
                            }
                            case "create": {
                                parameters = parameters.createIfNonExistent(this.readBoolean());
                                continue block37;
                            }
                            case "fields": {
                                this.expect(JsonToken.START_OBJECT);
                                start = this.parser.getTokenLocation().getByteOffset();
                                int depth = 1;
                                while (depth > 0) {
                                    switch (this.parser.nextToken()) {
                                        case START_OBJECT: {
                                            ++depth;
                                            break;
                                        }
                                        case END_OBJECT: {
                                            --depth;
                                        }
                                    }
                                }
                                end = this.parser.getTokenLocation().getByteOffset() + 1L;
                                continue block37;
                            }
                        }
                        throw new IllegalArgumentException("Unexpected field name '" + this.parser.getText() + "' at offset " + this.parser.getTokenLocation().getByteOffset());
                    }
                    case END_OBJECT: {
                        break block37;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected token '" + (Object)((Object)this.parser.currentToken()) + "' at offset " + this.parser.getTokenLocation().getByteOffset());
                    }
                }
                break;
            }
            if (id == null) {
                throw new IllegalArgumentException("No document id for document at offset " + start);
            }
            if (end < start) {
                throw new IllegalArgumentException("No 'fields' object for document at offset " + this.parser.getTokenLocation().getByteOffset());
            }
            String payload = new String(this.copy(start, end), StandardCharsets.UTF_8);
            Object object = this.lock;
            synchronized (object) {
                this.tail = end;
                this.lock.notify();
            }
            switch (type) {
                case PUT: {
                    return JsonStreamFeeder.this.client.put(id, payload, parameters);
                }
                case UPDATE: {
                    return JsonStreamFeeder.this.client.update(id, payload, parameters);
                }
                case REMOVE: {
                    return JsonStreamFeeder.this.client.remove(id, parameters);
                }
            }
            throw new IllegalStateException("Unexpected operation type '" + (Object)((Object)type) + "'");
        }

        private byte[] copy(long start, long end) {
            int length = (int)(end - start);
            byte[] buffer = new byte[this.prefix.length + length + 1];
            System.arraycopy(this.prefix, 0, buffer, 0, this.prefix.length);
            int offset = (int)(start % (long)this.size);
            int toWrite = Math.min(length, this.size - offset);
            System.arraycopy(this.data, offset, buffer, this.prefix.length, toWrite);
            if (toWrite < length) {
                System.arraycopy(this.data, 0, buffer, this.prefix.length + toWrite, length - toWrite);
            }
            buffer[buffer.length - 1] = 125;
            return buffer;
        }

        private String readString() throws IOException {
            String value = this.parser.nextTextValue();
            if (value == null) {
                throw new IllegalArgumentException("Expected '" + (Object)((Object)JsonToken.VALUE_STRING) + "' at offset " + this.parser.getTokenLocation().getByteOffset() + ", but found '" + (Object)((Object)this.parser.currentToken()) + "' (" + this.parser.getText() + ")");
            }
            return value;
        }

        private boolean readBoolean() throws IOException {
            Boolean value = this.parser.nextBooleanValue();
            if (value == null) {
                throw new IllegalArgumentException("Expected '" + (Object)((Object)JsonToken.VALUE_FALSE) + "' or '" + (Object)((Object)JsonToken.VALUE_TRUE) + "' at offset " + this.parser.getTokenLocation().getByteOffset() + ", but found '" + (Object)((Object)this.parser.currentToken()) + "' (" + this.parser.getText() + ")");
            }
            return value;
        }

        private DocumentId readId() throws IOException {
            return DocumentId.of(this.readString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.done = true;
                this.lock.notifyAll();
            }
            this.in.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void fill() {
            try {
                while (true) {
                    int free;
                    Object object = this.lock;
                    // MONITORENTER : object
                    while ((free = (int)(this.tail + (long)this.size - this.head)) <= 0 && !this.done) {
                        this.lock.wait();
                    }
                    // MONITOREXIT : object
                    if (this.done) {
                        return;
                    }
                    int off = (int)(this.head % (long)this.size);
                    int len = Math.min(Math.min(free, this.size - off), 8192);
                    int read = this.in.read(this.data, off, len);
                    Object object2 = this.lock;
                    // MONITORENTER : object2
                    if (read < 0) {
                        this.done = true;
                    } else {
                        this.head += (long)read;
                    }
                    this.lock.notify();
                    // MONITOREXIT : object2
                }
            }
            catch (Throwable t) {
                Object object = this.lock;
                // MONITORENTER : object
                this.done = true;
                this.thrown = t;
                // MONITOREXIT : object
                return;
            }
        }
    }
}

