/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.DocumentId;
import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.feed.client.HttpRequestStrategy;
import ai.vespa.feed.client.OperationParameters;
import ai.vespa.feed.client.RequestStrategy;
import ai.vespa.feed.client.Result;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.net.URIBuilder;

class HttpFeedClient
implements FeedClient {
    private static final JsonFactory factory = new JsonFactory();
    private final Map<String, Supplier<String>> requestHeaders;
    private final RequestStrategy requestStrategy;
    private final AtomicBoolean closed = new AtomicBoolean();

    HttpFeedClient(FeedClientBuilder builder) throws IOException {
        this(builder, new HttpRequestStrategy(builder));
    }

    HttpFeedClient(FeedClientBuilder builder, RequestStrategy requestStrategy) {
        this.requestHeaders = new HashMap<String, Supplier<String>>(builder.requestHeaders);
        this.requestStrategy = requestStrategy;
    }

    @Override
    public CompletableFuture<Result> put(DocumentId documentId, String documentJson, OperationParameters params) {
        return this.send("POST", documentId, Objects.requireNonNull(documentJson), params);
    }

    @Override
    public CompletableFuture<Result> update(DocumentId documentId, String updateJson, OperationParameters params) {
        return this.send("PUT", documentId, Objects.requireNonNull(updateJson), params);
    }

    @Override
    public CompletableFuture<Result> remove(DocumentId documentId, OperationParameters params) {
        return this.send("DELETE", documentId, null, params);
    }

    @Override
    public void close(boolean graceful) {
        this.closed.set(true);
        if (graceful) {
            this.requestStrategy.await();
        }
        this.requestStrategy.destroy();
    }

    private void ensureOpen() {
        if (this.requestStrategy.hasFailed()) {
            this.close();
        }
        if (this.closed.get()) {
            throw new IllegalStateException("Client is closed, no further operations may be sent");
        }
    }

    private CompletableFuture<Result> send(String method, DocumentId documentId, String operationJson, OperationParameters params) {
        this.ensureOpen();
        String path = HttpFeedClient.operationPath(documentId, params).toString();
        SimpleHttpRequest request = new SimpleHttpRequest(method, path);
        this.requestHeaders.forEach((name, value) -> request.setHeader((String)name, value.get()));
        if (operationJson != null) {
            request.setBody(operationJson, ContentType.APPLICATION_JSON);
        }
        return this.requestStrategy.enqueue(documentId, request).handle((response, thrown) -> {
            if (thrown != null) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                thrown.printStackTrace(new PrintStream(buffer));
                return new Result(Result.Type.failure, documentId, buffer.toString(), null);
            }
            return HttpFeedClient.toResult(response, documentId);
        });
    }

    static Result toResult(SimpleHttpResponse response, DocumentId documentId) {
        Result.Type type;
        switch (response.getCode()) {
            case 200: {
                type = Result.Type.success;
                break;
            }
            case 412: {
                type = Result.Type.conditionNotMet;
                break;
            }
            default: {
                type = Result.Type.failure;
            }
        }
        String message = null;
        String trace = null;
        try {
            String name;
            JsonParser parser = factory.createParser(response.getBodyText());
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new IllegalArgumentException("Expected '" + (Object)((Object)JsonToken.START_OBJECT) + "', but found '" + (Object)((Object)parser.currentToken()) + "' in: " + response.getBodyText());
            }
            block14: while ((name = parser.nextFieldName()) != null) {
                switch (name) {
                    case "message": {
                        message = parser.nextTextValue();
                        continue block14;
                    }
                    case "trace": {
                        trace = parser.nextTextValue();
                        continue block14;
                    }
                }
                parser.nextToken();
            }
            if (parser.currentToken() != JsonToken.END_OBJECT) {
                throw new IllegalArgumentException("Expected '" + (Object)((Object)JsonToken.END_OBJECT) + "', but found '" + (Object)((Object)parser.currentToken()) + "' in: " + response.getBodyText());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new Result(type, documentId, message, trace);
    }

    static List<String> toPath(DocumentId documentId) {
        ArrayList<String> path = new ArrayList<String>();
        path.add("document");
        path.add("v1");
        path.add(documentId.namespace());
        path.add(documentId.documentType());
        if (documentId.number().isPresent()) {
            path.add("number");
            path.add(Long.toUnsignedString(documentId.number().getAsLong()));
        } else if (documentId.group().isPresent()) {
            path.add("group");
            path.add(documentId.group().get());
        } else {
            path.add("docid");
        }
        path.add(documentId.userSpecific());
        return path;
    }

    static URI operationPath(DocumentId documentId, OperationParameters params) {
        URIBuilder url = new URIBuilder();
        url.setPathSegments(HttpFeedClient.toPath(documentId));
        if (params.createIfNonExistent()) {
            url.addParameter("create", "true");
        }
        params.testAndSetCondition().ifPresent(condition -> url.addParameter("condition", (String)condition));
        params.timeout().ifPresent(timeout -> url.addParameter("timeout", timeout.toMillis() + "ms"));
        params.route().ifPresent(route -> url.addParameter("route", (String)route));
        params.tracelevel().ifPresent(tracelevel -> url.addParameter("tracelevel", Integer.toString(tracelevel)));
        try {
            return url.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}

