/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.Cluster;
import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.feed.client.SslContextBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.ssl.TlsCiphers;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;

class HttpCluster
implements Cluster {
    private final List<Endpoint> endpoints = new ArrayList<Endpoint>();

    public HttpCluster(FeedClientBuilder builder) throws IOException {
        for (URI endpoint : builder.endpoints) {
            for (int i = 0; i < builder.connectionsPerEndpoint; ++i) {
                this.endpoints.add(new Endpoint(HttpCluster.createHttpClient(builder), endpoint));
            }
        }
    }

    @Override
    public void dispatch(SimpleHttpRequest request, final CompletableFuture<SimpleHttpResponse> vessel) {
        int index = 0;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (this.endpoints.get(i).inflight.get() >= min) continue;
            index = i;
            min = this.endpoints.get(i).inflight.get();
        }
        Endpoint endpoint = this.endpoints.get(index);
        endpoint.inflight.incrementAndGet();
        try {
            request.setScheme(endpoint.url.getScheme());
            request.setAuthority(new URIAuthority(endpoint.url.getHost(), endpoint.url.getPort()));
            endpoint.client.execute(request, new FutureCallback<SimpleHttpResponse>(){

                @Override
                public void completed(SimpleHttpResponse response) {
                    vessel.complete(response);
                }

                @Override
                public void failed(Exception ex) {
                    vessel.completeExceptionally(ex);
                }

                @Override
                public void cancelled() {
                    vessel.cancel(false);
                }
            });
        }
        catch (Throwable thrown) {
            vessel.completeExceptionally(thrown);
        }
        vessel.whenComplete((__, ___) -> endpoint.inflight.decrementAndGet());
    }

    @Override
    public void close() {
        Throwable thrown = null;
        for (Endpoint endpoint : this.endpoints) {
            try {
                endpoint.client.close();
            }
            catch (Throwable t) {
                if (thrown == null) {
                    thrown = t;
                    continue;
                }
                thrown.addSuppressed(t);
            }
        }
        if (thrown != null) {
            throw new RuntimeException(thrown);
        }
    }

    private static CloseableHttpAsyncClient createHttpClient(FeedClientBuilder builder) throws IOException {
        H2AsyncClientBuilder httpClientBuilder = H2AsyncClientBuilder.create().setUserAgent(String.format("vespa-feed-client/%s", "7.417.20")).setDefaultHeaders(Collections.singletonList(new BasicHeader("Vespa-Client-Version", "7.417.20"))).disableCookieManagement().disableRedirectHandling().disableAutomaticRetries().setIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(1).setTcpNoDelay(true).setSoTimeout(Timeout.ofSeconds(10L)).build()).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds(10L)).setConnectionRequestTimeout(Timeout.DISABLED).setResponseTimeout(Timeout.ofMinutes(5L)).build()).setH2Config(H2Config.initial().setMaxConcurrentStreams(builder.maxStreamsPerConnection).setCompressionEnabled(true).setPushEnabled(false).build());
        SSLContext sslContext = HttpCluster.constructSslContext(builder);
        String[] allowedCiphers = TlsCiphers.excludeH2Blacklisted(TlsCiphers.excludeWeak(sslContext.getSupportedSSLParameters().getCipherSuites()));
        if (allowedCiphers.length == 0) {
            throw new IllegalStateException("No adequate SSL cipher suites supported by the JVM");
        }
        ClientTlsStrategyBuilder tlsStrategyBuilder = ClientTlsStrategyBuilder.create().setCiphers(allowedCiphers).setSslContext(sslContext);
        if (builder.hostnameVerifier != null) {
            tlsStrategyBuilder.setHostnameVerifier(builder.hostnameVerifier);
        }
        return httpClientBuilder.setTlsStrategy(tlsStrategyBuilder.build()).build();
    }

    private static SSLContext constructSslContext(FeedClientBuilder builder) throws IOException {
        if (builder.sslContext != null) {
            return builder.sslContext;
        }
        SslContextBuilder sslContextBuilder = new SslContextBuilder();
        if (builder.certificate != null && builder.privateKey != null) {
            sslContextBuilder.withCertificateAndKey(builder.certificate, builder.privateKey);
        }
        if (builder.caCertificates != null) {
            sslContextBuilder.withCaCertificates(builder.caCertificates);
        }
        return sslContextBuilder.build();
    }

    private static class Endpoint {
        private final CloseableHttpAsyncClient client;
        private final AtomicInteger inflight = new AtomicInteger(0);
        private final URI url;

        private Endpoint(CloseableHttpAsyncClient client, URI url) {
            this.client = client;
            this.url = url;
            this.client.start();
        }
    }
}

