/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.GracePeriodCircuitBreaker;
import ai.vespa.feed.client.HttpFeedClient;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class FeedClientBuilder {
    static final FeedClient.RetryStrategy defaultRetryStrategy = new FeedClient.RetryStrategy(){};
    final List<URI> endpoints;
    final Map<String, Supplier<String>> requestHeaders = new HashMap<String, Supplier<String>>();
    SSLContext sslContext;
    HostnameVerifier hostnameVerifier;
    int connectionsPerEndpoint = 4;
    int maxStreamsPerConnection = 128;
    FeedClient.RetryStrategy retryStrategy = defaultRetryStrategy;
    FeedClient.CircuitBreaker circuitBreaker = new GracePeriodCircuitBreaker(Clock.systemUTC(), Duration.ofSeconds(1L), Duration.ofMinutes(10L));
    Path certificate;
    Path privateKey;
    Path caCertificates;

    public static FeedClientBuilder create(URI endpoint) {
        return new FeedClientBuilder(Collections.singletonList(endpoint));
    }

    public static FeedClientBuilder create(List<URI> endpoints) {
        return new FeedClientBuilder(endpoints);
    }

    private FeedClientBuilder(List<URI> endpoints) {
        if (endpoints.isEmpty()) {
            throw new IllegalArgumentException("At least one endpoint must be provided");
        }
        for (URI endpoint : endpoints) {
            Objects.requireNonNull(endpoint.getHost());
        }
        this.endpoints = new ArrayList<URI>(endpoints);
    }

    public FeedClientBuilder setConnectionsPerEndpoint(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Max connections must be at least 1, but was " + max);
        }
        this.connectionsPerEndpoint = max;
        return this;
    }

    public FeedClientBuilder setMaxStreamPerConnection(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Max streams per connection must be at least 1, but was " + max);
        }
        this.maxStreamsPerConnection = max;
        return this;
    }

    public FeedClientBuilder setSslContext(SSLContext context) {
        if (this.certificate != null || this.caCertificates != null || this.privateKey != null) {
            throw new IllegalArgumentException("Cannot set both SSLContext and certificate / CA certificates");
        }
        this.sslContext = Objects.requireNonNull(context);
        return this;
    }

    public FeedClientBuilder setHostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = Objects.requireNonNull(verifier);
        return this;
    }

    public FeedClientBuilder addRequestHeader(String name, String value) {
        return this.addRequestHeader(name, () -> Objects.requireNonNull(value));
    }

    public FeedClientBuilder addRequestHeader(String name, Supplier<String> valueSupplier) {
        this.requestHeaders.put(Objects.requireNonNull(name), Objects.requireNonNull(valueSupplier));
        return this;
    }

    public FeedClientBuilder setRetryStrategy(FeedClient.RetryStrategy strategy) {
        this.retryStrategy = Objects.requireNonNull(strategy);
        return this;
    }

    public FeedClientBuilder setCircuitBreaker(FeedClient.CircuitBreaker breaker) {
        this.circuitBreaker = Objects.requireNonNull(breaker);
        return this;
    }

    public FeedClientBuilder setCertificate(Path certificatePemFile, Path privateKeyPemFile) {
        if (this.sslContext != null) {
            throw new IllegalArgumentException("Cannot set both SSLContext and certificate");
        }
        this.certificate = certificatePemFile;
        this.privateKey = privateKeyPemFile;
        return this;
    }

    public FeedClientBuilder setCaCertificates(Path caCertificatesFile) {
        if (this.sslContext != null) {
            throw new IllegalArgumentException("Cannot set both SSLContext and CA certificate");
        }
        this.caCertificates = caCertificatesFile;
        return this;
    }

    public FeedClient build() {
        try {
            return new HttpFeedClient(this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

