/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.DocumentId;
import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.feed.client.RequestStrategy;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;

class HttpRequestStrategy
implements RequestStrategy {
    private static final Logger log = Logger.getLogger(HttpRequestStrategy.class.getName());
    private final Map<DocumentId, CompletableFuture<Void>> inflightById = new HashMap<DocumentId, CompletableFuture<Void>>();
    private final Object lock = new Object();
    private final FeedClient.RetryStrategy wrapped;
    private final long maxInflight;
    private final long minInflight;
    private double targetInflight;
    private long inflight = 0L;
    private long consecutiveSuccesses = 0L;
    private boolean failed = false;
    private Instant lastSuccess = Instant.MAX;

    HttpRequestStrategy(FeedClientBuilder builder) {
        this.wrapped = builder.retryStrategy;
        this.maxInflight = (long)builder.maxConnections * (long)builder.maxStreamsPerConnection;
        this.minInflight = (long)builder.maxConnections * (long)Math.min(16, builder.maxStreamsPerConnection);
        this.targetInflight = Math.sqrt(this.maxInflight) * Math.sqrt(this.minInflight);
    }

    private boolean retry(SimpleHttpRequest request, int attempt) {
        if (attempt >= this.wrapped.retries()) {
            return false;
        }
        switch (request.getMethod().toUpperCase()) {
            case "POST": {
                return this.wrapped.retry(FeedClient.OperationType.put);
            }
            case "PUT": {
                return this.wrapped.retry(FeedClient.OperationType.update);
            }
            case "DELETE": {
                return this.wrapped.retry(FeedClient.OperationType.remove);
            }
        }
        throw new IllegalStateException("Unexpected HTTP method: " + request.getMethod());
    }

    private boolean retry(SimpleHttpRequest request, Throwable thrown, int attempt) {
        this.failure();
        log.log(Level.INFO, thrown, () -> "Failed attempt " + attempt + " at " + request + ", " + this.consecutiveSuccesses + " successes since last error");
        if (!(thrown instanceof IOException)) {
            return false;
        }
        return this.retry(request, attempt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void success() {
        Instant now = Instant.now();
        Object object = this.lock;
        synchronized (object) {
            ++this.consecutiveSuccesses;
            this.lastSuccess = now;
            this.targetInflight = Math.min(this.targetInflight + 0.1, (double)this.maxInflight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failure() {
        Instant threshold = Instant.now().minusSeconds(300L);
        Object object = this.lock;
        synchronized (object) {
            this.consecutiveSuccesses = 0L;
            if (this.lastSuccess.isBefore(threshold)) {
                this.failed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retry(SimpleHttpRequest request, SimpleHttpResponse response, int attempt) {
        if (response.getCode() / 100 == 2) {
            this.success();
            return false;
        }
        log.log(Level.INFO, () -> "Status code " + response.getCode() + " (" + response.getBodyText() + ") on attempt " + attempt + " at " + request + ", " + this.consecutiveSuccesses + " successes since last error");
        if (response.getCode() == 429 || response.getCode() == 503) {
            Object object = this.lock;
            synchronized (object) {
                this.targetInflight = Math.max((double)this.inflight * 0.9, (double)this.minInflight);
            }
            return true;
        }
        this.failure();
        if (response.getCode() != 500 && response.getCode() != 502) {
            return false;
        }
        return this.retry(request, attempt);
    }

    private void acquireSlot() {
        try {
            while ((double)this.inflight >= this.targetInflight) {
                this.lock.wait();
            }
            ++this.inflight;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void releaseSlot() {
        long i = --this.inflight;
        while ((double)i < this.targetInflight) {
            this.lock.notify();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFailed() {
        Object object = this.lock;
        synchronized (object) {
            return this.failed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<SimpleHttpResponse> enqueue(DocumentId documentId, SimpleHttpRequest request, BiConsumer<SimpleHttpRequest, CompletableFuture<SimpleHttpResponse>> dispatch) {
        CompletableFuture previous;
        CompletableFuture<SimpleHttpResponse> result = new CompletableFuture<SimpleHttpResponse>();
        CompletableFuture<SimpleHttpResponse> vessel = new CompletableFuture<SimpleHttpResponse>();
        CompletableFuture<Void> blocker = new CompletableFuture<Void>();
        Object object = this.lock;
        synchronized (object) {
            previous = this.inflightById.put(documentId, blocker);
            if (previous == null) {
                this.acquireSlot();
            }
        }
        if (previous == null) {
            dispatch.accept(request, vessel);
        } else {
            previous.thenRun(() -> dispatch.accept(request, vessel));
        }
        this.handleAttempt(vessel, dispatch, blocker, request, result, documentId, 1);
        return result;
    }

    private void handleAttempt(CompletableFuture<SimpleHttpResponse> vessel, BiConsumer<SimpleHttpRequest, CompletableFuture<SimpleHttpResponse>> dispatch, CompletableFuture<Void> blocker, SimpleHttpRequest request, CompletableFuture<SimpleHttpResponse> result, DocumentId documentId, int attempt) {
        vessel.whenComplete((response, thrown) -> {
            CompletableFuture<Void> current;
            if (!this.failed && (thrown != null ? this.retry(request, (Throwable)thrown, attempt) : this.retry(request, (SimpleHttpResponse)response, attempt))) {
                CompletableFuture<SimpleHttpResponse> retry = new CompletableFuture<SimpleHttpResponse>();
                dispatch.accept(request, retry);
                this.handleAttempt(retry, dispatch, blocker, request, result, documentId, attempt + 1);
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                current = this.inflightById.get(documentId);
                if (current == blocker) {
                    this.releaseSlot();
                    this.inflightById.put(documentId, null);
                }
            }
            if (current != blocker) {
                blocker.complete(null);
            }
            if (thrown == null) {
                result.complete((SimpleHttpResponse)response);
            } else {
                result.completeExceptionally((Throwable)thrown);
            }
        });
    }
}

