/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.DocumentId;
import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.FeedException;
import ai.vespa.feed.client.OperationParameters;
import ai.vespa.feed.client.OperationParseException;
import ai.vespa.feed.client.Result;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadConstraints;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JsonFeeder
implements Closeable {
    private static final Logger log = Logger.getLogger(JsonFeeder.class.getName());
    private final ExecutorService resultExecutor = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "json-feeder-result-executor");
        t.setDaemon(true);
        return t;
    });
    private final FeedClient client;
    private final OperationParameters protoParameters;
    private final AtomicInteger globalInflightOperations = new AtomicInteger(0);
    private volatile boolean closed = false;
    private static final JsonFactory factory = ((JsonFactoryBuilder)new JsonFactoryBuilder().streamReadConstraints(StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build())).build();

    private JsonFeeder(FeedClient client, OperationParameters protoParameters) {
        this.client = client;
        this.protoParameters = protoParameters;
    }

    public static Builder builder(FeedClient client) {
        return new Builder(client);
    }

    public CompletableFuture<Result> feedSingle(String json) {
        if (this.closed) {
            throw new IllegalStateException("Already closed");
        }
        this.globalInflightOperations.incrementAndGet();
        CompletableFuture<Result> result = new CompletableFuture<Result>();
        try {
            SingleOperationParserAndExecutor parser = new SingleOperationParserAndExecutor(json.getBytes(StandardCharsets.UTF_8));
            parser.next().whenCompleteAsync((operationResult, error) -> {
                if (error != null) {
                    result.completeExceptionally((Throwable)error);
                } else {
                    result.complete((Result)operationResult);
                }
                this.globalInflightOperations.decrementAndGet();
            }, (Executor)this.resultExecutor);
        }
        catch (Exception e) {
            this.resultExecutor.execute(() -> result.completeExceptionally(this.wrapException(e)));
            this.globalInflightOperations.decrementAndGet();
        }
        return result;
    }

    public CompletableFuture<Void> feedMany(InputStream jsonStream, ResultCallback resultCallback) {
        return this.feedMany(jsonStream, 0x4000000, resultCallback);
    }

    public CompletableFuture<Void> feedMany(InputStream jsonStream) {
        return this.feedMany(jsonStream, new ResultCallback(){});
    }

    CompletableFuture<Void> feedMany(InputStream jsonStream, int size, ResultCallback resultCallback) {
        CompletableFuture<Void> overallResult;
        block10: {
            if (this.closed) {
                throw new IllegalStateException("Already closed");
            }
            overallResult = new CompletableFuture<Void>();
            AtomicInteger localInflightOperations = new AtomicInteger(1);
            AtomicBoolean finalCallbackInvoked = new AtomicBoolean();
            try (RingBufferStream buffer = new RingBufferStream(jsonStream, size);){
                CompletableFuture<Result> result;
                while ((result = buffer.next()) != null) {
                    localInflightOperations.incrementAndGet();
                    this.globalInflightOperations.incrementAndGet();
                    result.whenCompleteAsync((r, t) -> {
                        if (!finalCallbackInvoked.get()) {
                            JsonFeeder.invokeCallback(resultCallback, c -> c.onNextResult((Result)r, (FeedException)t));
                        }
                        if (localInflightOperations.decrementAndGet() == 0 && finalCallbackInvoked.compareAndSet(false, true)) {
                            JsonFeeder.invokeCallback(resultCallback, ResultCallback::onComplete);
                            overallResult.complete(null);
                        }
                        this.globalInflightOperations.decrementAndGet();
                    }, (Executor)this.resultExecutor);
                }
                if (localInflightOperations.decrementAndGet() == 0 && finalCallbackInvoked.compareAndSet(false, true)) {
                    this.resultExecutor.execute(() -> {
                        JsonFeeder.invokeCallback(resultCallback, ResultCallback::onComplete);
                        overallResult.complete(null);
                    });
                }
            }
            catch (Exception e) {
                if (!finalCallbackInvoked.compareAndSet(false, true)) break block10;
                this.resultExecutor.execute(() -> {
                    FeedException wrapped = this.wrapException(e);
                    JsonFeeder.invokeCallback(resultCallback, c -> c.onError(wrapped));
                    overallResult.completeExceptionally(wrapped);
                });
            }
        }
        return overallResult;
    }

    private static void invokeCallback(ResultCallback callback, Consumer<ResultCallback> invocation) {
        try {
            invocation.accept(callback);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Got exception during invocation on ResultCallback: " + t, t);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.awaitInflightOperations();
        this.client.close();
        this.resultExecutor.shutdown();
        try {
            if (!this.resultExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                throw new IOException("Failed to close client in time");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void awaitInflightOperations() {
        try {
            while (this.globalInflightOperations.get() > 0) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private FeedException wrapException(Exception e) {
        if (e instanceof FeedException) {
            return (FeedException)e;
        }
        if (e instanceof IOException) {
            return new OperationParseException("Failed to parse document JSON: " + e.getMessage(), (Throwable)e);
        }
        return new FeedException(e);
    }

    public static class Builder {
        final FeedClient client;
        OperationParameters parameters = OperationParameters.empty();

        private Builder(FeedClient client) {
            this.client = Objects.requireNonNull(client);
        }

        public Builder withTimeout(Duration timeout) {
            this.parameters = this.parameters.timeout(timeout);
            return this;
        }

        public Builder withRoute(String route) {
            this.parameters = this.parameters.route(route);
            return this;
        }

        public Builder withTracelevel(int tracelevel) {
            this.parameters = this.parameters.tracelevel(tracelevel);
            return this;
        }

        public JsonFeeder build() {
            return new JsonFeeder(this.client, this.parameters);
        }
    }

    private class SingleOperationParserAndExecutor
    extends OperationParserAndExecutor {
        private final byte[] json;

        SingleOperationParserAndExecutor(byte[] json) throws IOException {
            super(factory.createParser(json), false);
            this.json = json;
        }

        @Override
        String getDocumentJson(long start, long end) {
            return "{\"fields\":" + new String(this.json, (int)start, (int)(end - start), StandardCharsets.UTF_8) + "}";
        }
    }

    public static interface ResultCallback {
        default public void onNextResult(Result result, FeedException error) {
        }

        default public void onError(FeedException error) {
        }

        default public void onComplete() {
        }
    }

    private class RingBufferStream
    extends InputStream {
        private final byte[] b = new byte[1];
        private final InputStream in;
        private final Object lock = new Object();
        private byte[] data;
        private int size;
        private IOException thrown = null;
        private long tail = 0L;
        private long pos = 0L;
        private long head = 0L;
        private boolean done = false;
        private final OperationParserAndExecutor parserAndExecutor;
        private final byte[] prefix = "{\"fields\":".getBytes(StandardCharsets.UTF_8);

        RingBufferStream(InputStream in, int size) throws IOException {
            this.in = in;
            this.data = new byte[size];
            this.size = size;
            Thread filler = new Thread(this::fill, "feed-reader");
            filler.setDaemon(true);
            filler.start();
            this.parserAndExecutor = new RingBufferBackedOperationParserAndExecutor(factory.createParser((InputStream)this));
        }

        @Override
        public int read() throws IOException {
            return this.read(this.b, 0, 1) == -1 ? -1 : this.b[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buffer, int off, int len) throws IOException {
            try {
                int ready;
                Object object = this.lock;
                synchronized (object) {
                    if (this.pos - this.tail == (long)this.size) {
                        this.expand();
                    }
                    while ((ready = (int)(this.head - this.pos)) == 0 && !this.done) {
                        this.lock.wait();
                    }
                }
                if (this.thrown != null) {
                    throw this.thrown;
                }
                if (ready == 0) {
                    return -1;
                }
                ready = Math.min(ready, len);
                int offset = (int)(this.pos % (long)this.size);
                int length = Math.min(ready, this.size - offset);
                System.arraycopy(this.data, offset, buffer, off, length);
                if (length < ready) {
                    System.arraycopy(this.data, 0, buffer, off + length, ready - length);
                }
                this.pos += (long)ready;
                return ready;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted waiting for data: " + e.getMessage());
            }
        }

        public CompletableFuture<Result> next() throws IOException {
            return this.parserAndExecutor.next();
        }

        private void expand() {
            int newSize = this.size * 2;
            if (newSize <= this.size) {
                throw new IllegalStateException("Maximum buffer size exceeded; want to double " + this.size + ", but that's too much");
            }
            byte[] newData = new byte[newSize];
            int offset = (int)(this.tail % (long)this.size);
            int newOffset = (int)(this.tail % (long)newSize);
            int toWrite = this.size - offset;
            System.arraycopy(this.data, offset, newData, newOffset, toWrite);
            newOffset = (newOffset + toWrite) % newSize;
            System.arraycopy(this.data, 0, newData, newOffset, offset);
            this.size = newSize;
            this.data = newData;
            this.lock.notify();
        }

        private byte[] copy(long start, long end) {
            int length = (int)(end - start);
            byte[] buffer = new byte[this.prefix.length + length + 1];
            System.arraycopy(this.prefix, 0, buffer, 0, this.prefix.length);
            int offset = (int)(start % (long)this.size);
            int toWrite = Math.min(length, this.size - offset);
            System.arraycopy(this.data, offset, buffer, this.prefix.length, toWrite);
            if (toWrite < length) {
                System.arraycopy(this.data, 0, buffer, this.prefix.length + toWrite, length - toWrite);
            }
            buffer[buffer.length - 1] = 125;
            return buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.done = true;
                this.lock.notifyAll();
            }
            this.in.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void fill() {
            try {
                while (true) {
                    int free;
                    Object object = this.lock;
                    // MONITORENTER : object
                    while ((free = (int)(this.tail + (long)this.size - this.head)) <= 0 && !this.done) {
                        this.lock.wait();
                    }
                    // MONITOREXIT : object
                    if (this.done) {
                        return;
                    }
                    int off = (int)(this.head % (long)this.size);
                    int len = Math.min(Math.min(free, this.size - off), 8192);
                    int read = this.in.read(this.data, off, len);
                    Object object2 = this.lock;
                    // MONITORENTER : object2
                    if (read < 0) {
                        this.done = true;
                    } else {
                        this.head += (long)read;
                    }
                    this.lock.notify();
                    // MONITOREXIT : object2
                }
            }
            catch (InterruptedException e) {
                Object object = this.lock;
                // MONITORENTER : object
                this.done = true;
                this.thrown = new InterruptedIOException("Interrupted reading data: " + e.getMessage());
                // MONITOREXIT : object
                return;
            }
            catch (IOException e) {
                Object object = this.lock;
                // MONITORENTER : object
                this.done = true;
                this.thrown = e;
                // MONITOREXIT : object
                return;
            }
        }

        private class RingBufferBackedOperationParserAndExecutor
        extends OperationParserAndExecutor {
            RingBufferBackedOperationParserAndExecutor(JsonParser parser) {
                super(parser, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            String getDocumentJson(long start, long end) {
                String payload = new String(RingBufferStream.this.copy(start, end), StandardCharsets.UTF_8);
                Object object = RingBufferStream.this.lock;
                synchronized (object) {
                    RingBufferStream.this.tail = end;
                    RingBufferStream.this.lock.notify();
                }
                return payload;
            }
        }
    }

    private abstract class OperationParserAndExecutor {
        private final JsonParser parser;
        private final boolean multipleOperations;
        private boolean arrayPrefixParsed;

        protected OperationParserAndExecutor(JsonParser parser, boolean multipleOperations) {
            this.parser = parser;
            this.multipleOperations = multipleOperations;
        }

        abstract String getDocumentJson(long var1, long var3);

        OperationParseException parseException(String error) {
            JsonLocation location = this.parser.currentLocation();
            return new OperationParseException(error + " at offset " + location.getByteOffset() + " (line " + location.getLineNr() + ", column " + location.getColumnNr() + ")");
        }

        CompletableFuture<Result> next() throws IOException {
            JsonToken token = this.parser.nextToken();
            if (this.multipleOperations && !this.arrayPrefixParsed && token == JsonToken.START_ARRAY) {
                this.arrayPrefixParsed = true;
                token = this.parser.nextToken();
            }
            if (token == JsonToken.END_ARRAY && this.multipleOperations) {
                return null;
            }
            if (token == null && !this.arrayPrefixParsed) {
                return null;
            }
            if (token != JsonToken.START_OBJECT) {
                throw this.parseException("Unexpected token '" + this.parser.currentToken() + "'");
            }
            long start = 0L;
            long end = -1L;
            FeedClient.OperationType type = null;
            DocumentId id = null;
            OperationParameters parameters = JsonFeeder.this.protoParameters;
            block30: while (true) {
                switch (this.parser.nextToken()) {
                    case FIELD_NAME: {
                        switch (this.parser.getText()) {
                            case "id": 
                            case "put": {
                                type = FeedClient.OperationType.PUT;
                                id = this.readId();
                                continue block30;
                            }
                            case "update": {
                                type = FeedClient.OperationType.UPDATE;
                                id = this.readId();
                                continue block30;
                            }
                            case "remove": {
                                type = FeedClient.OperationType.REMOVE;
                                id = this.readId();
                                continue block30;
                            }
                            case "condition": {
                                parameters = parameters.testAndSetCondition(this.readString());
                                continue block30;
                            }
                            case "create": {
                                parameters = parameters.createIfNonExistent(this.readBoolean());
                                continue block30;
                            }
                            case "fields": {
                                this.expect(JsonToken.START_OBJECT);
                                start = this.parser.currentTokenLocation().getByteOffset();
                                int depth = 1;
                                while (depth > 0) {
                                    switch (this.parser.nextToken()) {
                                        case START_OBJECT: {
                                            ++depth;
                                            break;
                                        }
                                        case END_OBJECT: {
                                            --depth;
                                        }
                                    }
                                }
                                end = this.parser.currentTokenLocation().getByteOffset() + 1L;
                                continue block30;
                            }
                        }
                        throw this.parseException("Unexpected field name '" + this.parser.getText() + "'");
                    }
                    case END_OBJECT: {
                        break block30;
                    }
                    default: {
                        throw this.parseException("Unexpected token '" + this.parser.currentToken() + "'");
                    }
                }
                break;
            }
            if (id == null) {
                throw this.parseException("No document id for document");
            }
            if (type == FeedClient.OperationType.REMOVE) {
                if (end >= start) {
                    throw this.parseException("Illegal 'fields' object for remove operation");
                }
                start = end = this.parser.currentTokenLocation().getByteOffset();
            } else if (end < start) {
                throw this.parseException("No 'fields' object for document");
            }
            String payload = this.getDocumentJson(start, end);
            switch (type) {
                case PUT: {
                    return JsonFeeder.this.client.put(id, payload, parameters);
                }
                case UPDATE: {
                    return JsonFeeder.this.client.update(id, payload, parameters);
                }
                case REMOVE: {
                    return JsonFeeder.this.client.remove(id, parameters);
                }
            }
            throw new OperationParseException("Unexpected operation type '" + type + "'");
        }

        private void expect(JsonToken token) throws IOException {
            if (this.parser.nextToken() != token) {
                throw new OperationParseException("Expected '" + token + "' at offset " + this.parser.currentTokenLocation().getByteOffset() + ", but found '" + this.parser.currentToken() + "' (" + this.parser.getText() + ")");
            }
        }

        private String readString() throws IOException {
            String value = this.parser.nextTextValue();
            if (value == null) {
                throw new OperationParseException("Expected '" + JsonToken.VALUE_STRING + "' at offset " + this.parser.currentTokenLocation().getByteOffset() + ", but found '" + this.parser.currentToken() + "' (" + this.parser.getText() + ")");
            }
            return value;
        }

        private boolean readBoolean() throws IOException {
            Boolean value = this.parser.nextBooleanValue();
            if (value == null) {
                throw new OperationParseException("Expected '" + JsonToken.VALUE_FALSE + "' or '" + JsonToken.VALUE_TRUE + "' at offset " + this.parser.currentTokenLocation().getByteOffset() + ", but found '" + this.parser.currentToken() + "' (" + this.parser.getText() + ")");
            }
            return value;
        }

        private DocumentId readId() throws IOException {
            return DocumentId.of(this.readString());
        }
    }
}

