/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.test.json;

import com.fasterxml.jackson.core.io.JsonStringEncoder;

class JsonBuilder {
    private final JsonStringEncoder jsonStringEncoder = JsonStringEncoder.getInstance();
    private final StringBuilder builder = new StringBuilder();
    private final String indentation;
    private final boolean multiLine;
    private final String colon;
    private boolean bol = true;
    private int level = 0;

    static JsonBuilder forCompactJson() {
        return new JsonBuilder(0, true);
    }

    static JsonBuilder forMultiLineJson(int spacesPerIndent) {
        return new JsonBuilder(spacesPerIndent, false);
    }

    JsonBuilder(int spacesPerIndent, boolean compact) {
        this.indentation = compact ? "" : " ".repeat(spacesPerIndent);
        this.multiLine = !compact;
        this.colon = compact ? ":" : ": ";
    }

    void appendLineAndIndent(String text) {
        this.appendLineAndIndent(text, 0);
    }

    void newLineIndentAndAppend(int levelShift, String text) {
        this.appendNewLine();
        this.indent(levelShift);
        this.append(text);
    }

    void appendLineAndIndent(String text, int levelShift) {
        this.appendLine(text);
        this.indent(levelShift);
        this.append("");
    }

    void appendColon() {
        this.builder.append(this.colon);
    }

    void appendStringValue(String rawString) {
        this.builder.append('\"');
        this.jsonStringEncoder.quoteAsString((CharSequence)rawString, this.builder);
        this.builder.append('\"');
    }

    void append(String textWithoutNewline) {
        if (this.bol) {
            this.builder.append(this.indentation.repeat(this.level));
            this.bol = false;
        }
        this.builder.append(textWithoutNewline);
    }

    private void indent(int levelShift) {
        this.level += levelShift;
    }

    private void appendLine(String text) {
        this.append(text);
        this.appendNewLine();
    }

    private void appendNewLine() {
        if (this.multiLine) {
            this.builder.append('\n');
        }
        this.bol = true;
    }

    public String toString() {
        return this.builder.toString();
    }
}

