/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.test;

import java.util.ArrayList;
import java.util.List;

public abstract class OrderTester<T extends Comparable<? super T>> {
    private final ArrayList<List<T>> groups = new ArrayList();

    protected abstract void lessTest(T var1, T var2);

    protected abstract void greaterTest(T var1, T var2);

    protected abstract void equalTest(T var1, T var2);

    @SafeVarargs
    private OrderTester<T> addGroup(T ... group) {
        this.groups.add(List.of(group));
        return this;
    }

    @SafeVarargs
    public final OrderTester<T> theseObjects(T ... group) {
        return this.addGroup((Comparable[])group);
    }

    @SafeVarargs
    public final OrderTester<T> areLessThan(T ... group) {
        return this.addGroup((Comparable[])group);
    }

    public void testOrdering() {
        for (int i = 0; i < this.groups.size(); ++i) {
            for (Comparable item : this.groups.get(i)) {
                for (Comparable otherItem : this.groups.get(i)) {
                    this.equalTest(item, otherItem);
                }
            }
            for (int j = i + 1; j < this.groups.size(); ++j) {
                for (Comparable lessItem : this.groups.get(i)) {
                    for (Comparable greaterItem : this.groups.get(j)) {
                        this.lessTest(lessItem, greaterItem);
                        this.greaterTest(greaterItem, lessItem);
                    }
                }
            }
        }
    }
}

