/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.test.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.yahoo.test.JunitCompat;
import com.yahoo.test.json.Jackson;
import com.yahoo.test.json.JsonNodeFormatter;
import java.io.IOException;
import java.io.UncheckedIOException;

public class JsonTestHelper {
    private static final ObjectMapper mapper = Jackson.mapper();

    public static String normalize(String json) {
        JsonNode jsonNode;
        try {
            jsonNode = mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid JSON", e);
        }
        return JsonNodeFormatter.toNormalizedJson(jsonNode, false);
    }

    public static String inputJson(String ... lines) {
        return Joiner.on((String)"\n").join((Object[])lines).replaceAll("'", "\"");
    }

    public static void assertJsonEquals(String inputJson, String expectedJson) {
        try {
            JsonNode expected = mapper.readTree(expectedJson);
            JsonNode actual = mapper.readTree(inputJson);
            JunitCompat.assertEquals(expected, actual);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Exception when comparing json strings.", e);
        }
    }

    public static void assertJsonEquals(JsonNode left, String rightJson) {
        try {
            String leftJson = mapper.writeValueAsString((Object)left);
            JsonTestHelper.assertJsonEquals(leftJson, rightJson);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static void assertJsonEquals(JsonNode left, JsonNode right) {
        try {
            String leftJson = mapper.writeValueAsString((Object)left);
            String rightJson = mapper.writeValueAsString((Object)right);
            JsonTestHelper.assertJsonEquals(leftJson, rightJson);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }
}

