/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class JunitCompat {
    private JunitCompat() {
    }

    public static <T> void assertEquals(T l, T r) {
        List<Class<?>> argTypes = List.of(Object.class, Object.class);
        List<Object> argValues = List.of(l, r);
        JunitCompat.invokeAssert("assertEquals", argTypes, argValues, argTypes, argValues);
    }

    public static void assertEquals(String msg, long l, long r) {
        List<Class<?>> junit4ArgTypes = List.of(String.class, Long.TYPE, Long.TYPE);
        List<Object> junit4ArgValues = List.of(msg, Long.valueOf(l), Long.valueOf(r));
        List<Class<?>> junit5ArgTypes = List.of(Long.TYPE, Long.TYPE, String.class);
        List<Object> junit5ArgValues = List.of(Long.valueOf(l), Long.valueOf(r), msg);
        JunitCompat.invokeAssert("assertEquals", junit4ArgTypes, junit4ArgValues, junit5ArgTypes, junit5ArgValues);
    }

    public static void assertTrue(String msg, boolean b) {
        List<Class<?>> junit4ArgTypes = List.of(String.class, Boolean.TYPE);
        List<Object> junit4ArgValues = List.of(msg, Boolean.valueOf(b));
        List<Class<?>> junit5ArgTypes = List.of(Boolean.TYPE, String.class);
        List<Object> junit5ArgValues = List.of(Boolean.valueOf(b), msg);
        JunitCompat.invokeAssert("assertTrue", junit4ArgTypes, junit4ArgValues, junit5ArgTypes, junit5ArgValues);
    }

    private static void invokeAssert(String method, List<Class<?>> junit4ArgTypes, List<Object> junit4ArgValues, List<Class<?>> junit5ArgTypes, List<Object> junit5ArgValues) {
        try {
            JunitCompat.invokeAssert("org.junit.jupiter.api.Assertions", method, junit5ArgTypes, junit5ArgValues);
        }
        catch (ReflectiveOperationException e) {
            try {
                JunitCompat.invokeAssert("org.junit.Assert", method, junit4ArgTypes, junit4ArgValues);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Unable to find junit4 or junit5 on test classpath", ex);
            }
        }
    }

    private static void invokeAssert(String clazz, String method, List<Class<?>> argTypes, List<Object> argValues) throws ReflectiveOperationException {
        try {
            Class<?> c = Class.forName(clazz);
            Method m = c.getMethod(method, argTypes.toArray(new Class[0]));
            m.invoke(null, argValues.toArray());
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof AssertionError) {
                AssertionError ae = (AssertionError)((Object)throwable);
                throw ae;
            }
            throw new RuntimeException(e.getCause());
        }
    }
}

