/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.cd;

import ai.vespa.cloud.Zone;
import ai.vespa.hosted.cd.Deployment;
import ai.vespa.hosted.cd.internal.TestRuntimeProvider;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.osgi.framework.BundleReference;

public interface TestRuntime {
    public static final Logger logger = Logger.getLogger(TestRuntime.class.getName());

    public static TestRuntime get() {
        ClassLoader classloader = TestRuntime.class.getClassLoader();
        if (classloader instanceof BundleReference) {
            logger.info("Loading Test runtime from TestRuntimeProvider");
            return Optional.ofNullable(TestRuntimeProvider.getTestRuntime()).orElseThrow(() -> new RuntimeException("Component graph not ready, retrying"));
        }
        logger.info("Loading Test runtime from ServiceLoader");
        ServiceLoader<TestRuntime> serviceLoader = ServiceLoader.load(TestRuntime.class, TestRuntime.class.getClassLoader());
        return serviceLoader.findFirst().orElseThrow(() -> new RuntimeException("No TestRuntime implementation found"));
    }

    public Deployment deploymentToTest();

    public Zone zone();
}

