/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.token;

import com.yahoo.security.ArrayUtils;
import com.yahoo.security.token.TokenFingerprint;
import java.util.Arrays;

public record TokenDomain(byte[] checkHashContext) {
    public TokenDomain {
        if (Arrays.equals(checkHashContext, TokenFingerprint.FINGERPRINT_CONTEXT)) {
            throw new IllegalArgumentException("Fingerprint and check hash contexts can not be equal");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenDomain that = (TokenDomain)o;
        return Arrays.equals(this.checkHashContext, that.checkHashContext);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.checkHashContext);
    }

    @Override
    public String toString() {
        return "'%s'".formatted(ArrayUtils.fromUtf8Bytes(this.checkHashContext));
    }

    public static TokenDomain of(String checkHashContext) {
        return new TokenDomain(ArrayUtils.toUtf8Bytes(checkHashContext));
    }
}

