/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.hpke;

import com.yahoo.security.HKDF;
import com.yahoo.security.hpke.Kdf;

final class HkdfSha256
implements Kdf {
    private static final HkdfSha256 INSTANCE = new HkdfSha256();

    HkdfSha256() {
    }

    public static HkdfSha256 getInstance() {
        return INSTANCE;
    }

    @Override
    public byte[] extract(byte[] salt, byte[] labeledIkm) {
        return (salt.length != 0 ? HKDF.extractedFrom(salt, labeledIkm) : HKDF.unsaltedExtractedFrom(labeledIkm)).pseudoRandomKey();
    }

    @Override
    public byte[] expand(byte[] prk, byte[] info, int nBytesToExpand) {
        return HKDF.ofPseudoRandomKey(prk).expand(nBytesToExpand, info);
    }

    @Override
    public short nH() {
        return 32;
    }

    @Override
    public short kdfId() {
        return 1;
    }
}

