/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import java.util.Arrays;

public enum CapabilityMode {
    DISABLE("disable"),
    LOG_ONLY("log_only"),
    ENFORCE("enforce");

    private final String configValue;

    private CapabilityMode(String configValue) {
        this.configValue = configValue;
    }

    public String configValue() {
        return this.configValue;
    }

    public static CapabilityMode defaultValue() {
        return DISABLE;
    }

    public static CapabilityMode fromConfigValue(String configValue) {
        return Arrays.stream(CapabilityMode.values()).filter(c -> c.configValue.equals(configValue)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown value: " + configValue));
    }
}

