/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.AeadCipher;
import com.yahoo.security.ArrayUtils;
import com.yahoo.security.ChaCha20Poly1305AeadBlockCipherAdapter;
import com.yahoo.security.HKDF;
import com.yahoo.security.KeyId;
import com.yahoo.security.SealedSharedKey;
import com.yahoo.security.SecretSharedKey;
import com.yahoo.security.hpke.Aead;
import com.yahoo.security.hpke.Ciphersuite;
import com.yahoo.security.hpke.Hpke;
import com.yahoo.security.hpke.Kdf;
import com.yahoo.security.hpke.Kem;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.ChaCha20Poly1305;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public class SharedKeyGenerator {
    private static final int AES_GCM_KEY_BITS = 128;
    private static final int AES_GCM_AUTH_TAG_BITS = 128;
    private static final int CHACHA20_POLY1305_KEY_BITS = 256;
    private static final int CHACHA20_POLY1305_AUTH_TAG_BITS = 128;
    private static final byte[] CHACHA20_POLY1305_KDF_CONTEXT = ArrayUtils.toUtf8Bytes("ChaCha20Poly1305 key expansion");
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final SecureRandom SHARED_CSPRNG = new SecureRandom();
    private static final Ciphersuite HPKE_CIPHERSUITE = Ciphersuite.of(Kem.dHKemX25519HkdfSha256(), Kdf.hkdfSha256(), Aead.aes128Gcm());
    private static final Hpke HPKE = Hpke.of(HPKE_CIPHERSUITE);
    private static final byte[] FIXED_96BIT_IV_FOR_SINGLE_USE_KEY = new byte[]{104, 101, 114, 101, 66, 100, 114, 97, 103, 111, 110, 115};

    private static SecretKey generateRandomSecretAesKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(128, SHARED_CSPRNG);
            return keyGen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static SecretSharedKey generateForReceiverPublicKey(PublicKey receiverPublicKey, KeyId keyId) {
        SecretKey secretKey = SharedKeyGenerator.generateRandomSecretAesKey();
        return SharedKeyGenerator.internalSealSecretKeyForReceiver(2, secretKey, receiverPublicKey, keyId);
    }

    public static SecretSharedKey fromSealedKey(SealedSharedKey sealedKey, PrivateKey receiverPrivateKey) {
        byte[] secretKeyBytes = HPKE.openBase(sealedKey.enc(), (XECPrivateKey)receiverPrivateKey, EMPTY_BYTES, sealedKey.keyId().asBytes(), sealedKey.ciphertext());
        return new SecretSharedKey(new SecretKeySpec(secretKeyBytes, "AES"), sealedKey);
    }

    public static SecretSharedKey reseal(SecretSharedKey secret, PublicKey receiverPublicKey, KeyId keyId) {
        return SharedKeyGenerator.internalSealSecretKeyForReceiver(secret.sealedSharedKey().tokenVersion(), secret.secretKey(), receiverPublicKey, keyId);
    }

    private static SecretSharedKey internalSealSecretKeyForReceiver(int tokenVersion, SecretKey secretKey, PublicKey receiverPublicKey, KeyId keyId) {
        Hpke.Sealed sealed = HPKE.sealBase((XECPublicKey)receiverPublicKey, EMPTY_BYTES, keyId.asBytes(), secretKey.getEncoded());
        SealedSharedKey sealedSharedKey = new SealedSharedKey(tokenVersion, keyId, sealed.enc(), sealed.ciphertext());
        return new SecretSharedKey(secretKey, sealedSharedKey);
    }

    private static AeadCipher makeAesGcmCipher(SecretSharedKey secretSharedKey, boolean forEncryption) {
        AEADParameters aeadParams = new AEADParameters(new KeyParameter(secretSharedKey.secretKey().getEncoded()), 128, FIXED_96BIT_IV_FOR_SINGLE_USE_KEY);
        GCMBlockCipher cipher = new GCMBlockCipher((BlockCipher)new AESEngine());
        cipher.init(forEncryption, (CipherParameters)aeadParams);
        return AeadCipher.of((AEADBlockCipher)cipher);
    }

    private static AeadCipher makeChaCha20Poly1305Cipher(SecretSharedKey secretSharedKey, boolean forEncryption) {
        byte[] expandedKey = HKDF.unsaltedExtractedFrom(secretSharedKey.secretKey().getEncoded()).expand(32, CHACHA20_POLY1305_KDF_CONTEXT);
        AEADParameters aeadParams = new AEADParameters(new KeyParameter(expandedKey), 128, FIXED_96BIT_IV_FOR_SINGLE_USE_KEY);
        ChaCha20Poly1305 cipher = new ChaCha20Poly1305();
        cipher.init(forEncryption, (CipherParameters)aeadParams);
        return AeadCipher.of(new ChaCha20Poly1305AeadBlockCipherAdapter(cipher));
    }

    static AeadCipher makeAesGcmEncryptionCipher(SecretSharedKey secretSharedKey) {
        return SharedKeyGenerator.makeAesGcmCipher(secretSharedKey, true);
    }

    static AeadCipher makeAesGcmDecryptionCipher(SecretSharedKey secretSharedKey) {
        return SharedKeyGenerator.makeAesGcmCipher(secretSharedKey, false);
    }

    static AeadCipher makeChaCha20Poly1305EncryptionCipher(SecretSharedKey secretSharedKey) {
        return SharedKeyGenerator.makeChaCha20Poly1305Cipher(secretSharedKey, true);
    }

    static AeadCipher makeChaCha20Poly1305DecryptionCipher(SecretSharedKey secretSharedKey) {
        return SharedKeyGenerator.makeChaCha20Poly1305Cipher(secretSharedKey, false);
    }
}

