/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.vespa.jdk8compat.Set;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public interface TlsContext
extends AutoCloseable {
    public static final java.util.Set<String> ALLOWED_CIPHER_SUITES = Set.of("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256");
    public static final java.util.Set<String> ALLOWED_PROTOCOLS = Set.of("TLSv1.2", "TLSv1.3");
    public static final String SSL_CONTEXT_VERSION = "TLS";

    public static java.util.Set<String> getAllowedCipherSuites(SSLContext context) {
        Object[] supportedCiphers = context.getSupportedSSLParameters().getCipherSuites();
        java.util.Set<String> enabledCiphers = Arrays.stream(supportedCiphers).filter(ALLOWED_CIPHER_SUITES::contains).collect(Collectors.toSet());
        if (enabledCiphers.isEmpty()) {
            throw new IllegalArgumentException(String.format("Non of the allowed ciphers are supported (allowed=%s, supported=%s)", ALLOWED_CIPHER_SUITES, Arrays.toString(supportedCiphers)));
        }
        return enabledCiphers;
    }

    public static java.util.Set<String> getAllowedProtocols(SSLContext context) {
        Object[] supportedProtocols = context.getSupportedSSLParameters().getProtocols();
        java.util.Set<String> enabledProtocols = Arrays.stream(supportedProtocols).filter(ALLOWED_PROTOCOLS::contains).collect(Collectors.toSet());
        if (enabledProtocols.isEmpty()) {
            throw new IllegalArgumentException(String.format("Non of the allowed protocols are supported (allowed=%s, supported=%s)", ALLOWED_PROTOCOLS, Arrays.toString(supportedProtocols)));
        }
        return enabledProtocols;
    }

    public SSLContext context();

    public SSLParameters parameters();

    public SSLEngine createSslEngine();

    public SSLEngine createSslEngine(String var1, int var2);

    @Override
    default public void close() {
    }
}

