/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.https;

import com.yahoo.security.tls.https.TlsAwareHttpRequest;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

class TlsAwareHttpClient
extends HttpClient {
    private final HttpClient wrappedClient;
    private final String userAgent;

    TlsAwareHttpClient(HttpClient wrappedClient, String userAgent) {
        this.wrappedClient = wrappedClient;
        this.userAgent = userAgent;
    }

    @Override
    public Optional<CookieHandler> cookieHandler() {
        return this.wrappedClient.cookieHandler();
    }

    @Override
    public Optional<Duration> connectTimeout() {
        return this.wrappedClient.connectTimeout();
    }

    @Override
    public HttpClient.Redirect followRedirects() {
        return this.wrappedClient.followRedirects();
    }

    @Override
    public Optional<ProxySelector> proxy() {
        return this.wrappedClient.proxy();
    }

    @Override
    public SSLContext sslContext() {
        return this.wrappedClient.sslContext();
    }

    @Override
    public SSLParameters sslParameters() {
        return this.wrappedClient.sslParameters();
    }

    @Override
    public Optional<Authenticator> authenticator() {
        return this.wrappedClient.authenticator();
    }

    @Override
    public HttpClient.Version version() {
        return this.wrappedClient.version();
    }

    @Override
    public Optional<Executor> executor() {
        return this.wrappedClient.executor();
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        return this.wrappedClient.send(this.wrapRequest(request), responseBodyHandler);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) {
        return this.wrappedClient.sendAsync(this.wrapRequest(request), responseBodyHandler);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler, HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
        return this.wrappedClient.sendAsync(this.wrapRequest(request), responseBodyHandler, pushPromiseHandler);
    }

    public String toString() {
        return this.wrappedClient.toString();
    }

    private HttpRequest wrapRequest(HttpRequest request) {
        return new TlsAwareHttpRequest(request, this.userAgent);
    }
}

