/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.BucketResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class FloatBucketResultNode
extends BucketResultNode {
    public static final int classId = FloatBucketResultNode.registerClass((int)16486, FloatBucketResultNode.class, FloatBucketResultNode::new);
    private double from = 0.0;
    private double to = 0.0;

    @Override
    public boolean empty() {
        return this.to == this.from;
    }

    public FloatBucketResultNode() {
    }

    public FloatBucketResultNode(double from, double to) {
        this.from = from;
        this.to = to;
    }

    public double getFrom() {
        return this.from;
    }

    public double getTo() {
        return this.to;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        buf.putDouble(null, this.from);
        buf.putDouble(null, this.to);
    }

    protected void onDeserialize(Deserializer buf) {
        this.from = buf.getDouble(null);
        this.to = buf.getDouble(null);
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        if (classId != rhs.getClassId()) {
            return classId - rhs.getClassId();
        }
        FloatBucketResultNode b = (FloatBucketResultNode)rhs;
        double f1 = this.from;
        double f2 = b.from;
        if (f1 < f2) {
            return -1;
        }
        if (f1 > f2) {
            return 1;
        }
        double t1 = this.to;
        double t2 = b.to;
        if (f1 == f2) {
            if (t1 == t2) {
                return 0;
            }
            if (t1 < t2) {
                return -1;
            }
            if (t1 > t2) {
                return 1;
            }
            if (Double.isNaN(t1)) {
                if (Double.isNaN(t2)) {
                    return 0;
                }
                return -1;
            }
            if (Double.isNaN(t2)) {
                return 1;
            }
        } else {
            if (Double.isNaN(f1)) {
                if (Double.isNaN(f2)) {
                    return 0;
                }
                return -1;
            }
            if (Double.isNaN(f2)) {
                return 1;
            }
        }
        throw new IllegalArgumentException(String.format("bad comparison [%f,%f> versus [%f,%f>", f1, t1, f2, t2));
    }

    public int hashCode() {
        return super.hashCode() + (int)this.from + (int)this.to;
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("from", (Object)this.from);
        visitor.visit("to", (Object)this.to);
    }
}

