/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.tensor;

import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.evaluation.MapContext;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.ObjectTraverser;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Optional;

public class EvaluateTensorConformance {
    OutputStream outStream = new BufferedOutputStream(System.out);

    public static void main(String[] args) {
        EvaluateTensorConformance app = new EvaluateTensorConformance();
        app.evaluateStdIn();
    }

    void evaluateStdIn() {
        int count = 0;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(System.in));){
            String test = br.readLine();
            while (test != null) {
                boolean success = this.testCase(test, count);
                if (!success) {
                    System.err.println("FAILED testcase " + count);
                }
                ++count;
                test = br.readLine();
            }
        }
        catch (IOException e) {
            System.err.println(count + " FAILED : " + e.toString());
        }
    }

    void output(Slime result) {
        try {
            new JsonFormat(true).encode(this.outStream, result);
            this.outStream.write(10);
            this.outStream.flush();
        }
        catch (IOException e) {
            System.err.println("FAILED writing output: " + String.valueOf(e));
            System.exit(1);
        }
    }

    private boolean testCase(String test, int count) {
        boolean wasOk = false;
        try {
            Slime input = SlimeUtils.jsonToSlime((String)test);
            Slime result = new Slime();
            Cursor top = result.setObject();
            SlimeUtils.copyObject((Inspector)input.get(), (Cursor)top);
            Cursor num_tests = input.get().field("num_tests");
            if (input.get().field("num_tests").valid()) {
                long expect = input.get().field("num_tests").asLong();
                wasOk = expect == (long)count;
            } else if (input.get().field("expression").valid()) {
                String expression = input.get().field("expression").asString();
                MapContext context = this.getInput((Inspector)input.get().field("inputs"));
                Tensor actual = this.evaluate(expression, context);
                top.field("result").setData("vespajlib", TypedBinaryFormat.encode((Tensor)actual));
                wasOk = true;
            } else {
                System.err.println(count + " : Invalid input >>>" + test + "<<<");
                wasOk = false;
            }
            this.output(result);
        }
        catch (Exception e) {
            System.err.println(count + " : " + e.toString());
            wasOk = false;
        }
        return wasOk;
    }

    private Tensor evaluate(String expression, MapContext context) throws ParseException {
        Value value = new RankingExpression(expression).evaluate(context);
        return value.asTensor();
    }

    private MapContext getInput(Inspector inputs) {
        final MapContext context = new MapContext();
        inputs.traverse(new ObjectTraverser(){

            public void field(String name, Inspector contents) {
                String value = contents.asString();
                Tensor tensor = EvaluateTensorConformance.this.getTensor(value);
                context.put(name, new TensorValue(tensor));
            }
        });
        return context;
    }

    private Tensor getTensor(String binaryRepresentation) {
        byte[] bin = this.getBytes(binaryRepresentation);
        return TypedBinaryFormat.decode(Optional.empty(), (GrowableByteBuffer)GrowableByteBuffer.wrap((byte[])bin));
    }

    private byte[] getBytes(String binaryRepresentation) {
        return this.parseHexValue(binaryRepresentation.substring(2));
    }

    private byte[] parseHexValue(String s) {
        int len = s.length();
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int c1 = this.hexValue(Character.valueOf(s.charAt(i))) << 4;
            int c2 = this.hexValue(Character.valueOf(s.charAt(i + 1)));
            bytes[i / 2] = (byte)(c1 + c2);
        }
        return bytes;
    }

    private int hexValue(Character c) {
        if (c.charValue() >= 'a' && c.charValue() <= 'f') {
            return c.charValue() - 97 + 10;
        }
        if (c.charValue() >= 'A' && c.charValue() <= 'F') {
            return c.charValue() - 65 + 10;
        }
        if (c.charValue() >= '0' && c.charValue() <= '9') {
            return c.charValue() - 48;
        }
        throw new IllegalArgumentException("Hex contains illegal characters");
    }
}

