/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation.gbdtoptimization;

import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.evaluation.gbdtoptimization.GBDTNode;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import java.util.Arrays;
import java.util.Deque;
import java.util.Objects;

public class GBDTForestNode
extends ExpressionNode {
    private final double[] values;

    public GBDTForestNode(double[] values) {
        this.values = values;
    }

    @Override
    public final TensorType type(TypeContext<Reference> context) {
        return TensorType.empty;
    }

    @Override
    public final Value evaluate(Context context) {
        int nextTree;
        double treeSum = 0.0;
        for (int pc = 0; pc < this.values.length; pc += nextTree) {
            nextTree = (int)this.values[pc++];
            treeSum += GBDTNode.evaluate(this.values, pc, context);
        }
        return new DoubleValue(treeSum);
    }

    @Override
    public StringBuilder toString(StringBuilder string, SerializationContext context, Deque<String> path, CompositeNode parent) {
        return string.append("(optimized sum of condition trees of size ").append(this.values.length * 8).append(" bytes)");
    }

    @Override
    public int hashCode() {
        return Objects.hash("gbdtForest", Arrays.hashCode(this.values));
    }
}

