/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.ranking.features.fieldmatch;

import com.yahoo.searchlib.ranking.features.fieldmatch.FieldMatchMetrics;
import com.yahoo.searchlib.ranking.features.fieldmatch.FieldMatchMetricsComputer;

final class SegmentStartPoint {
    private FieldMatchMetricsComputer owner;
    private int i;
    private int skipI;
    private FieldMatchMetrics metrics;
    private int previousJ;
    private int semanticDistanceExplored = 0;
    boolean open = true;

    public SegmentStartPoint(FieldMatchMetrics metrics, FieldMatchMetricsComputer owner) {
        this.i = 0;
        this.previousJ = 0;
        this.metrics = metrics;
        this.owner = owner;
        this.semanticDistanceExplored = 0;
    }

    public SegmentStartPoint(int i, int previousJ, FieldMatchMetrics metrics, FieldMatchMetricsComputer owner) {
        this.i = i;
        this.previousJ = previousJ;
        this.metrics = metrics;
        this.owner = owner;
        this.semanticDistanceExplored = 0;
    }

    public SegmentStartPoint(int i, int j, int previousJ, FieldMatchMetrics metrics, FieldMatchMetricsComputer owner) {
        this.i = i;
        this.previousJ = previousJ;
        this.metrics = metrics;
        this.owner = owner;
        this.semanticDistanceExplored = owner.fieldIndexToSemanticDistance(j, previousJ) + 1;
    }

    public FieldMatchMetrics getMetrics() {
        return this.metrics;
    }

    public void exploredTo(int j) {
        this.semanticDistanceExplored = this.owner.fieldIndexToSemanticDistance(j, this.previousJ) + 1;
    }

    public void offerHistory(int offeredPreviousJ, FieldMatchMetrics offeredMetrics, boolean collectTrace) {
        if (offeredMetrics.getSegmentationScore() <= this.metrics.getSegmentationScore()) {
            if (collectTrace) {
                offeredMetrics.trace().add("    rejected offered history [match: " + offeredMetrics.getSegmentationScore() + " ending at:" + this.previousJ + "] at " + String.valueOf(this) + "\n");
            }
            return;
        }
        if (collectTrace) {
            offeredMetrics.trace().add("    accepted offered history [match: " + offeredMetrics.getSegmentationScore() + " ending at:" + this.previousJ + "] at " + String.valueOf(this) + "\n");
        }
        this.previousJ = offeredPreviousJ;
        this.metrics = offeredMetrics;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public int getI() {
        return this.i;
    }

    public int getPreviousJ() {
        return this.previousJ;
    }

    public int getSemanticDistanceExplored() {
        return this.semanticDistanceExplored;
    }

    public void setSemanticDistanceExplored(int distance) {
        this.semanticDistanceExplored = distance;
    }

    public int getStartI() {
        return this.i + this.skipI;
    }

    public void incrementStartI() {
        ++this.skipI;
    }

    public String toString() {
        if (this.i == this.owner.getQuery().getTerms().length) {
            return "last segment: Complete match: " + this.metrics.getMatch() + " previous j: " + this.previousJ + " (" + (this.open ? "open" : "closed") + ")";
        }
        return "segment at " + this.i + " (" + String.valueOf(this.owner.getQuery().getTerms()[this.i]) + "): Match up to here: " + this.metrics.getMatch() + " previous j: " + this.previousJ + " explored to: " + this.semanticDistanceExplored + " (" + (this.open ? "open" : "closed") + ")";
    }
}

