/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.UnaryFunctionNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public final class ArrayAtLookupNode
extends UnaryFunctionNode {
    public static final int classId = ArrayAtLookupNode.registerClass((int)16422, ArrayAtLookupNode.class, ArrayAtLookupNode::new);
    private String attribute;

    public ArrayAtLookupNode() {
    }

    public ArrayAtLookupNode(String attribute, ExpressionNode arg) {
        this.setAttributeName(attribute);
        this.addArg(arg);
    }

    public String getAttributeName() {
        return this.attribute;
    }

    private void setAttributeName(String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute name can not be null.");
        }
        this.attribute = attribute;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        this.putUtf8(buf, this.attribute);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.attribute = this.getUtf8(buf);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.attribute.hashCode();
    }

    @Override
    protected boolean equalsUnaryFunction(UnaryFunctionNode obj) {
        String otherAttr = ((ArrayAtLookupNode)obj).getAttributeName();
        return this.attribute.equals(otherAttr);
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("attribute", (Object)this.attribute);
    }
}

