/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation.hll;

import com.google.common.base.Preconditions;
import com.yahoo.searchlib.aggregation.hll.BiasEstimator;
import com.yahoo.searchlib.aggregation.hll.NormalSketch;
import com.yahoo.searchlib.aggregation.hll.Sketch;
import com.yahoo.searchlib.aggregation.hll.SparseSketch;
import com.yahoo.searchlib.aggregation.hll.UniqueCountEstimator;

public class HyperLogLogEstimator
implements UniqueCountEstimator<Sketch<?>> {
    private final int nBuckets;
    private final BiasEstimator biasEstimator;
    private final int linearCountingThreshold;
    private final double alphaCoefficient;

    public HyperLogLogEstimator(int precision) {
        Preconditions.checkArgument((precision >= 4 && precision <= 18 ? 1 : 0) != 0, (String)"Invalid precision: %s.", (int)precision);
        this.nBuckets = 1 << precision;
        this.biasEstimator = new BiasEstimator(precision);
        this.linearCountingThreshold = HyperLogLogEstimator.getLinearCountingThreshold(precision);
        this.alphaCoefficient = HyperLogLogEstimator.getAlphaCoefficient(this.nBuckets);
    }

    public HyperLogLogEstimator() {
        this(10);
    }

    @Override
    public long estimateCount(Sketch<?> sketch) {
        if (sketch instanceof NormalSketch) {
            return this.estimateCount((NormalSketch)sketch);
        }
        return this.estimateCount((SparseSketch)sketch);
    }

    @Override
    private long estimateCount(SparseSketch sketch) {
        return sketch.size();
    }

    @Override
    private long estimateCount(NormalSketch sketch) {
        double linearCountingEstimate;
        int nZeroBuckets;
        Preconditions.checkArgument((sketch.size() == this.nBuckets ? 1 : 0) != 0, (String)"Sketch has invalid size. Expected %s, actual %s.", (int)this.nBuckets, (int)sketch.size());
        double rawEstimate = this.calculateRawEstimate(sketch);
        if (this.shouldPerformBiasCorrection(rawEstimate)) {
            rawEstimate -= this.biasEstimator.estimateBias(rawEstimate);
        }
        if ((nZeroBuckets = HyperLogLogEstimator.countZeroBuckets(sketch)) > 0 && (linearCountingEstimate = this.calculateLinearCountingEstimate(nZeroBuckets)) <= (double)this.linearCountingThreshold) {
            rawEstimate = linearCountingEstimate;
        }
        return Math.round(rawEstimate);
    }

    private double calculateLinearCountingEstimate(int nZeroBuckets) {
        return (double)this.nBuckets * Math.log((double)this.nBuckets / (double)nZeroBuckets);
    }

    private boolean shouldPerformBiasCorrection(double rawEstimate) {
        return rawEstimate <= (double)(5 * this.nBuckets);
    }

    private double calculateRawEstimate(NormalSketch sketch) {
        double indicator = HyperLogLogEstimator.calculateIndicator(sketch);
        return this.alphaCoefficient * (double)this.nBuckets * (double)this.nBuckets * indicator;
    }

    private static double calculateIndicator(NormalSketch sketch) {
        double sum = 0.0;
        for (byte prefixLength : sketch.data()) {
            sum += Math.pow(2.0, -prefixLength);
        }
        return 1.0 / sum;
    }

    private static int countZeroBuckets(NormalSketch sketch) {
        int nZeroBuckets = 0;
        for (byte prefixLength : sketch.data()) {
            if (prefixLength != 0) continue;
            ++nZeroBuckets;
        }
        return nZeroBuckets;
    }

    private static int getLinearCountingThreshold(int precision) {
        switch (precision) {
            case 4: {
                return 10;
            }
            case 5: {
                return 20;
            }
            case 6: {
                return 40;
            }
            case 7: {
                return 80;
            }
            case 8: {
                return 220;
            }
            case 9: {
                return 400;
            }
            case 10: {
                return 900;
            }
            case 11: {
                return 1800;
            }
            case 12: {
                return 3100;
            }
            case 13: {
                return 6500;
            }
            case 14: {
                return 11500;
            }
            case 15: {
                return 22000;
            }
            case 16: {
                return 50000;
            }
            case 17: {
                return 120000;
            }
            case 18: {
                return 350000;
            }
        }
        throw new RuntimeException();
    }

    private static double getAlphaCoefficient(int nBuckets) {
        switch (nBuckets) {
            case 16: {
                return 0.673;
            }
            case 32: {
                return 0.697;
            }
            case 64: {
                return 0.709;
            }
        }
        return 0.7213 / (1.0 + 1.079 / (double)nBuckets);
    }
}

