/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;

public enum Operator {
    or("||", (x, y) -> x.or((Value)y)),
    and("&&", (x, y) -> x.and((Value)y)),
    largerOrEqual(">=", (x, y) -> x.largerOrEqual((Value)y)),
    larger(">", (x, y) -> x.larger((Value)y)),
    smallerOrEqual("<=", (x, y) -> x.smallerOrEqual((Value)y)),
    smaller("<", (x, y) -> x.smaller((Value)y)),
    approxEqual("~=", (x, y) -> x.approxEqual((Value)y)),
    notEqual("!=", (x, y) -> x.notEqual((Value)y)),
    equal("==", (x, y) -> x.equal((Value)y)),
    plus("+", (x, y) -> x.add((Value)y)),
    minus("-", (x, y) -> x.subtract((Value)y)),
    multiply("*", (x, y) -> x.multiply((Value)y)),
    divide("/", (x, y) -> x.divide((Value)y)),
    modulo("%", (x, y) -> x.modulo((Value)y)),
    power("^", true, (x, y) -> x.power((Value)y));

    public static final List<Operator> operatorsByPrecedence;
    private final String image;
    private final boolean rightPrecedence;
    private final BiFunction<Value, Value, Value> function;

    private Operator(String image, BiFunction<Value, Value, Value> function) {
        this(image, false, function);
    }

    private Operator(String image, boolean rightPrecedence, BiFunction<Value, Value, Value> function) {
        this.image = image;
        this.rightPrecedence = rightPrecedence;
        this.function = function;
    }

    public boolean hasPrecedenceOver(Operator other) {
        if (operatorsByPrecedence.indexOf((Object)this) == operatorsByPrecedence.indexOf((Object)other)) {
            return this.rightPrecedence;
        }
        return operatorsByPrecedence.indexOf((Object)this) > operatorsByPrecedence.indexOf((Object)other);
    }

    public final Value evaluate(Value x, Value y) {
        return this.function.apply(x, y);
    }

    public String toString() {
        return this.image;
    }

    static {
        operatorsByPrecedence = Arrays.stream(Operator.values()).toList();
    }
}

