/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.PositiveInfinityResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.SingleResultNode;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.Arrays;

public class StringResultNode
extends SingleResultNode {
    public static final int classId = StringResultNode.registerClass((int)16437, StringResultNode.class, StringResultNode::new);
    private static final StringResultNode negativeInfinity = new StringResultNode("");
    private static final PositiveInfinityResultNode positiveInfinity = new PositiveInfinityResultNode();
    private static final byte[] EMPTY_UTF8_ARRAY = new byte[0];
    private byte[] utf8Value;

    public StringResultNode() {
        this.utf8Value = EMPTY_UTF8_ARRAY;
    }

    public StringResultNode(String value) {
        this.setValue(value);
    }

    private StringResultNode(byte[] rawUtf8Value) {
        this.utf8Value = rawUtf8Value;
    }

    protected static StringResultNode ofUncheckedUtf8Array(byte[] rawUtf8Value) {
        return new StringResultNode(rawUtf8Value);
    }

    public StringResultNode setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value can not be null.");
        }
        this.utf8Value = Utf8.toBytes((String)value);
        return this;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        byte[] raw = this.getRaw();
        buf.putInt(null, raw.length);
        buf.put(null, raw);
    }

    protected void onDeserialize(Deserializer buf) {
        this.utf8Value = StringResultNode.getRawUtf8Bytes((Deserializer)buf);
    }

    @Override
    public long getInteger() {
        try {
            return Integer.parseInt(this.getString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public double getFloat() {
        try {
            return Double.parseDouble(this.getString());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public String getString() {
        return Utf8.toString((byte[])this.utf8Value);
    }

    @Override
    public byte[] getRaw() {
        return this.utf8Value;
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        return rhs instanceof PositiveInfinityResultNode ? -1 : this.internalNonPositiveInfinityCompareTo(rhs);
    }

    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.utf8Value);
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("value", (Object)this.getString());
    }

    @Override
    public void add(ResultNode rhs) {
        this.setValue(this.getString() + rhs.getString());
    }

    @Override
    public void min(ResultNode rhs) {
        if (this.internalNonPositiveInfinityCompareTo(rhs) > 0) {
            this.set(rhs);
        }
    }

    @Override
    public void max(ResultNode rhs) {
        if (this.internalNonPositiveInfinityCompareTo(rhs) < 0) {
            this.set(rhs);
        }
    }

    public void append(ResultNode rhs) {
        this.setValue(this.getString() + rhs.getString());
    }

    @Override
    public Object getValue() {
        return this.getString();
    }

    @Override
    public void set(ResultNode rhs) {
        if (rhs instanceof StringResultNode) {
            this.utf8Value = ((StringResultNode)rhs).utf8Value;
        } else {
            this.setValue(rhs.getString());
        }
    }

    @Override
    public void negate() {
        char[] a = this.getString().toCharArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = -a[i];
        }
        this.setValue(new String(a));
    }

    private int internalNonPositiveInfinityCompareTo(ResultNode rhs) {
        byte[] rhsAsUtf8 = rhs instanceof StringResultNode ? ((StringResultNode)rhs).utf8Value : Utf8.toBytes((String)rhs.getString());
        return Arrays.compareUnsigned(this.utf8Value, rhsAsUtf8);
    }

    public static StringResultNode getNegativeInfinity() {
        return negativeInfinity;
    }

    public static PositiveInfinityResultNode getPositiveInfinity() {
        return positiveInfinity;
    }
}

