/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.api.annotations.Beta;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.Function;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;

@Beta
public class TensorValue
extends Value {
    private final Tensor value;

    public TensorValue(Tensor value) {
        this.value = value;
    }

    @Override
    public TensorType type() {
        return this.value.type();
    }

    @Override
    public double asDouble() {
        if (this.hasDouble()) {
            return this.value.get(TensorAddress.of((int[])new int[0]));
        }
        throw new UnsupportedOperationException("Requires a double value, but " + this.value + " cannot be used as a double");
    }

    @Override
    public boolean hasDouble() {
        return this.value.type().dimensions().isEmpty() && !this.value.isEmpty();
    }

    @Override
    public boolean asBoolean() {
        if (this.hasDouble()) {
            return this.asDouble() != 0.0;
        }
        throw new UnsupportedOperationException("Tensor does not have a value that can be converted to a boolean");
    }

    @Override
    public Value negate() {
        return new TensorValue(this.value.map(value -> -value));
    }

    @Override
    public Value not() {
        return new TensorValue(this.value.map(value -> value == 0.0 ? 1.0 : 0.0));
    }

    @Override
    public Value or(Value argument) {
        return new TensorValue(this.value.join(argument.asTensor(), (a, b) -> a != 0.0 || b != 0.0 ? 1.0 : 0.0));
    }

    @Override
    public Value and(Value argument) {
        return new TensorValue(this.value.join(argument.asTensor(), (a, b) -> a != 0.0 && b != 0.0 ? 1.0 : 0.0));
    }

    @Override
    public Value largerOrEqual(Value argument) {
        return new TensorValue(this.value.largerOrEqual(argument.asTensor()));
    }

    @Override
    public Value larger(Value argument) {
        return new TensorValue(this.value.larger(argument.asTensor()));
    }

    @Override
    public Value smallerOrEqual(Value argument) {
        return new TensorValue(this.value.smallerOrEqual(argument.asTensor()));
    }

    @Override
    public Value smaller(Value argument) {
        return new TensorValue(this.value.smaller(argument.asTensor()));
    }

    @Override
    public Value approxEqual(Value argument) {
        return new TensorValue(this.value.approxEqual(argument.asTensor()));
    }

    @Override
    public Value notEqual(Value argument) {
        return new TensorValue(this.value.notEqual(argument.asTensor()));
    }

    @Override
    public Value equal(Value argument) {
        return new TensorValue(this.value.equal(argument.asTensor()));
    }

    @Override
    public Value add(Value argument) {
        return new TensorValue(this.value.add(argument.asTensor()));
    }

    @Override
    public Value subtract(Value argument) {
        return new TensorValue(this.value.subtract(argument.asTensor()));
    }

    @Override
    public Value multiply(Value argument) {
        return new TensorValue(this.value.multiply(argument.asTensor()));
    }

    @Override
    public Value divide(Value argument) {
        return new TensorValue(this.value.divide(argument.asTensor()));
    }

    @Override
    public Value modulo(Value argument) {
        return new TensorValue(this.value.fmod(argument.asTensor()));
    }

    @Override
    public Value power(Value argument) {
        return new TensorValue(this.value.pow(argument.asTensor()));
    }

    @Override
    public Tensor asTensor() {
        return this.value;
    }

    @Override
    public Value function(Function function, Value arg) {
        if (function.arity() != 1) {
            return new TensorValue(this.functionOnTensor(function, arg.asTensor()));
        }
        return new TensorValue(this.value.map(value -> function.evaluate(value, 0.0)));
    }

    private Tensor functionOnTensor(Function function, Tensor argument) {
        return switch (function) {
            case Function.min -> this.value.min(argument);
            case Function.max -> this.value.max(argument);
            case Function.atan2 -> this.value.atan2(argument);
            case Function.pow -> this.value.pow(argument);
            case Function.fmod -> this.value.fmod(argument);
            case Function.ldexp -> this.value.ldexp(argument);
            case Function.bit -> this.value.bit(argument);
            case Function.hamming -> this.value.hamming(argument);
            default -> this.value.join(argument, (a, b) -> function.evaluate(a, b));
        };
    }

    @Override
    public Value asMutable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TensorValue other = (TensorValue)o;
        return this.value.equals((Object)other.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

