/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.searchlib.aggregation.AggregationResult;
import com.yahoo.searchlib.expression.IntegerResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class XorAggregationResult
extends AggregationResult {
    public static final int classId = XorAggregationResult.registerClass((int)16470, XorAggregationResult.class, XorAggregationResult::new);
    private long xor = 0L;

    public XorAggregationResult() {
    }

    public XorAggregationResult(long xor) {
        this.setXor(xor);
    }

    public long getXor() {
        return this.xor;
    }

    public XorAggregationResult setXor(long xor) {
        this.xor = xor;
        return this;
    }

    @Override
    public ResultNode getRank() {
        return new IntegerResultNode(this.xor);
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putLong(null, this.xor);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.xor = buf.getLong(null);
    }

    @Override
    protected void onMerge(AggregationResult result) {
        this.xor ^= ((XorAggregationResult)result).xor;
    }

    @Override
    protected boolean equalsAggregation(AggregationResult obj) {
        return this.xor == ((XorAggregationResult)obj).xor;
    }

    public int hashCode() {
        return super.hashCode() + (int)this.xor;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("xor", (Object)this.xor);
    }
}

