/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.BoolResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.ResultNodeVector;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;

public class BoolResultNodeVector
extends ResultNodeVector {
    public static final int classId = BoolResultNodeVector.registerClass((int)16531, BoolResultNodeVector.class, BoolResultNodeVector::new);
    private ArrayList<BoolResultNode> vector = new ArrayList();

    public BoolResultNodeVector add(BoolResultNode v) {
        this.vector.add(v);
        return this;
    }

    public ArrayList<BoolResultNode> getVector() {
        return this.vector;
    }

    @Override
    public ResultNodeVector add(ResultNode r) {
        return this.add((BoolResultNode)r);
    }

    @Override
    public int size() {
        return this.vector.size();
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putInt(null, this.vector.size());
        for (BoolResultNode node : this.vector) {
            node.serialize(buf);
        }
    }

    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        int sz = buf.getInt(null);
        this.vector = new ArrayList();
        for (int i = 0; i < sz; ++i) {
            BoolResultNode node = new BoolResultNode();
            node.deserialize(buf);
            this.vector.add(node);
        }
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        if (classId != rhs.getClassId()) {
            return classId - rhs.getClassId();
        }
        BoolResultNodeVector b = (BoolResultNodeVector)rhs;
        int minLength = this.vector.size();
        if (b.vector.size() < minLength) {
            minLength = b.vector.size();
        }
        int diff = 0;
        for (int i = 0; diff == 0 && i < minLength; ++i) {
            diff = this.vector.get(i).compareTo(b.vector.get(i));
        }
        return diff == 0 ? this.vector.size() - b.vector.size() : diff;
    }
}

