/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.parser;

import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.StringValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import com.yahoo.searchlib.rankingexpression.parser.RankingExpressionParserConstants;
import com.yahoo.searchlib.rankingexpression.parser.RankingExpressionParserTokenManager;
import com.yahoo.searchlib.rankingexpression.parser.SimpleCharStream;
import com.yahoo.searchlib.rankingexpression.parser.Token;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.EmbracedNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.Function;
import com.yahoo.searchlib.rankingexpression.rule.FunctionNode;
import com.yahoo.searchlib.rankingexpression.rule.IfNode;
import com.yahoo.searchlib.rankingexpression.rule.LambdaFunctionNode;
import com.yahoo.searchlib.rankingexpression.rule.NameNode;
import com.yahoo.searchlib.rankingexpression.rule.NegativeNode;
import com.yahoo.searchlib.rankingexpression.rule.NotNode;
import com.yahoo.searchlib.rankingexpression.rule.OperationNode;
import com.yahoo.searchlib.rankingexpression.rule.Operator;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.SetMembershipNode;
import com.yahoo.searchlib.rankingexpression.rule.TensorFunctionNode;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Argmax;
import com.yahoo.tensor.functions.Argmin;
import com.yahoo.tensor.functions.CellCast;
import com.yahoo.tensor.functions.Concat;
import com.yahoo.tensor.functions.CosineSimilarity;
import com.yahoo.tensor.functions.Diag;
import com.yahoo.tensor.functions.DynamicTensor;
import com.yahoo.tensor.functions.EuclideanDistance;
import com.yahoo.tensor.functions.Expand;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.L1Normalize;
import com.yahoo.tensor.functions.L2Normalize;
import com.yahoo.tensor.functions.Matmul;
import com.yahoo.tensor.functions.Merge;
import com.yahoo.tensor.functions.Random;
import com.yahoo.tensor.functions.Range;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.Rename;
import com.yahoo.tensor.functions.Slice;
import com.yahoo.tensor.functions.Softmax;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.XwPlusB;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RankingExpressionParser
implements RankingExpressionParserConstants {
    public RankingExpressionParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[53];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[12];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public final List<ReferenceNode> featureList() throws ParseException {
        ArrayList<ReferenceNode> ret = new ArrayList<ReferenceNode>();
        block3: while (true) {
            ReferenceNode exp = this.feature();
            ret.add(exp);
            switch (this.jj_nt.kind) {
                case 32: 
                case 33: 
                case 34: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[0] = this.jj_gen;
        this.jj_consume_token(0);
        return ret;
    }

    public final ExpressionNode rankingExpression() throws ParseException {
        ExpressionNode ret = this.expression();
        this.jj_consume_token(0);
        return ret;
    }

    public final ExpressionNode expression() throws ParseException {
        ExpressionNode left = this.operationExpression();
        switch (this.jj_nt.kind) {
            case 33: {
                this.jj_consume_token(33);
                List<ExpressionNode> rightList = this.expressionList();
                left = new SetMembershipNode(left, rightList);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        return left;
    }

    public final ExpressionNode operationExpression() throws ParseException {
        ExpressionNode right = null;
        ExpressionNode left = this.value();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 36: 
                case 37: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            Operator operator = this.binaryOperator();
            right = this.value();
            left = OperationNode.resolve(left, operator, right);
        }
        return left;
    }

    public final Operator binaryOperator() throws ParseException {
        switch (this.jj_nt.kind) {
            case 37: {
                this.jj_consume_token(37);
                return Operator.or;
            }
            case 36: {
                this.jj_consume_token(36);
                return Operator.and;
            }
            case 24: {
                this.jj_consume_token(24);
                return Operator.largerOrEqual;
            }
            case 25: {
                this.jj_consume_token(25);
                return Operator.larger;
            }
            case 26: {
                this.jj_consume_token(26);
                return Operator.smallerOrEqual;
            }
            case 27: {
                this.jj_consume_token(27);
                return Operator.smaller;
            }
            case 28: {
                this.jj_consume_token(28);
                return Operator.approxEqual;
            }
            case 29: {
                this.jj_consume_token(29);
                return Operator.notEqual;
            }
            case 30: {
                this.jj_consume_token(30);
                return Operator.equal;
            }
            case 14: {
                this.jj_consume_token(14);
                return Operator.plus;
            }
            case 15: {
                this.jj_consume_token(15);
                return Operator.minus;
            }
            case 16: {
                this.jj_consume_token(16);
                return Operator.divide;
            }
            case 17: {
                this.jj_consume_token(17);
                return Operator.multiply;
            }
            case 19: {
                this.jj_consume_token(19);
                return Operator.modulo;
            }
            case 20: {
                this.jj_consume_token(20);
                return Operator.power;
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ExpressionNode value() throws ParseException {
        ExpressionNode value;
        boolean neg = false;
        boolean not = false;
        switch (this.jj_nt.kind) {
            case 35: {
                this.jj_consume_token(35);
                not = true;
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        if (this.jj_2_1(2)) {
            this.jj_consume_token(15);
            neg = true;
        }
        switch (this.jj_nt.kind) {
            case 2: 
            case 6: 
            case 15: 
            case 31: 
            case 97: 
            case 98: {
                value = this.constantPrimitive(neg);
                break;
            }
            case 8: 
            case 21: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 99: {
                if (this.jj_2_2(2)) {
                    value = this.ifExpression();
                } else if (this.jj_2_3(4)) {
                    value = this.function();
                } else {
                    switch (this.jj_nt.kind) {
                        case 32: 
                        case 33: 
                        case 34: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: {
                            value = this.feature();
                            break;
                        }
                        case 21: {
                            value = this.legacyQueryFeature();
                            break;
                        }
                        case 8: {
                            this.jj_consume_token(8);
                            value = this.expression();
                            this.jj_consume_token(9);
                            value = new EmbracedNode(value);
                            break;
                        }
                        default: {
                            this.jj_la1[5] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                value = neg ? new NegativeNode(value) : value;
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.jj_2_4(2)) {
            List valueAddress = this.valueAddress();
            value = new TensorFunctionNode((TensorFunction<Reference>)new Slice((TensorFunction)TensorFunctionNode.wrap(value), valueAddress));
        }
        value = not ? new NotNode(value) : value;
        return value;
    }

    public final IfNode ifExpression() throws ParseException {
        Double trueProbability = null;
        this.jj_consume_token(32);
        this.jj_consume_token(8);
        ExpressionNode condition = this.expression();
        this.jj_consume_token(22);
        ExpressionNode ifTrue = this.expression();
        this.jj_consume_token(22);
        ExpressionNode ifFalse = this.expression();
        switch (this.jj_nt.kind) {
            case 22: {
                this.jj_consume_token(22);
                trueProbability = this.doubleNumber();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        this.jj_consume_token(9);
        return new IfNode(condition, ifTrue, ifFalse, trueProbability);
    }

    public final ReferenceNode feature() throws ParseException {
        List<ExpressionNode> args = null;
        String out = null;
        String name = this.identifier();
        switch (this.jj_nt.kind) {
            case 8: {
                this.jj_consume_token(8);
                args = this.args();
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                out = this.outs();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        if (args == null && out == null) {
            return new ReferenceNode(name);
        }
        return new ReferenceNode(name, args, out);
    }

    public final ReferenceNode legacyQueryFeature() throws ParseException {
        this.jj_consume_token(21);
        String name = this.identifier();
        return new ReferenceNode("query", Arrays.asList(new NameNode(name)), null);
    }

    public final String outs() throws ParseException {
        StringBuilder ret = new StringBuilder();
        String str = this.out();
        ret.append(str);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 18: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(18);
            ret.append(this.token.image);
            str = this.out();
            ret.append(str);
        }
        return ret.toString();
    }

    public final String out() throws ParseException {
        switch (this.jj_nt.kind) {
            case 2: {
                this.jj_consume_token(2);
                return this.token.image;
            }
            case 6: {
                this.jj_consume_token(6);
                return this.token.image;
            }
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                String name = this.identifier();
                return name;
            }
        }
        this.jj_la1[11] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List<ExpressionNode> args() throws ParseException {
        ArrayList<ExpressionNode> arguments = new ArrayList<ExpressionNode>();
        block0 : switch (this.jj_nt.kind) {
            case 2: 
            case 6: 
            case 8: 
            case 15: 
            case 21: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                ExpressionNode argument = this.expression();
                arguments.add(argument);
                while (true) {
                    switch (this.jj_nt.kind) {
                        case 22: {
                            break;
                        }
                        default: {
                            this.jj_la1[12] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(22);
                    argument = this.expression();
                    arguments.add(argument);
                }
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        return arguments;
    }

    public final ExpressionNode function() throws ParseException {
        CompositeNode function;
        if (this.jj_2_5(2)) {
            function = this.scalarOrTensorFunction();
        } else {
            switch (this.jj_nt.kind) {
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: {
                    function = this.tensorFunction();
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return function;
    }

    public final FunctionNode scalarOrTensorFunction() throws ParseException {
        switch (this.jj_nt.kind) {
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                Function function = this.unaryFunctionName();
                this.jj_consume_token(8);
                ExpressionNode arg1 = this.expression();
                this.jj_consume_token(9);
                return new FunctionNode(function, arg1);
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 92: 
            case 94: {
                Function function = this.binaryFunctionName();
                this.jj_consume_token(8);
                ExpressionNode arg1 = this.expression();
                this.jj_consume_token(22);
                ExpressionNode arg2 = this.expression();
                this.jj_consume_token(9);
                return new FunctionNode(function, arg1, arg2);
            }
        }
        this.jj_la1[15] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TensorFunctionNode tensorFunction() throws ParseException {
        return switch (this.jj_nt.kind) {
            case 69 -> this.tensorMap();
            case 70 -> this.tensorReduce();
            case 90, 91, 92, 93, 94, 95, 96 -> this.tensorReduceComposites();
            case 71 -> this.tensorJoin();
            case 72 -> this.tensorMerge();
            case 73 -> this.tensorRename();
            case 74 -> this.tensorConcat();
            case 75 -> this.tensorGenerate();
            case 76 -> this.tensorRange();
            case 77 -> this.tensorDiag();
            case 78 -> this.tensorRandom();
            case 79 -> this.tensorL1Normalize();
            case 80 -> this.tensorL2Normalize();
            case 81 -> this.tensorEuclideanDistance();
            case 82 -> this.tensorCosineSimilarity();
            case 83 -> this.tensorMatmul();
            case 84 -> this.tensorSoftmax();
            case 85 -> this.tensorXwPlusB();
            case 86 -> this.tensorArgmax();
            case 87 -> this.tensorArgmin();
            case 88 -> this.tensorCellCast();
            case 89 -> this.tensorExpand();
            default -> {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final TensorFunctionNode tensorMap() throws ParseException {
        this.jj_consume_token(69);
        this.jj_consume_token(8);
        ExpressionNode tensor = this.expression();
        this.jj_consume_token(22);
        LambdaFunctionNode doubleMapper = this.lambdaFunction();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new com.yahoo.tensor.functions.Map((TensorFunction)TensorFunctionNode.wrap(tensor), doubleMapper.asDoubleUnaryOperator()));
    }

    public final TensorFunctionNode tensorReduce() throws ParseException {
        List<String> dimensions = null;
        this.jj_consume_token(70);
        this.jj_consume_token(8);
        ExpressionNode tensor = this.expression();
        this.jj_consume_token(22);
        Reduce.Aggregator aggregator = this.tensorReduceAggregator();
        dimensions = this.tagCommaLeadingList();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new Reduce((TensorFunction)TensorFunctionNode.wrap(tensor), aggregator, dimensions));
    }

    public final TensorFunctionNode tensorReduceComposites() throws ParseException {
        List<String> dimensions = null;
        Reduce.Aggregator aggregator = this.tensorReduceAggregator();
        this.jj_consume_token(8);
        ExpressionNode tensor = this.expression();
        dimensions = this.tagCommaLeadingList();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new Reduce((TensorFunction)TensorFunctionNode.wrap(tensor), aggregator, dimensions));
    }

    public final TensorFunctionNode tensorJoin() throws ParseException {
        this.jj_consume_token(71);
        this.jj_consume_token(8);
        ExpressionNode tensor1 = this.expression();
        this.jj_consume_token(22);
        ExpressionNode tensor2 = this.expression();
        this.jj_consume_token(22);
        LambdaFunctionNode doubleJoiner = this.lambdaFunction();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new Join((TensorFunction)TensorFunctionNode.wrap(tensor1), (TensorFunction)TensorFunctionNode.wrap(tensor2), doubleJoiner.asDoubleBinaryOperator()));
    }

    public final TensorFunctionNode tensorMerge() throws ParseException {
        this.jj_consume_token(72);
        this.jj_consume_token(8);
        ExpressionNode tensor1 = this.expression();
        this.jj_consume_token(22);
        ExpressionNode tensor2 = this.expression();
        this.jj_consume_token(22);
        LambdaFunctionNode doubleMerger = this.lambdaFunction();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new Merge((TensorFunction)TensorFunctionNode.wrap(tensor1), (TensorFunction)TensorFunctionNode.wrap(tensor2), doubleMerger.asDoubleBinaryOperator()));
    }

    public final TensorFunctionNode tensorRename() throws ParseException {
        this.jj_consume_token(73);
        this.jj_consume_token(8);
        ExpressionNode tensor = this.expression();
        this.jj_consume_token(22);
        List<String> fromDimensions = this.bracedIdentifierList();
        this.jj_consume_token(22);
        List<String> toDimensions = this.bracedIdentifierList();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new Rename((TensorFunction)TensorFunctionNode.wrap(tensor), fromDimensions, toDimensions));
    }

    public final TensorFunctionNode tensorConcat() throws ParseException {
        this.jj_consume_token(74);
        this.jj_consume_token(8);
        ExpressionNode tensor1 = this.expression();
        this.jj_consume_token(22);
        ExpressionNode tensor2 = this.expression();
        this.jj_consume_token(22);
        String dimension = this.tag();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new Concat((TensorFunction)TensorFunctionNode.wrap(tensor1), (TensorFunction)TensorFunctionNode.wrap(tensor2), dimension));
    }

    public final TensorFunctionNode tensorGenerate() throws ParseException {
        ArrayList dimensionOrder = new ArrayList();
        this.jj_consume_token(75);
        TensorType type = this.tensorType(dimensionOrder);
        return switch (this.jj_nt.kind) {
            case 8 -> this.tensorGenerateBody(type);
            case 23 -> this.tensorValueBody(type, dimensionOrder);
            default -> {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final TensorFunctionNode tensorGenerateBody(TensorType type) throws ParseException {
        this.jj_consume_token(8);
        ExpressionNode generator = this.expression();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)Generate.bound((TensorType)type, TensorFunctionNode.wrapScalar(generator)));
    }

    public final TensorFunctionNode tensorRange() throws ParseException {
        this.jj_consume_token(76);
        TensorType type = this.tensorType(null);
        return new TensorFunctionNode((TensorFunction<Reference>)new Range(type));
    }

    public final TensorFunctionNode tensorDiag() throws ParseException {
        this.jj_consume_token(77);
        TensorType type = this.tensorType(null);
        return new TensorFunctionNode((TensorFunction<Reference>)new Diag(type));
    }

    public final TensorFunctionNode tensorRandom() throws ParseException {
        this.jj_consume_token(78);
        TensorType type = this.tensorType(null);
        return new TensorFunctionNode((TensorFunction<Reference>)new Random(type));
    }

    public final TensorFunctionNode tensorL1Normalize() throws ParseException {
        this.jj_consume_token(79);
        this.jj_consume_token(8);
        ExpressionNode tensor = this.expression();
        this.jj_consume_token(22);
        String dimension = this.identifier();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new L1Normalize((TensorFunction)TensorFunctionNode.wrap(tensor), dimension));
    }

    public final TensorFunctionNode tensorL2Normalize() throws ParseException {
        this.jj_consume_token(80);
        this.jj_consume_token(8);
        ExpressionNode tensor = this.expression();
        this.jj_consume_token(22);
        String dimension = this.identifier();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new L2Normalize((TensorFunction)TensorFunctionNode.wrap(tensor), dimension));
    }

    public final TensorFunctionNode tensorEuclideanDistance() throws ParseException {
        this.jj_consume_token(81);
        this.jj_consume_token(8);
        ExpressionNode tensor1 = this.expression();
        this.jj_consume_token(22);
        ExpressionNode tensor2 = this.expression();
        this.jj_consume_token(22);
        String dimension = this.identifier();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new EuclideanDistance((TensorFunction)TensorFunctionNode.wrap(tensor1), (TensorFunction)TensorFunctionNode.wrap(tensor2), dimension));
    }

    public final TensorFunctionNode tensorCosineSimilarity() throws ParseException {
        this.jj_consume_token(82);
        this.jj_consume_token(8);
        ExpressionNode tensor1 = this.expression();
        this.jj_consume_token(22);
        ExpressionNode tensor2 = this.expression();
        this.jj_consume_token(22);
        String dimension = this.identifier();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new CosineSimilarity((TensorFunction)TensorFunctionNode.wrap(tensor1), (TensorFunction)TensorFunctionNode.wrap(tensor2), dimension));
    }

    public final TensorFunctionNode tensorMatmul() throws ParseException {
        this.jj_consume_token(83);
        this.jj_consume_token(8);
        ExpressionNode tensor1 = this.expression();
        this.jj_consume_token(22);
        ExpressionNode tensor2 = this.expression();
        this.jj_consume_token(22);
        String dimension = this.identifier();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new Matmul((TensorFunction)TensorFunctionNode.wrap(tensor1), (TensorFunction)TensorFunctionNode.wrap(tensor2), dimension));
    }

    public final TensorFunctionNode tensorSoftmax() throws ParseException {
        this.jj_consume_token(84);
        this.jj_consume_token(8);
        ExpressionNode tensor = this.expression();
        this.jj_consume_token(22);
        String dimension = this.identifier();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new Softmax((TensorFunction)TensorFunctionNode.wrap(tensor), dimension));
    }

    public final TensorFunctionNode tensorXwPlusB() throws ParseException {
        this.jj_consume_token(85);
        this.jj_consume_token(8);
        ExpressionNode tensor1 = this.expression();
        this.jj_consume_token(22);
        ExpressionNode tensor2 = this.expression();
        this.jj_consume_token(22);
        ExpressionNode tensor3 = this.expression();
        this.jj_consume_token(22);
        String dimension = this.identifier();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new XwPlusB((TensorFunction)TensorFunctionNode.wrap(tensor1), (TensorFunction)TensorFunctionNode.wrap(tensor2), (TensorFunction)TensorFunctionNode.wrap(tensor3), dimension));
    }

    public final TensorFunctionNode tensorExpand() throws ParseException {
        this.jj_consume_token(89);
        this.jj_consume_token(8);
        ExpressionNode argument = this.expression();
        this.jj_consume_token(22);
        String dimension = this.identifier();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new Expand((TensorFunction)TensorFunctionNode.wrap(argument), dimension));
    }

    public final TensorFunctionNode tensorArgmax() throws ParseException {
        List<String> dimensions = null;
        this.jj_consume_token(86);
        this.jj_consume_token(8);
        ExpressionNode tensor = this.expression();
        dimensions = this.tagCommaLeadingList();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new Argmax((TensorFunction)TensorFunctionNode.wrap(tensor), dimensions));
    }

    public final TensorFunctionNode tensorArgmin() throws ParseException {
        List<String> dimensions = null;
        this.jj_consume_token(87);
        this.jj_consume_token(8);
        ExpressionNode tensor = this.expression();
        dimensions = this.tagCommaLeadingList();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new Argmin((TensorFunction)TensorFunctionNode.wrap(tensor), dimensions));
    }

    public final TensorFunctionNode tensorCellCast() throws ParseException {
        this.jj_consume_token(88);
        this.jj_consume_token(8);
        ExpressionNode tensor = this.expression();
        this.jj_consume_token(22);
        String valueType = this.identifier();
        this.jj_consume_token(9);
        return new TensorFunctionNode((TensorFunction<Reference>)new CellCast((TensorFunction)TensorFunctionNode.wrap(tensor), TensorType.Value.fromId((String)valueType)));
    }

    public final LambdaFunctionNode lambdaFunction() throws ParseException {
        this.jj_consume_token(34);
        this.jj_consume_token(8);
        List<String> variables = this.identifierList();
        this.jj_consume_token(9);
        this.jj_consume_token(8);
        ExpressionNode functionExpression = this.expression();
        this.jj_consume_token(9);
        return new LambdaFunctionNode(variables, functionExpression);
    }

    public final Reduce.Aggregator tensorReduceAggregator() throws ParseException {
        switch (this.jj_nt.kind) {
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            case 91: {
                this.jj_consume_token(91);
                break;
            }
            case 92: {
                this.jj_consume_token(92);
                break;
            }
            case 93: {
                this.jj_consume_token(93);
                break;
            }
            case 94: {
                this.jj_consume_token(94);
                break;
            }
            case 95: {
                this.jj_consume_token(95);
                break;
            }
            case 96: {
                this.jj_consume_token(96);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return Reduce.Aggregator.valueOf((String)this.token.image);
    }

    public final TensorType tensorType(List dimensionOrder) throws ParseException {
        TensorType.Value valueType = this.optionalTensorValueTypeParameter();
        TensorType.Builder builder = new TensorType.Builder(valueType);
        this.jj_consume_token(8);
        switch (this.jj_nt.kind) {
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                this.tensorTypeDimension(builder, dimensionOrder);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(22);
            this.tensorTypeDimension(builder, dimensionOrder);
        }
        this.jj_consume_token(9);
        return builder.build();
    }

    public final TensorType.Value optionalTensorValueTypeParameter() throws ParseException {
        String valueType = "double";
        switch (this.jj_nt.kind) {
            case 27: {
                this.jj_consume_token(27);
                valueType = this.identifier();
                this.jj_consume_token(25);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        return TensorType.Value.fromId((String)valueType);
    }

    public final void tensorTypeDimension(TensorType.Builder builder, List dimensionOrder) throws ParseException {
        String name = this.identifier();
        if (dimensionOrder != null) {
            dimensionOrder.add(name);
        }
        block0 : switch (this.jj_nt.kind) {
            case 12: {
                this.jj_consume_token(12);
                this.jj_consume_token(13);
                builder.mapped(name);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                if (this.jj_2_6(2)) {
                    this.jj_consume_token(10);
                    this.jj_consume_token(11);
                    builder.indexed(name);
                    break;
                }
                switch (this.jj_nt.kind) {
                    case 10: {
                        this.jj_consume_token(10);
                        int size = this.integerNumber();
                        this.jj_consume_token(11);
                        builder.indexed(name, (long)size);
                        break block0;
                    }
                }
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String tensorFunctionName() throws ParseException {
        switch (this.jj_nt.kind) {
            case 34: {
                this.jj_consume_token(34);
                return this.token.image;
            }
            case 69: {
                this.jj_consume_token(69);
                return this.token.image;
            }
            case 70: {
                this.jj_consume_token(70);
                return this.token.image;
            }
            case 71: {
                this.jj_consume_token(71);
                return this.token.image;
            }
            case 72: {
                this.jj_consume_token(72);
                return this.token.image;
            }
            case 73: {
                this.jj_consume_token(73);
                return this.token.image;
            }
            case 74: {
                this.jj_consume_token(74);
                return this.token.image;
            }
            case 75: {
                this.jj_consume_token(75);
                return this.token.image;
            }
            case 76: {
                this.jj_consume_token(76);
                return this.token.image;
            }
            case 77: {
                this.jj_consume_token(77);
                return this.token.image;
            }
            case 78: {
                this.jj_consume_token(78);
                return this.token.image;
            }
            case 79: {
                this.jj_consume_token(79);
                return this.token.image;
            }
            case 80: {
                this.jj_consume_token(80);
                return this.token.image;
            }
            case 81: {
                this.jj_consume_token(81);
                return this.token.image;
            }
            case 82: {
                this.jj_consume_token(82);
                return this.token.image;
            }
            case 83: {
                this.jj_consume_token(83);
                return this.token.image;
            }
            case 84: {
                this.jj_consume_token(84);
                return this.token.image;
            }
            case 85: {
                this.jj_consume_token(85);
                return this.token.image;
            }
            case 86: {
                this.jj_consume_token(86);
                return this.token.image;
            }
            case 87: {
                this.jj_consume_token(87);
                return this.token.image;
            }
            case 88: {
                this.jj_consume_token(88);
                return this.token.image;
            }
            case 89: {
                this.jj_consume_token(89);
                return this.token.image;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                Reduce.Aggregator aggregator = this.tensorReduceAggregator();
                return aggregator.toString();
            }
        }
        this.jj_la1[24] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Function unaryFunctionName() throws ParseException {
        switch (this.jj_nt.kind) {
            case 38: {
                this.jj_consume_token(38);
                return Function.abs;
            }
            case 39: {
                this.jj_consume_token(39);
                return Function.acos;
            }
            case 40: {
                this.jj_consume_token(40);
                return Function.asin;
            }
            case 41: {
                this.jj_consume_token(41);
                return Function.atan;
            }
            case 42: {
                this.jj_consume_token(42);
                return Function.ceil;
            }
            case 43: {
                this.jj_consume_token(43);
                return Function.cos;
            }
            case 44: {
                this.jj_consume_token(44);
                return Function.cosh;
            }
            case 45: {
                this.jj_consume_token(45);
                return Function.elu;
            }
            case 46: {
                this.jj_consume_token(46);
                return Function.exp;
            }
            case 47: {
                this.jj_consume_token(47);
                return Function.fabs;
            }
            case 48: {
                this.jj_consume_token(48);
                return Function.floor;
            }
            case 49: {
                this.jj_consume_token(49);
                return Function.isNan;
            }
            case 50: {
                this.jj_consume_token(50);
                return Function.log;
            }
            case 51: {
                this.jj_consume_token(51);
                return Function.log10;
            }
            case 52: {
                this.jj_consume_token(52);
                return Function.relu;
            }
            case 53: {
                this.jj_consume_token(53);
                return Function.round;
            }
            case 54: {
                this.jj_consume_token(54);
                return Function.sigmoid;
            }
            case 55: {
                this.jj_consume_token(55);
                return Function.sign;
            }
            case 56: {
                this.jj_consume_token(56);
                return Function.sin;
            }
            case 57: {
                this.jj_consume_token(57);
                return Function.sinh;
            }
            case 58: {
                this.jj_consume_token(58);
                return Function.square;
            }
            case 59: {
                this.jj_consume_token(59);
                return Function.sqrt;
            }
            case 60: {
                this.jj_consume_token(60);
                return Function.tan;
            }
            case 61: {
                this.jj_consume_token(61);
                return Function.tanh;
            }
            case 62: {
                this.jj_consume_token(62);
                return Function.erf;
            }
        }
        this.jj_la1[25] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Function binaryFunctionName() throws ParseException {
        switch (this.jj_nt.kind) {
            case 63: {
                this.jj_consume_token(63);
                return Function.atan2;
            }
            case 64: {
                this.jj_consume_token(64);
                return Function.fmod;
            }
            case 65: {
                this.jj_consume_token(65);
                return Function.ldexp;
            }
            case 92: {
                this.jj_consume_token(92);
                return Function.max;
            }
            case 94: {
                this.jj_consume_token(94);
                return Function.min;
            }
            case 66: {
                this.jj_consume_token(66);
                return Function.pow;
            }
            case 67: {
                this.jj_consume_token(67);
                return Function.bit;
            }
            case 68: {
                this.jj_consume_token(68);
                return Function.hamming;
            }
        }
        this.jj_la1[26] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List<ExpressionNode> expressionList() throws ParseException {
        ArrayList<ExpressionNode> list = new ArrayList<ExpressionNode>();
        this.jj_consume_token(10);
        ExpressionNode expression = this.expression();
        list.add(expression);
        while (this.jj_2_7(2)) {
            this.jj_consume_token(22);
            expression = this.expression();
            list.add(expression);
        }
        this.jj_consume_token(11);
        return list;
    }

    public final double doubleNumber() throws ParseException {
        String sign = "";
        switch (this.jj_nt.kind) {
            case 15: {
                this.jj_consume_token(15);
                sign = "-";
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 2: {
                this.jj_consume_token(2);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return Double.parseDouble(sign + this.token.image);
    }

    public final int integerNumber() throws ParseException {
        String sign = "";
        switch (this.jj_nt.kind) {
            case 15: {
                this.jj_consume_token(15);
                sign = "-";
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        this.jj_consume_token(2);
        return Integer.parseInt(sign + this.token.image);
    }

    public final String identifier() throws ParseException {
        if (this.jj_2_8(2)) {
            String name = this.tensorFunctionName();
            return name;
        }
        switch (this.jj_nt.kind) {
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                Function func = this.unaryFunctionName();
                return func.toString();
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 92: 
            case 94: {
                Function func = this.binaryFunctionName();
                return func.toString();
            }
            case 32: {
                this.jj_consume_token(32);
                return this.token.image;
            }
            case 33: {
                this.jj_consume_token(33);
                return this.token.image;
            }
            case 99: {
                this.jj_consume_token(99);
                return this.token.image;
            }
            case 97: {
                this.jj_consume_token(97);
                return this.token.image;
            }
            case 98: {
                this.jj_consume_token(98);
                return this.token.image;
            }
        }
        this.jj_la1[30] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List<String> identifierList() throws ParseException {
        String element;
        ArrayList<String> list = new ArrayList<String>();
        switch (this.jj_nt.kind) {
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                element = this.identifier();
                list.add(element);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(22);
            element = this.identifier();
            list.add(element);
        }
        return list;
    }

    public final List<String> bracedIdentifierList() throws ParseException {
        ArrayList<String> list = new ArrayList();
        switch (this.jj_nt.kind) {
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                String element = this.identifier();
                return Collections.singletonList(element);
            }
            case 8: {
                this.jj_consume_token(8);
                list = this.identifierList();
                this.jj_consume_token(9);
                return list;
            }
        }
        this.jj_la1[33] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String tag() throws ParseException {
        switch (this.jj_nt.kind) {
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                String name = this.identifier();
                return name;
            }
            case 15: {
                this.jj_consume_token(15);
                this.jj_consume_token(2);
                return "-" + this.token.image;
            }
            case 2: {
                this.jj_consume_token(2);
                return this.token.image;
            }
        }
        this.jj_la1[34] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List<String> tagCommaLeadingList() throws ParseException {
        ArrayList<String> list = new ArrayList<String>();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(22);
            String element = this.tag();
            list.add(element);
        }
        return list;
    }

    public final ExpressionNode constantPrimitive(boolean negate) throws ParseException {
        ExpressionNode node;
        switch (this.jj_nt.kind) {
            case 15: {
                this.jj_consume_token(15);
                negate = !negate;
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 2: 
            case 6: {
                String value = switch (this.jj_nt.kind) {
                    case 2 -> {
                        this.jj_consume_token(2);
                        yield this.token.image;
                    }
                    case 6 -> {
                        this.jj_consume_token(6);
                        yield this.token.image;
                    }
                    default -> {
                        this.jj_la1[37] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                };
                node = new ConstantNode(Value.parse((String)(negate ? "-" + value : value)));
                break;
            }
            case 31: 
            case 97: 
            case 98: {
                switch (this.jj_nt.kind) {
                    case 31: {
                        this.jj_consume_token(31);
                        break;
                    }
                    case 97: {
                        this.jj_consume_token(97);
                        break;
                    }
                    case 98: {
                        this.jj_consume_token(98);
                        break;
                    }
                    default: {
                        this.jj_la1[38] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                node = new ConstantNode(Value.parse(this.token.image));
                if (!negate) break;
                node = new NegativeNode(node);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    public final TensorFunctionNode tensorValueBody(TensorType type, List dimensionOrder) throws ParseException {
        DynamicTensor dynamicTensor;
        this.jj_consume_token(23);
        if (this.jj_2_9(2)) {
            dynamicTensor = this.mixedTensorValueBody(type, dimensionOrder);
        } else {
            switch (this.jj_nt.kind) {
                case 12: {
                    dynamicTensor = this.mappedTensorValueBody(type);
                    break;
                }
                case 10: {
                    dynamicTensor = this.indexedTensorValueBody(type, dimensionOrder);
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return new TensorFunctionNode((TensorFunction<Reference>)dynamicTensor);
    }

    public final DynamicTensor mappedTensorValueBody(TensorType type) throws ParseException {
        LinkedHashMap<TensorAddress, ExpressionNode> cells = new LinkedHashMap<TensorAddress, ExpressionNode>();
        this.jj_consume_token(12);
        switch (this.jj_nt.kind) {
            case 12: {
                this.tensorCell(type, cells);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(22);
            this.tensorCell(type, cells);
        }
        this.jj_consume_token(13);
        return DynamicTensor.from((TensorType)type, TensorFunctionNode.wrapScalars(cells));
    }

    public final DynamicTensor mixedTensorValueBody(TensorType type, List dimensionOrder) throws ParseException {
        LinkedHashMap cells = new LinkedHashMap();
        this.jj_consume_token(12);
        this.keyValueOrMixedBlock(type, dimensionOrder, cells);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(22);
            this.keyValueOrMixedBlock(type, dimensionOrder, cells);
        }
        this.jj_consume_token(13);
        return DynamicTensor.from((TensorType)type, cells);
    }

    public final DynamicTensor indexedTensorValueBody(TensorType type, List dimensionOrder) throws ParseException {
        List cells = this.indexedTensorCells();
        return DynamicTensor.from((TensorType)type, TensorFunctionNode.wrapScalars(type, dimensionOrder, cells));
    }

    public final void keyValueOrMixedBlock(TensorType type, List dimensionOrder, Map cellMap) throws ParseException {
        if (this.jj_2_10(3)) {
            this.mixedBlock(type, dimensionOrder, cellMap);
        } else {
            switch (this.jj_nt.kind) {
                case 2: 
                case 15: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: {
                    this.keyValue(type, cellMap);
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void keyValue(TensorType type, Map cellMap) throws ParseException {
        String label = this.label();
        this.jj_consume_token(23);
        ExpressionNode value = this.expression();
        cellMap.put(TensorAddress.ofLabels((String[])new String[]{label}), TensorFunctionNode.wrapScalar(value));
    }

    public final void mixedBlock(TensorType type, List dimensionOrder, Map cellMap) throws ParseException {
        String label = this.label();
        this.jj_consume_token(23);
        List cells = this.indexedTensorCells();
        TensorFunctionNode.wrapScalarBlock(type, dimensionOrder, label, cells, cellMap);
    }

    public final List indexedTensorCells() throws ParseException {
        ArrayList cells = new ArrayList();
        this.jj_consume_token(10);
        this.indexedTensorCellSubspaceList(cells);
        this.jj_consume_token(11);
        return cells;
    }

    public final void indexedTensorCellSubspaceList(List cells) throws ParseException {
        this.indexedTensorCellSubspace(cells);
        while (this.jj_2_11(2)) {
            this.jj_consume_token(22);
            this.indexedTensorCellSubspace(cells);
        }
    }

    public final void indexedTensorCellSubspace(List cells) throws ParseException {
        switch (this.jj_nt.kind) {
            case 10: {
                this.jj_consume_token(10);
                this.indexedTensorCellSubspaceList(cells);
                this.jj_consume_token(11);
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 15: 
            case 21: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                ExpressionNode value = this.expression();
                cells.add(value);
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void tensorCell(TensorType type, Map cells) throws ParseException {
        TensorAddress.Builder addressBuilder = new TensorAddress.Builder(type);
        this.jj_consume_token(12);
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 32: 
                case 33: 
                case 34: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: {
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    break block6;
                }
            }
            this.labelAndDimension(addressBuilder);
        }
        block7: while (true) {
            switch (this.jj_nt.kind) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[47] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(22);
            this.labelAndDimension(addressBuilder);
        }
        this.jj_consume_token(13);
        this.jj_consume_token(23);
        ExpressionNode value = this.expression();
        cells.put(addressBuilder.build(), value);
    }

    public final void labelAndDimension(TensorAddress.Builder addressBuilder) throws ParseException {
        String dimension = this.identifier();
        this.jj_consume_token(23);
        String label = this.label();
        addressBuilder.add(dimension, label);
    }

    public final void labelAndDimensionValues(List addressValues) throws ParseException {
        String dimension = this.identifier();
        this.jj_consume_token(23);
        Slice.DimensionValue dimensionValue = this.dimensionValue(Optional.of(dimension));
        addressValues.add(dimensionValue);
    }

    public final List valueAddress() throws ParseException {
        ArrayList<Slice.DimensionValue> dimensionValues = new ArrayList<Slice.DimensionValue>();
        block0 : switch (this.jj_nt.kind) {
            case 10: {
                this.jj_consume_token(10);
                ExpressionNode valueExpression = this.expression();
                dimensionValues.add(new Slice.DimensionValue(TensorFunctionNode.wrapScalar(valueExpression)));
                this.jj_consume_token(11);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                if (this.jj_2_12(3)) {
                    this.jj_consume_token(12);
                    block12: while (true) {
                        this.labelAndDimensionValues(dimensionValues);
                        switch (this.jj_nt.kind) {
                            case 32: 
                            case 33: 
                            case 34: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: {
                                continue block12;
                            }
                        }
                        break;
                    }
                    this.jj_la1[48] = this.jj_gen;
                    block13: while (true) {
                        switch (this.jj_nt.kind) {
                            case 22: {
                                break;
                            }
                            default: {
                                this.jj_la1[49] = this.jj_gen;
                                break block13;
                            }
                        }
                        this.jj_consume_token(22);
                        this.labelAndDimensionValues(dimensionValues);
                    }
                    this.jj_consume_token(13);
                    break;
                }
                switch (this.jj_nt.kind) {
                    case 12: {
                        this.jj_consume_token(12);
                        Slice.DimensionValue dimensionValue = this.dimensionValue(Optional.empty());
                        dimensionValues.add(dimensionValue);
                        this.jj_consume_token(13);
                        break block0;
                    }
                }
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return dimensionValues;
    }

    public final Slice.DimensionValue dimensionValue(Optional dimensionName) throws ParseException {
        ExpressionNode value = this.expression();
        if (value instanceof ReferenceNode && ((ReferenceNode)value).reference().isIdentifier()) {
            return new Slice.DimensionValue(dimensionName, ((ReferenceNode)value).reference().name());
        }
        if (value instanceof ConstantNode && ((ConstantNode)value).getValue() instanceof StringValue) {
            return new Slice.DimensionValue(dimensionName, ((StringValue)((ConstantNode)value).getValue()).asString());
        }
        return new Slice.DimensionValue(dimensionName, TensorFunctionNode.wrapScalar(value));
    }

    public final String label() throws ParseException {
        return switch (this.jj_nt.kind) {
            case 2, 15, 32, 33, 34, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99 -> this.tag();
            case 31 -> this.string();
            default -> {
                this.jj_la1[52] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final String string() throws ParseException {
        this.jj_consume_token(31);
        return this.token.image.substring(1, this.token.image.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    private boolean jj_3R_60() {
        if (this.jj_3R_70()) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_147() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        return this.jj_3R_170();
    }

    private boolean jj_3R_148() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        return this.jj_3R_170();
    }

    private boolean jj_3R_18() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_12()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_28()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_27() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3_12() {
        Token xsp;
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3R_25()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_25());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_149() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        return this.jj_3R_170();
    }

    private boolean jj_3R_28() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        return this.jj_3R_62();
    }

    private boolean jj_3R_25() {
        return this.jj_3R_60();
    }

    private boolean jj_3R_150() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_62() {
        return this.jj_3R_20();
    }

    private boolean jj_3R_151() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_68()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_69()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_68() {
        return this.jj_3R_130();
    }

    private boolean jj_3R_152() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_131() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_153() {
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_69() {
        return this.jj_3R_131();
    }

    private boolean jj_3R_154() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_155() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_156() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_160() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_157() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_3R_169()) {
            return true;
        }
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_158() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_3R_169()) {
            return true;
        }
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_159() {
        if (this.jj_scan_token(88)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_66() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(90)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(91)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(92)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(93)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(94)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(95)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(96)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_170() {
        if (this.jj_3R_180()) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_181()) {
            this.jj_scanpos = xsp;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_182());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_181() {
        return this.jj_3R_189();
    }

    private boolean jj_3R_182() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_3R_189();
    }

    private boolean jj_3R_180() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_188()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_188() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_3R_70()) {
            return true;
        }
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_189() {
        if (this.jj_3R_70()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_205()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_6()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_206()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_20() {
        if (this.jj_3R_31()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_168()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_205() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_206() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_168() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_33()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_34()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_35()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_36()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_37()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_38()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_39()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_40()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_41()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_42()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_43()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_44()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_45()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_46()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_47()) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_3R_48()) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_3R_49()) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_3R_50()) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_3R_51()) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_3R_52()) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_3R_53()) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_3R_54()) {
                                                                                                    return true;
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_32() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_33() {
        return this.jj_scan_token(69);
    }

    private boolean jj_3R_31() {
        Token xsp;
        if (this.jj_3R_65()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_178());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_34() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_35() {
        return this.jj_scan_token(71);
    }

    private boolean jj_3R_36() {
        return this.jj_scan_token(72);
    }

    private boolean jj_3R_37() {
        return this.jj_scan_token(73);
    }

    private boolean jj_3R_38() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_39() {
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_178() {
        return this.jj_3R_187();
    }

    private boolean jj_3R_40() {
        return this.jj_scan_token(76);
    }

    private boolean jj_3R_41() {
        return this.jj_scan_token(77);
    }

    private boolean jj_3R_42() {
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_187() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_190()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_191()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_192()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_193()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_194()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_195()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_196()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_197()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_198()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_199()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_200()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_201()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_202()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_203()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_204()) {
                                                                    return true;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_43() {
        return this.jj_scan_token(79);
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(80);
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(81);
    }

    private boolean jj_3R_190() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_46() {
        return this.jj_scan_token(82);
    }

    private boolean jj_3R_191() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_47() {
        return this.jj_scan_token(83);
    }

    private boolean jj_3R_192() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_48() {
        return this.jj_scan_token(84);
    }

    private boolean jj_3R_193() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_49() {
        return this.jj_scan_token(85);
    }

    private boolean jj_3R_194() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_50() {
        return this.jj_scan_token(86);
    }

    private boolean jj_3R_195() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_51() {
        return this.jj_scan_token(87);
    }

    private boolean jj_3R_196() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_52() {
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_197() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_53() {
        return this.jj_scan_token(89);
    }

    private boolean jj_3R_198() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_54() {
        return this.jj_3R_66();
    }

    private boolean jj_3R_199() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_200() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_201() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3R_202() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_203() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_63() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_93()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_94()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_95()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_96()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_97()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_98()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_99()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_100()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_101()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_102()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_103()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_104()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_105()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_106()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_107()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_108()) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_3R_109()) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_3R_110()) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_3R_111()) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_3R_112()) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_3R_113()) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_3R_114()) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_3R_115()) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_3R_116()) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_3R_117()) {
                                                                                                            return true;
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_93() {
        return this.jj_scan_token(38);
    }

    private boolean jj_3R_204() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_94() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_95() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_96() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_97() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_98() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_99() {
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_100() {
        return this.jj_scan_token(45);
    }

    private boolean jj_3R_101() {
        return this.jj_scan_token(46);
    }

    private boolean jj_3R_102() {
        return this.jj_scan_token(47);
    }

    private boolean jj_3R_103() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_65() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_126()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_1()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_127()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_128()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_104() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3R_105() {
        return this.jj_scan_token(50);
    }

    private boolean jj_3R_106() {
        return this.jj_scan_token(51);
    }

    private boolean jj_3R_107() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_108() {
        return this.jj_scan_token(53);
    }

    private boolean jj_3R_109() {
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_126() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3_1() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_110() {
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_111() {
        return this.jj_scan_token(56);
    }

    private boolean jj_3R_127() {
        return this.jj_3R_161();
    }

    private boolean jj_3R_112() {
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_128() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_162()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_163()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_164()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_113() {
        return this.jj_scan_token(58);
    }

    private boolean jj_3R_114() {
        return this.jj_scan_token(59);
    }

    private boolean jj_3_2() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_115() {
        return this.jj_scan_token(60);
    }

    private boolean jj_3_3() {
        return this.jj_3R_17();
    }

    private boolean jj_3R_116() {
        return this.jj_scan_token(61);
    }

    private boolean jj_3R_117() {
        return this.jj_scan_token(62);
    }

    private boolean jj_3R_162() {
        return this.jj_3R_176();
    }

    private boolean jj_3R_163() {
        return this.jj_3R_177();
    }

    private boolean jj_3R_164() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3_4() {
        return this.jj_3R_18();
    }

    private boolean jj_3R_64() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_118()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_119()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_120()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_121()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_122()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_123()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_124()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_125()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_118() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_119() {
        return this.jj_scan_token(64);
    }

    private boolean jj_3R_120() {
        return this.jj_scan_token(65);
    }

    private boolean jj_3R_121() {
        return this.jj_scan_token(92);
    }

    private boolean jj_3R_122() {
        return this.jj_scan_token(94);
    }

    private boolean jj_3R_123() {
        return this.jj_scan_token(66);
    }

    private boolean jj_3R_124() {
        return this.jj_scan_token(67);
    }

    private boolean jj_3R_125() {
        return this.jj_scan_token(68);
    }

    private boolean jj_3R_16() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        return this.jj_scan_token(8);
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3R_176() {
        if (this.jj_3R_70()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_207()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_208()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_177() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        return this.jj_3R_70();
    }

    private boolean jj_3R_207() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3_8() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_70() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_132()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_133()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_134()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_135()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_136()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_137()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_138()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_132() {
        return this.jj_3R_63();
    }

    private boolean jj_3R_133() {
        return this.jj_3R_64();
    }

    private boolean jj_3R_134() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_135() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_136() {
        return this.jj_scan_token(99);
    }

    private boolean jj_3R_137() {
        return this.jj_scan_token(97);
    }

    private boolean jj_3R_138() {
        return this.jj_scan_token(98);
    }

    private boolean jj_3R_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_26()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_208() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3_5() {
        return this.jj_3R_19();
    }

    private boolean jj_3R_130() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_165()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_166()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_167()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_165() {
        return this.jj_3R_70();
    }

    private boolean jj_3R_166() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(2);
    }

    private boolean jj_3R_167() {
        return this.jj_scan_token(2);
    }

    private boolean jj_3R_19() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_30()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_29() {
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_30() {
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_169() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_179());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_179() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_161() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_173()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_174()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_175()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_61() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_71()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_72()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_73()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_74()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_75()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_76()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_77()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_78()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_79()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_80()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_81()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_82()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_83()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_84()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_85()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_86()) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_3R_87()) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_3R_88()) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_3R_89()) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_3R_90()) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_3R_91()) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_3R_92()) {
                                                                                                return true;
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_173() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_174() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_185()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_186()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_71() {
        return this.jj_3R_139();
    }

    private boolean jj_3R_185() {
        return this.jj_scan_token(2);
    }

    private boolean jj_3R_72() {
        return this.jj_3R_140();
    }

    private boolean jj_3R_175() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(31)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(97)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(98)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_186() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_73() {
        return this.jj_3R_141();
    }

    private boolean jj_3R_74() {
        return this.jj_3R_142();
    }

    private boolean jj_3R_75() {
        return this.jj_3R_143();
    }

    private boolean jj_3R_76() {
        return this.jj_3R_144();
    }

    private boolean jj_3R_77() {
        return this.jj_3R_145();
    }

    private boolean jj_3R_78() {
        return this.jj_3R_146();
    }

    private boolean jj_3R_79() {
        return this.jj_3R_147();
    }

    private boolean jj_3R_80() {
        return this.jj_3R_148();
    }

    private boolean jj_3R_81() {
        return this.jj_3R_149();
    }

    private boolean jj_3R_82() {
        return this.jj_3R_150();
    }

    private boolean jj_3R_83() {
        return this.jj_3R_151();
    }

    private boolean jj_3R_184() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_84() {
        return this.jj_3R_152();
    }

    private boolean jj_3R_85() {
        return this.jj_3R_153();
    }

    private boolean jj_3R_86() {
        return this.jj_3R_154();
    }

    private boolean jj_3R_87() {
        return this.jj_3R_155();
    }

    private boolean jj_3R_88() {
        return this.jj_3R_156();
    }

    private boolean jj_3_9() {
        return this.jj_3R_22();
    }

    private boolean jj_3R_89() {
        return this.jj_3R_157();
    }

    private boolean jj_3R_90() {
        return this.jj_3R_158();
    }

    private boolean jj_3R_91() {
        return this.jj_3R_159();
    }

    private boolean jj_3R_92() {
        return this.jj_3R_160();
    }

    private boolean jj_3R_26() {
        return this.jj_3R_61();
    }

    private boolean jj_3R_139() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_22() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        return this.jj_3R_55();
    }

    private boolean jj_3R_140() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_141() {
        if (this.jj_3R_66()) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_3R_169()) {
            return true;
        }
        return this.jj_scan_token(9);
    }

    private boolean jj_3_10() {
        return this.jj_3R_23();
    }

    private boolean jj_3R_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_67()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_142() {
        if (this.jj_scan_token(71)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_129() {
        return this.jj_3R_56();
    }

    private boolean jj_3R_143() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_23() {
        if (this.jj_3R_56()) {
            return true;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_57();
    }

    private boolean jj_3R_57() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_144() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_145() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_58()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_59()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_58() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_59() {
        return this.jj_3R_20();
    }

    private boolean jj_3R_146() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_3R_170()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_171()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_172()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_67() {
        return this.jj_3R_129();
    }

    private boolean jj_3R_171() {
        return this.jj_3R_183();
    }

    private boolean jj_3R_172() {
        return this.jj_3R_184();
    }

    private boolean jj_3R_183() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3_11() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_3R_24();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 2132525056, 2132525056, 0, 0x200100, -2145353404, 0x400000, 256, 262144, 262144, 68, 0x400000, -2145353404, 0, 0, 0, 0x800100, 0, 0, 0x400000, 0x8000000, 4096, 1024, 0, 0, 0, 32768, 68, 32768, 0, 0, 0x400000, 256, 32772, 0x400000, 32768, 68, Integer.MIN_VALUE, -2147483580, 5120, 4096, 0x400000, 0x400000, -2147450876, -2145352380, 0, 0x400000, 0, 0x400000, 1024, 4096, -2147450876};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{-57, 2, 48, 48, 8, -57, -57, 0, 0, 0, 0, -57, 0, -49, 0, -64, 0, 0, 0, -57, 0, 0, 0, 0, 4, 2147483584, Integer.MIN_VALUE, 0, 0, 0, -61, -57, 0, -57, -57, 0, 0, 0, 0, 0, 0, 0, 0, 0, -57, -49, -57, 0, -57, 0, 0, 0, -57};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{-1, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1, 0, -1, -32, 1342177311, -32, 0, -67108864, -1, 0, 0, 0, 0, -32, 0, 1342177311, 0, 0, 0, 1342177311, -1, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, -1, 0, 0, 0, -1};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{15, 0, 0, 0, 0, 15, 15, 0, 0, 0, 0, 15, 0, 15, 1, 0, 1, 0, 1, 15, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 14, 15, 0, 15, 15, 0, 0, 0, 6, 6, 0, 0, 0, 0, 15, 15, 15, 0, 15, 0, 0, 0, 15};
    }

    public RankingExpressionParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        this.token_source = new RankingExpressionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 53; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.reInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 53; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public RankingExpressionParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new RankingExpressionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 53; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.reInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new RankingExpressionParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 53; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public RankingExpressionParser(RankingExpressionParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 53; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(RankingExpressionParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 53; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            if (t.next == null) {
                t.next = this.token_source.getNextToken();
            }
            t = t.next;
        }
        return t;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[101];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 53; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 101; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return false;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 12; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_scanpos = p.first;
                    this.jj_lastpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        RankingExpressionParser.jj_la1_init_0();
        RankingExpressionParser.jj_la1_init_1();
        RankingExpressionParser.jj_la1_init_2();
        RankingExpressionParser.jj_la1_init_3();
    }

    private static final class LookaheadSuccess
    extends IllegalStateException {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

