/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.searchlib.aggregation.AggregationResult;
import com.yahoo.searchlib.aggregation.Hit;
import com.yahoo.searchlib.expression.FloatResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class HitsAggregationResult
extends AggregationResult {
    public static final int classId = HitsAggregationResult.registerClass((int)16471, HitsAggregationResult.class);
    private String summaryClass = "default";
    private int maxHits = -1;
    private List<Hit> hits = new ArrayList<Hit>();

    public HitsAggregationResult() {
    }

    public HitsAggregationResult(int maxHits) {
        this.maxHits = maxHits;
    }

    public HitsAggregationResult(int maxHits, String summaryClass) {
        this.summaryClass = summaryClass;
        this.maxHits = maxHits;
    }

    public String getSummaryClass() {
        return this.summaryClass;
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public HitsAggregationResult setSummaryClass(String summaryClass) {
        this.summaryClass = summaryClass;
        return this;
    }

    public HitsAggregationResult setMaxHits(int maxHits) {
        this.maxHits = maxHits;
        return this;
    }

    public List<Hit> getHits() {
        return this.hits;
    }

    public HitsAggregationResult addHit(Hit h) {
        this.hits.add(h);
        return this;
    }

    @Override
    public ResultNode getRank() {
        if (this.hits.isEmpty()) {
            return new FloatResultNode(0.0);
        }
        return new FloatResultNode(this.hits.get(0).getRank());
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        byte[] raw = Utf8.toBytes((String)this.summaryClass);
        buf.putInt(null, raw.length);
        buf.put(null, raw);
        buf.putInt(null, this.maxHits);
        int numHits = this.hits.size();
        buf.putInt(null, numHits);
        for (Hit h : this.hits) {
            HitsAggregationResult.serializeOptional((Serializer)buf, (Identifiable)h);
        }
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.summaryClass = this.getUtf8(buf);
        this.maxHits = buf.getInt(null);
        int numHits = buf.getInt(null);
        for (int i = 0; i < numHits; ++i) {
            Hit h = (Hit)HitsAggregationResult.deserializeOptional((Deserializer)buf);
            this.hits.add(h);
        }
    }

    @Override
    protected void onMerge(AggregationResult result) {
        this.hits.addAll(((HitsAggregationResult)result).hits);
    }

    @Override
    public void postMerge() {
        Collections.sort(this.hits, new Comparator<Hit>(){

            @Override
            public int compare(Hit lhs, Hit rhs) {
                return lhs.getRank() > rhs.getRank() ? -1 : (lhs.getRank() < rhs.getRank() ? 1 : 0);
            }
        });
        if (this.maxHits >= 0 && this.hits.size() > this.maxHits) {
            this.hits = this.hits.subList(0, this.maxHits);
        }
    }

    @Override
    protected boolean equalsAggregation(AggregationResult obj) {
        HitsAggregationResult rhs = (HitsAggregationResult)obj;
        if (!this.summaryClass.equals(rhs.summaryClass)) {
            return false;
        }
        if (this.maxHits != rhs.maxHits) {
            return false;
        }
        return this.hits.equals(rhs.hits);
    }

    public int hashCode() {
        return super.hashCode() + this.summaryClass.hashCode() + this.maxHits + this.hits.hashCode();
    }

    @Override
    public HitsAggregationResult clone() {
        HitsAggregationResult obj = (HitsAggregationResult)super.clone();
        obj.summaryClass = this.summaryClass;
        obj.maxHits = this.maxHits;
        obj.hits = new ArrayList<Hit>();
        for (Hit hit : this.hits) {
            obj.hits.add((Hit)hit.clone());
        }
        return obj;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("summaryClass", (Object)this.summaryClass);
        visitor.visit("maxHits", (Object)this.maxHits);
        visitor.visit("hits", this.hits);
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        for (Hit hit : this.hits) {
            hit.select(predicate, operation);
        }
    }
}

