/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.RawResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.ResultNodeVector;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;

public class RawResultNodeVector
extends ResultNodeVector {
    public static final int classId = RawResultNodeVector.registerClass((int)16499, RawResultNodeVector.class);
    private ArrayList<RawResultNode> vector = new ArrayList();

    @Override
    protected int onGetClassId() {
        return classId;
    }

    public RawResultNodeVector add(RawResultNode v) {
        this.vector.add(v);
        return this;
    }

    @Override
    public ResultNodeVector add(ResultNode r) {
        return this.add((RawResultNode)r);
    }

    public ArrayList<RawResultNode> getVector() {
        return this.vector;
    }

    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putInt(null, this.vector.size());
        for (RawResultNode node : this.vector) {
            node.serialize(buf);
        }
    }

    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        int sz = buf.getInt(null);
        this.vector = new ArrayList();
        for (int i = 0; i < sz; ++i) {
            RawResultNode node = new RawResultNode();
            node.deserialize(buf);
            this.vector.add(node);
        }
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        if (classId != rhs.getClassId()) {
            return classId - rhs.getClassId();
        }
        RawResultNodeVector b = (RawResultNodeVector)rhs;
        int minLength = this.vector.size();
        if (b.vector.size() < minLength) {
            minLength = b.vector.size();
        }
        int diff = 0;
        for (int i = 0; diff == 0 && i < minLength; ++i) {
            diff = this.vector.get(i).compareTo(b.vector.get(i));
        }
        return diff == 0 ? this.vector.size() - b.vector.size() : diff;
    }
}

