/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.ml.importer.operations;

import com.yahoo.searchlib.rankingexpression.integration.ml.importer.DimensionRenamer;
import com.yahoo.searchlib.rankingexpression.integration.ml.importer.OrderedTensorType;
import com.yahoo.searchlib.rankingexpression.integration.ml.importer.operations.IntermediateOperation;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.VariableTensor;
import com.yahoo.tensor.functions.Rename;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.Collections;
import java.util.List;

public class Argument
extends IntermediateOperation {
    private OrderedTensorType standardNamingType;

    public Argument(String modelName, String nodeName, OrderedTensorType type) {
        super(modelName, nodeName, Collections.emptyList());
        this.type = type.rename(this.vespaName() + "_");
        this.standardNamingType = OrderedTensorType.standardType(type);
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        return this.type;
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        VariableTensor output = new VariableTensor(this.vespaName(), this.standardNamingType.type());
        if (!this.standardNamingType.equals(this.type)) {
            List<String> renameFrom = this.standardNamingType.dimensionNames();
            List<String> renameTo = this.type.dimensionNames();
            output = new Rename((TensorFunction)output, renameFrom, renameTo);
        }
        return output;
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        for (TensorType.Dimension dimension : this.type.type().dimensions()) {
            renamer.addDimension(dimension.name());
        }
    }

    @Override
    public boolean isInput() {
        return true;
    }

    @Override
    public boolean isConstant() {
        return false;
    }
}

