/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.ml.importer;

import com.yahoo.searchlib.rankingexpression.integration.ml.importer.DimensionRenamer;
import com.yahoo.searchlib.rankingexpression.integration.ml.importer.operations.IntermediateOperation;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class IntermediateGraph {
    private final String modelName;
    private final Map<String, IntermediateOperation> index = new HashMap<String, IntermediateOperation>();
    private final Map<String, GraphSignature> signatures = new HashMap<String, GraphSignature>();

    public IntermediateGraph(String modelName) {
        this.modelName = modelName;
    }

    public String name() {
        return this.modelName;
    }

    public IntermediateOperation put(String key, IntermediateOperation operation) {
        return this.index.put(key, operation);
    }

    public IntermediateOperation get(String key) {
        return this.index.get(key);
    }

    public Set<String> signatures() {
        return this.signatures.keySet();
    }

    public Map<String, String> inputs(String signature) {
        return this.signatures.computeIfAbsent((String)signature, (Function<String, GraphSignature>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$inputs$0(java.lang.String ), (Ljava/lang/String;)Lcom/yahoo/searchlib/rankingexpression/integration/ml/importer/IntermediateGraph$GraphSignature;)()).inputs;
    }

    public Map<String, String> outputs(String signature) {
        return this.signatures.computeIfAbsent((String)signature, (Function<String, GraphSignature>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$outputs$1(java.lang.String ), (Ljava/lang/String;)Lcom/yahoo/searchlib/rankingexpression/integration/ml/importer/IntermediateGraph$GraphSignature;)()).outputs;
    }

    public String defaultSignature() {
        return "default";
    }

    public boolean alreadyImported(String key) {
        return this.index.containsKey(key);
    }

    public Collection<IntermediateOperation> operations() {
        return this.index.values();
    }

    public void optimize() {
        this.renameDimensions();
    }

    private void renameDimensions() {
        DimensionRenamer renamer = new DimensionRenamer();
        for (String signature : this.signatures()) {
            for (String output : this.outputs(signature).values()) {
                IntermediateGraph.addDimensionNameConstraints(this.index.get(output), renamer);
            }
        }
        renamer.solve();
        for (String signature : this.signatures()) {
            for (String output : this.outputs(signature).values()) {
                IntermediateGraph.renameDimensions(this.index.get(output), renamer);
            }
        }
    }

    private static void addDimensionNameConstraints(IntermediateOperation operation, DimensionRenamer renamer) {
        if (operation.type().isPresent()) {
            operation.inputs().forEach(input -> IntermediateGraph.addDimensionNameConstraints(input, renamer));
            operation.addDimensionNameConstraints(renamer);
        }
    }

    private static void renameDimensions(IntermediateOperation operation, DimensionRenamer renamer) {
        if (operation.type().isPresent()) {
            operation.inputs().forEach(input -> IntermediateGraph.renameDimensions(input, renamer));
            operation.renameDimensions(renamer);
        }
    }

    private static /* synthetic */ GraphSignature lambda$outputs$1(String k) {
        return new GraphSignature();
    }

    private static /* synthetic */ GraphSignature lambda$inputs$0(String k) {
        return new GraphSignature();
    }

    private static class GraphSignature {
        final Map<String, String> inputs = new HashMap<String, String>();
        final Map<String, String> outputs = new HashMap<String, String>();

        private GraphSignature() {
        }
    }
}

