/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.ml;

import com.yahoo.searchlib.rankingexpression.integration.ml.ImportedModel;
import com.yahoo.searchlib.rankingexpression.integration.ml.ModelImporter;
import com.yahoo.searchlib.rankingexpression.integration.ml.importer.IntermediateGraph;
import com.yahoo.searchlib.rankingexpression.integration.ml.importer.onnx.GraphImporter;
import java.io.FileInputStream;
import java.io.IOException;
import onnx.Onnx;

public class OnnxImporter
extends ModelImporter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImportedModel importModel(String modelName, String modelPath) {
        try (FileInputStream inputStream = new FileInputStream(modelPath);){
            Onnx.ModelProto model = Onnx.ModelProto.parseFrom(inputStream);
            IntermediateGraph graph = GraphImporter.importGraph(modelName, model);
            ImportedModel importedModel = OnnxImporter.convertIntermediateGraphToModel(graph);
            return importedModel;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not import ONNX model from '" + modelPath + "'", e);
        }
    }
}

