/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.tensorflow;

import com.google.common.collect.ImmutableList;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.AttrValueConverter;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.TensorConverter;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.TensorFlowImporter;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.TypedTensorFunction;
import com.yahoo.searchlib.rankingexpression.rule.ArithmeticNode;
import com.yahoo.searchlib.rankingexpression.rule.ArithmeticOperator;
import com.yahoo.searchlib.rankingexpression.rule.ComparisonNode;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.GeneratorLambdaFunctionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.TensorFunctionNode;
import com.yahoo.searchlib.rankingexpression.rule.TruthOperator;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.VariableTensor;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.Map;
import com.yahoo.tensor.functions.Matmul;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.Rename;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.Softmax;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.tensorflow.Session;
import org.tensorflow.Tensor;
import org.tensorflow.framework.AttrValue;

class OperationMapper {
    OperationMapper() {
    }

    static Optional<TypedTensorFunction> map(TensorFlowImporter.Parameters params) {
        Optional<Operation> operation = Stream.of(Operation.values()).filter(op -> op.name().equalsIgnoreCase(params.node().getOp())).findFirst();
        if (operation.isPresent()) {
            return operation.get().map(params);
        }
        params.signature().importWarning("TensorFlow operation '" + params.node().getOp() + "' in node '" + params.node().getName() + "' is not supported.");
        return Optional.empty();
    }

    private static Optional<TypedTensorFunction> constant(TensorFlowImporter.Parameters params) {
        com.yahoo.tensor.Tensor value = AttrValueConverter.toVespaTensor(params.node(), "value");
        return OperationMapper.createConstant(params, value);
    }

    private static Optional<TypedTensorFunction> expandDims(TensorFlowImporter.Parameters params) {
        if (!OperationMapper.checkInputs(params, 2)) {
            return Optional.empty();
        }
        List<Optional<TypedTensorFunction>> inputs = params.inputs();
        com.yahoo.tensor.Tensor axis = OperationMapper.getConstantTensor(params, params.node().getInput(1));
        if (axis.type().rank() != 0) {
            throw new IllegalArgumentException("Axis argument to ExpandDims must be a scalar");
        }
        TensorFunction inputFunction = inputs.get(0).get().function();
        TensorType inputType = inputs.get(0).get().type();
        int dimensionToInsert = (int)axis.asDouble();
        if (dimensionToInsert < 0) {
            dimensionToInsert = inputType.dimensions().size() - dimensionToInsert;
        }
        TensorType.Builder outputTypeBuilder = new TensorType.Builder();
        int dimensionIndex = 0;
        for (int i = 0; i < inputType.dimensions().size() + 1; ++i) {
            Long size;
            String name = String.format("temp_%d", i);
            if (i == dimensionToInsert) {
                size = 1L;
            } else {
                size = OperationMapper.dimensionSize((TensorType.Dimension)inputType.dimensions().get(dimensionIndex));
                ++dimensionIndex;
            }
            outputTypeBuilder.indexed(name, size.longValue());
        }
        return OperationMapper.reshape(inputFunction, inputType, outputTypeBuilder.build());
    }

    private static Optional<TypedTensorFunction> identity(TensorFlowImporter.Parameters params) {
        if (!OperationMapper.checkInputs(params, 1)) {
            return Optional.empty();
        }
        return params.inputs().get(0);
    }

    private static Optional<TypedTensorFunction> placeholder(TensorFlowImporter.Parameters params) {
        String name = params.node().getName();
        String vespaName = OperationMapper.toVespaName(params.node().getName());
        TensorType type = params.result().arguments().get(name);
        if (type == null) {
            throw new IllegalArgumentException("A 'placeholder' node is referencing placeholder '" + name + "', but there is no such placeholder");
        }
        params.result().requiredMacro(vespaName, type);
        TypedTensorFunction output = new TypedTensorFunction(type, (TensorFunction)new VariableTensor(vespaName, type));
        return Optional.of(output);
    }

    private static Optional<TypedTensorFunction> placeholderWithDefault(TensorFlowImporter.Parameters params) {
        String name = OperationMapper.toVespaName(params.node().getInput(0));
        com.yahoo.tensor.Tensor defaultValue = OperationMapper.getConstantTensor(params, params.node().getInput(0));
        params.result().largeConstant(name, defaultValue);
        params.result().macro(name, new RankingExpression(name, new ReferenceNode("constant(\"" + name + "\")")));
        TypedTensorFunction output = new TypedTensorFunction(defaultValue.type(), (TensorFunction)new VariableTensor(name));
        return Optional.of(output);
    }

    private static Optional<TypedTensorFunction> reshape(TensorFlowImporter.Parameters params) {
        if (!OperationMapper.checkInputs(params, 2)) {
            return Optional.empty();
        }
        List<Optional<TypedTensorFunction>> inputs = params.inputs();
        com.yahoo.tensor.Tensor shape = OperationMapper.getConstantTensor(params, params.node().getInput(1));
        TensorFunction inputFunction = inputs.get(0).get().function();
        TensorType inputType = inputs.get(0).get().type();
        TensorType.Builder outputTypeBuilder = new TensorType.Builder();
        int dimensionIndex = 0;
        Iterator cellIterator = shape.cellIterator();
        while (cellIterator.hasNext()) {
            Tensor.Cell cell = (Tensor.Cell)cellIterator.next();
            int size = cell.getValue().intValue();
            if (size < 0) {
                size = -1 * (int)shape.reduce(Reduce.Aggregator.prod, new String[0]).asDouble() / OperationMapper.tensorSize(inputType).intValue();
            }
            outputTypeBuilder.indexed(String.format("temp_%d", dimensionIndex), (long)size);
            ++dimensionIndex;
        }
        return OperationMapper.reshape(inputFunction, inputType, outputTypeBuilder.build());
    }

    private static Optional<TypedTensorFunction> squeeze(TensorFlowImporter.Parameters params) {
        if (!OperationMapper.checkInputs(params, 1)) {
            return Optional.empty();
        }
        List<Optional<TypedTensorFunction>> inputs = params.inputs();
        TensorFunction inputFunction = inputs.get(0).get().function();
        TensorType inputType = inputs.get(0).get().type();
        AttrValue squeezeDimsAttr = (AttrValue)params.node().getAttrMap().get("squeeze_dims");
        List squeezeDimensions = squeezeDimsAttr == null ? inputType.dimensions().stream().filter(dim -> OperationMapper.dimensionSize(dim) == 1L).map(TensorType.Dimension::name).collect(Collectors.toList()) : squeezeDimsAttr.getList().getIList().stream().map(i -> i < 0L ? (long)inputType.dimensions().size() - i : i).map(i -> (TensorType.Dimension)inputType.dimensions().get(i.intValue())).filter(dim -> OperationMapper.dimensionSize(dim) == 1L).map(TensorType.Dimension::name).collect(Collectors.toList());
        if (squeezeDimensions.isEmpty()) {
            return inputs.get(0);
        }
        Reduce outputFunction = new Reduce(inputFunction, Reduce.Aggregator.sum, squeezeDimensions);
        TensorType outputType = Reduce.outputType((TensorType)inputType, squeezeDimensions);
        TypedTensorFunction output = OperationMapper.checkNamingConvention(outputType, (TensorFunction)outputFunction);
        return Optional.of(output);
    }

    private static Optional<TypedTensorFunction> merge(TensorFlowImporter.Parameters params) {
        return params.inputs().stream().filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private static Optional<TypedTensorFunction> switchOp(TensorFlowImporter.Parameters params) {
        int output;
        if (!OperationMapper.checkInputs(params, 2)) {
            return Optional.empty();
        }
        List<Optional<TypedTensorFunction>> inputs = params.inputs();
        com.yahoo.tensor.Tensor predicate = OperationMapper.getConstantTensor(params, params.node().getInput(1));
        if (predicate.type().rank() != 0) {
            throw new IllegalArgumentException("'switch': predicate must be a scalar");
        }
        double pred = predicate.asDouble();
        int n = output = params.port().length() > 0 ? Integer.parseInt(params.port()) : 0;
        if (output < 0 || output > 1) {
            throw new IllegalArgumentException("'switch': predicate is not boolean");
        }
        if (pred == (double)output) {
            return inputs.get(0);
        }
        return Optional.empty();
    }

    private static Optional<TypedTensorFunction> add(TensorFlowImporter.Parameters params) {
        return OperationMapper.join(params, ScalarFunctions.add());
    }

    private static Optional<TypedTensorFunction> acos(TensorFlowImporter.Parameters params) {
        return OperationMapper.map(params, ScalarFunctions.acos());
    }

    private static Optional<TypedTensorFunction> div(TensorFlowImporter.Parameters params) {
        return OperationMapper.join(params, ScalarFunctions.divide());
    }

    private static Optional<TypedTensorFunction> floor(TensorFlowImporter.Parameters params) {
        return OperationMapper.map(params, ScalarFunctions.floor());
    }

    private static Optional<TypedTensorFunction> matmul(TensorFlowImporter.Parameters params) {
        List<Optional<TypedTensorFunction>> inputs = params.inputs();
        if (!OperationMapper.checkInputs(params, 2)) {
            return Optional.empty();
        }
        TypedTensorFunction a = inputs.get(0).get();
        TypedTensorFunction b = inputs.get(1).get();
        if (a.type().rank() < 2 || b.type().rank() < 2) {
            throw new IllegalArgumentException("Tensors in matmul must have rank of at least 2");
        }
        if (a.type().rank() != b.type().rank()) {
            throw new IllegalArgumentException("Tensors in matmul must have the same rank");
        }
        String afterLastDim = "d" + (a.type().rank() + 1);
        Rename renamedB = new Rename(b.function(), (List)ImmutableList.of((Object)"d0", (Object)"d1"), (List)ImmutableList.of((Object)"d1", (Object)afterLastDim));
        Matmul matmul = new Matmul(a.function(), (TensorFunction)renamedB, "d1");
        TypedTensorFunction output = new TypedTensorFunction(Matmul.outputType((TensorType)a.type(), (TensorType)b.type(), (String)"d1"), (TensorFunction)new Rename((TensorFunction)matmul, afterLastDim, "d1"));
        return Optional.of(output);
    }

    private static Optional<TypedTensorFunction> maximum(TensorFlowImporter.Parameters params) {
        return OperationMapper.join(params, ScalarFunctions.max());
    }

    private static Optional<TypedTensorFunction> mean(TensorFlowImporter.Parameters params) {
        if (!OperationMapper.checkInputs(params, 2)) {
            return Optional.empty();
        }
        List<Optional<TypedTensorFunction>> inputs = params.inputs();
        TensorFunction inputFunction = inputs.get(0).get().function();
        TensorType inputType = inputs.get(0).get().type();
        com.yahoo.tensor.Tensor reductionIndices = OperationMapper.getConstantTensor(params, params.node().getInput(1));
        ArrayList<String> reduceDimensions = new ArrayList<String>();
        Iterator cellIterator = reductionIndices.cellIterator();
        while (cellIterator.hasNext()) {
            Tensor.Cell cell = (Tensor.Cell)cellIterator.next();
            int dimensionIndex = cell.getValue().intValue();
            if (dimensionIndex < 0) {
                dimensionIndex = inputType.dimensions().size() - dimensionIndex;
            }
            reduceDimensions.add(((TensorType.Dimension)inputType.dimensions().get(dimensionIndex)).name());
        }
        TensorType outputType = Reduce.outputType((TensorType)inputType, reduceDimensions);
        Reduce outputFunction = new Reduce(inputFunction, Reduce.Aggregator.avg, reduceDimensions);
        if (OperationMapper.shouldKeepDimensions(params)) {
            return OperationMapper.reshape((TensorFunction)outputFunction, outputType, OperationMapper.keepDimensionType(inputType, reduceDimensions));
        }
        TypedTensorFunction output = OperationMapper.checkNamingConvention(outputType, (TensorFunction)outputFunction);
        return Optional.of(output);
    }

    private static Optional<TypedTensorFunction> mul(TensorFlowImporter.Parameters params) {
        return OperationMapper.join(params, ScalarFunctions.multiply());
    }

    private static Optional<TypedTensorFunction> rsqrt(TensorFlowImporter.Parameters params) {
        return OperationMapper.map(params, ScalarFunctions.rsqrt());
    }

    private static Optional<TypedTensorFunction> select(TensorFlowImporter.Parameters params) {
        if (!OperationMapper.checkInputs(params, 3)) {
            return Optional.empty();
        }
        com.yahoo.tensor.Tensor condition = OperationMapper.getConstantTensor(params, params.node().getInput(0));
        List<Optional<TypedTensorFunction>> inputs = params.inputs();
        TypedTensorFunction x = inputs.get(1).get();
        TypedTensorFunction y = inputs.get(2).get();
        if (x.type().rank() != y.type().rank() || !OperationMapper.tensorSize(x.type()).equals(OperationMapper.tensorSize(y.type()))) {
            throw new IllegalArgumentException("'Select': input tensors must have the same shape");
        }
        if (condition.type().rank() == 0) {
            return Optional.of((int)condition.asDouble() == 0 ? y : x);
        }
        if (condition.type().rank() == 1 && OperationMapper.dimensionSize((TensorType.Dimension)condition.type().dimensions().get(0)) == 1L) {
            return Optional.of(((Tensor.Cell)condition.cellIterator().next()).getValue().intValue() == 0 ? y : x);
        }
        Optional<TypedTensorFunction> conditionFunction = OperationMapper.importConstantTensor(params, params.node().getInput(0));
        if (!conditionFunction.isPresent()) {
            return Optional.empty();
        }
        Join xCond = new Join(x.function(), conditionFunction.get().function(), ScalarFunctions.multiply());
        Join yCond = new Join(y.function(), conditionFunction.get().function(), new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double a, double b) {
                return a * (1.0 - b);
            }

            public String toString() {
                return "f(a,b)(a * (1-b))";
            }
        });
        Join outputFunction = new Join((TensorFunction)xCond, (TensorFunction)yCond, ScalarFunctions.add());
        TypedTensorFunction output = new TypedTensorFunction(x.type(), (TensorFunction)outputFunction);
        return Optional.of(output);
    }

    private static Optional<TypedTensorFunction> sigmoid(TensorFlowImporter.Parameters params) {
        return OperationMapper.map(params, ScalarFunctions.sigmoid());
    }

    private static Optional<TypedTensorFunction> squaredDifference(TensorFlowImporter.Parameters params) {
        return OperationMapper.join(params, ScalarFunctions.squareddifference());
    }

    private static Optional<TypedTensorFunction> sub(TensorFlowImporter.Parameters params) {
        return OperationMapper.join(params, ScalarFunctions.subtract());
    }

    private static Optional<TypedTensorFunction> elu(TensorFlowImporter.Parameters params) {
        return OperationMapper.map(params, ScalarFunctions.elu());
    }

    private static Optional<TypedTensorFunction> relu(TensorFlowImporter.Parameters params) {
        return OperationMapper.map(params, ScalarFunctions.relu());
    }

    private static Optional<TypedTensorFunction> selu(TensorFlowImporter.Parameters params) {
        return OperationMapper.map(params, ScalarFunctions.selu());
    }

    private static Optional<TypedTensorFunction> softMax(TensorFlowImporter.Parameters params) {
        if (!OperationMapper.checkInputs(params, 1)) {
            return Optional.empty();
        }
        List<Optional<TypedTensorFunction>> inputs = params.inputs();
        TypedTensorFunction a = inputs.get(0).get();
        String dimension = "d" + (a.type().rank() - 1);
        Softmax softmax = new Softmax(a.function(), dimension);
        TypedTensorFunction output = new TypedTensorFunction(Softmax.outputType((TensorType)a.type(), (String)dimension), (TensorFunction)softmax);
        return Optional.of(output);
    }

    private static Optional<TypedTensorFunction> variable(TensorFlowImporter.Parameters params) {
        return OperationMapper.importConstantTensor(params, params.node().getName());
    }

    private static Optional<TypedTensorFunction> noOp(TensorFlowImporter.Parameters params) {
        return Optional.empty();
    }

    private static Optional<TypedTensorFunction> join(TensorFlowImporter.Parameters params, DoubleBinaryOperator doubleFunction) {
        if (!OperationMapper.checkInputs(params, 2)) {
            return Optional.empty();
        }
        List<Optional<TypedTensorFunction>> inputs = params.inputs();
        TypedTensorFunction a = inputs.get(0).get();
        TypedTensorFunction b = inputs.get(1).get();
        if (a.type().rank() == 0 && b.type().rank() > 0) {
            return Optional.of(new TypedTensorFunction(b.type(), (TensorFunction)new Join(a.function(), b.function(), doubleFunction)));
        }
        if (b.type().rank() == 0 && a.type().rank() > 0) {
            return Optional.of(new TypedTensorFunction(a.type(), (TensorFunction)new Join(a.function(), b.function(), doubleFunction)));
        }
        if (a.type().rank() == b.type().rank()) {
            return Optional.of(new TypedTensorFunction(a.type(), (TensorFunction)new Join(a.function(), b.function(), doubleFunction)));
        }
        if (a.type().rank() > b.type().rank()) {
            TensorFunction renameFunction = OperationMapper.renameForBroadcast(a, b);
            return Optional.of(new TypedTensorFunction(a.type(), (TensorFunction)new Join(a.function(), renameFunction, doubleFunction)));
        }
        TensorFunction renameFunction = OperationMapper.renameForBroadcast(b, a);
        return Optional.of(new TypedTensorFunction(b.type(), (TensorFunction)new Join(renameFunction, b.function(), doubleFunction)));
    }

    private static TensorFunction renameForBroadcast(TypedTensorFunction a, TypedTensorFunction b) {
        ArrayList<String> renameFrom = new ArrayList<String>();
        ArrayList<String> renameTo = new ArrayList<String>();
        int sizeDifference = a.type().rank() - b.type().rank();
        for (int i = 0; i < b.type().rank(); ++i) {
            renameFrom.add(((TensorType.Dimension)b.type().dimensions().get(i)).name());
            renameTo.add("d" + (sizeDifference + i));
        }
        return new Rename(b.function(), renameFrom, renameTo);
    }

    private static Optional<TypedTensorFunction> map(TensorFlowImporter.Parameters params, DoubleUnaryOperator doubleFunction) {
        if (!OperationMapper.checkInputs(params, 1)) {
            return Optional.empty();
        }
        List<Optional<TypedTensorFunction>> inputs = params.inputs();
        TypedTensorFunction a = inputs.get(0).get();
        TensorType resultType = Map.outputType((TensorType)a.type());
        Map function = new Map(a.function(), doubleFunction);
        return Optional.of(new TypedTensorFunction(resultType, (TensorFunction)function));
    }

    private static Optional<TypedTensorFunction> createConstant(TensorFlowImporter.Parameters params, com.yahoo.tensor.Tensor constant) {
        String name = OperationMapper.toVespaName(params.node().getName());
        if (constant.type().rank() == 0 || constant.size() <= 1L) {
            params.result().smallConstant(name, constant);
        } else {
            params.result().largeConstant(name, constant);
        }
        TypedTensorFunction output = new TypedTensorFunction(constant.type(), (TensorFunction)new TensorFunctionNode.TensorFunctionExpressionNode(new ReferenceNode("constant(\"" + name + "\")")));
        return Optional.of(output);
    }

    private static com.yahoo.tensor.Tensor getConstantTensor(TensorFlowImporter.Parameters params, String name) {
        String vespaName = OperationMapper.toVespaName(name);
        if (params.result().smallConstants().containsKey(vespaName)) {
            return params.result().smallConstants().get(vespaName);
        }
        if (params.result().largeConstants().containsKey(vespaName)) {
            return params.result().largeConstants().get(vespaName);
        }
        Session.Runner fetched = params.model().session().runner().fetch(name);
        List importedTensors = fetched.run();
        if (importedTensors.size() != 1) {
            throw new IllegalStateException("Expected 1 tensor from fetching " + name + ", but got " + importedTensors.size());
        }
        return TensorConverter.toVespaTensor((Tensor)importedTensors.get(0));
    }

    private static Optional<TypedTensorFunction> importConstantTensor(TensorFlowImporter.Parameters params, String name) {
        AttrValue shapes = (AttrValue)params.node().getAttrMap().get("_output_shapes");
        if (shapes == null) {
            throw new IllegalArgumentException("'" + name + "' is missing a tensor shape");
        }
        com.yahoo.tensor.Tensor constant = OperationMapper.getConstantTensor(params, name);
        return OperationMapper.createConstant(params, constant);
    }

    private static Optional<TypedTensorFunction> reshape(TensorFunction inputFunction, TensorType inputType, TensorType outputType) {
        if (!OperationMapper.tensorSize(inputType).equals(OperationMapper.tensorSize(outputType))) {
            throw new IllegalArgumentException("New and old shape of tensor must have the same size when reshaping");
        }
        ExpressionNode unrollFrom = OperationMapper.unrollTensorExpression(inputType);
        ExpressionNode unrollTo = OperationMapper.unrollTensorExpression(outputType);
        ComparisonNode transformExpression = new ComparisonNode(unrollFrom, TruthOperator.EQUAL, unrollTo);
        TensorType transformationType = new TensorType.Builder(new TensorType[]{inputType, outputType}).build();
        Generate transformTensor = new Generate(transformationType, (Function)new GeneratorLambdaFunctionNode(transformationType, transformExpression).asLongListToDoubleOperator());
        Reduce outputFunction = new Reduce((TensorFunction)new Join(inputFunction, (TensorFunction)transformTensor, ScalarFunctions.multiply()), Reduce.Aggregator.sum, inputType.dimensions().stream().map(TensorType.Dimension::name).collect(Collectors.toList()));
        TypedTensorFunction output = OperationMapper.checkNamingConvention(outputType, (TensorFunction)outputFunction);
        return Optional.of(output);
    }

    private static ExpressionNode unrollTensorExpression(TensorType type) {
        if (type.rank() == 0) {
            return new ConstantNode(DoubleValue.zero);
        }
        ArrayList<ExpressionNode> children = new ArrayList<ExpressionNode>();
        ArrayList<ArithmeticOperator> operators = new ArrayList<ArithmeticOperator>();
        int size = 1;
        for (int i = type.dimensions().size() - 1; i >= 0; --i) {
            TensorType.Dimension dimension = (TensorType.Dimension)type.dimensions().get(i);
            children.add(0, new ReferenceNode(dimension.name()));
            if (size > 1) {
                operators.add(0, ArithmeticOperator.MULTIPLY);
                children.add(0, new ConstantNode(new DoubleValue(size)));
            }
            size = (int)((long)size * OperationMapper.dimensionSize(dimension));
            if (i <= 0) continue;
            operators.add(0, ArithmeticOperator.PLUS);
        }
        return new ArithmeticNode(children, operators);
    }

    private static boolean shouldKeepDimensions(TensorFlowImporter.Parameters params) {
        AttrValue keepDimsAttr = (AttrValue)params.node().getAttrMap().get("keep_dims");
        return keepDimsAttr != null && keepDimsAttr.getB();
    }

    private static TensorType keepDimensionType(TensorType inputType, List<String> reduceDimensions) {
        TensorType.Builder builder = new TensorType.Builder();
        for (TensorType.Dimension dimension : inputType.dimensions()) {
            String name = dimension.name();
            Long size = OperationMapper.dimensionSize(dimension);
            if (reduceDimensions.contains(name)) {
                size = 1L;
            }
            builder.indexed(name, size.longValue());
        }
        return builder.build();
    }

    private static TypedTensorFunction checkNamingConvention(TensorType type, TensorFunction function) {
        for (int i = 0; i < type.dimensions().size(); ++i) {
            String correct = String.format("d%d", i);
            String current = ((TensorType.Dimension)type.dimensions().get(i)).name();
            if (current.equals(correct)) continue;
            return OperationMapper.fixNamingConvention(type, function);
        }
        return new TypedTensorFunction(type, function);
    }

    private static TypedTensorFunction fixNamingConvention(TensorType type, TensorFunction function) {
        TensorType.Builder correctType = new TensorType.Builder();
        ArrayList<String> from = new ArrayList<String>();
        ArrayList<String> to = new ArrayList<String>();
        for (int i = 0; i < type.dimensions().size(); ++i) {
            String correct = String.format("d%d", i);
            String current = ((TensorType.Dimension)type.dimensions().get(i)).name();
            if (!current.equals(correct)) {
                from.add(current);
                to.add(correct);
            }
            correctType.indexed(correct, OperationMapper.dimensionSize((TensorType.Dimension)type.dimensions().get(i)).longValue());
        }
        if (from.size() > 0) {
            function = new Rename(function, from, to);
            type = correctType.build();
        }
        return new TypedTensorFunction(type, function);
    }

    private static Long tensorSize(TensorType type) {
        Long size = 1L;
        for (TensorType.Dimension dimension : type.dimensions()) {
            size = size * OperationMapper.dimensionSize(dimension);
        }
        return size;
    }

    private static Long dimensionSize(TensorType.Dimension dim) {
        return (Long)dim.size().orElseThrow(() -> new IllegalArgumentException("Dimension has no size"));
    }

    private static boolean checkInputs(TensorFlowImporter.Parameters params, int expected) {
        List<Optional<TypedTensorFunction>> inputs = params.inputs();
        if (!inputs.stream().allMatch(Optional::isPresent)) {
            return false;
        }
        if (inputs.size() != expected) {
            params.signature().importWarning("Expected " + expected + " arguments to " + params.node().getOp() + ", but got " + inputs.size());
            return false;
        }
        return true;
    }

    public static String toVespaName(String name) {
        return name != null ? name.replace('/', '_') : null;
    }

    static enum Operation {
        CONST(x$0 -> OperationMapper.access$2700(x$0)),
        EXPANDDIMS(x$0 -> OperationMapper.access$2600(x$0)),
        IDENTITY(x$0 -> OperationMapper.access$100(x$0)),
        PLACEHOLDER(x$0 -> OperationMapper.access$2500(x$0)),
        PLACEHOLDERWITHDEFAULT(x$0 -> OperationMapper.access$2400(x$0)),
        RESHAPE(x$0 -> OperationMapper.access$2300(x$0)),
        SQUEEZE(x$0 -> OperationMapper.access$2200(x$0)),
        MERGE(x$0 -> OperationMapper.access$2100(x$0)),
        SWITCH(x$0 -> OperationMapper.access$2000(x$0)),
        ADD(x$0 -> OperationMapper.access$700(x$0)),
        ADD_N(x$0 -> OperationMapper.access$700(x$0)),
        ACOS(x$0 -> OperationMapper.access$1900(x$0)),
        DIV(x$0 -> OperationMapper.access$1800(x$0)),
        REALDIV(x$0 -> OperationMapper.access$1800(x$0)),
        FLOOR(x$0 -> OperationMapper.access$1700(x$0)),
        MATMUL(x$0 -> OperationMapper.access$1600(x$0)),
        MAXIMUM(x$0 -> OperationMapper.access$1500(x$0)),
        MEAN(x$0 -> OperationMapper.access$1400(x$0)),
        REDUCEMEAN(x$0 -> OperationMapper.access$1400(x$0)),
        MUL(x$0 -> OperationMapper.access$1300(x$0)),
        MULTIPLY(x$0 -> OperationMapper.access$1300(x$0)),
        RSQRT(x$0 -> OperationMapper.access$1200(x$0)),
        SELECT(x$0 -> OperationMapper.access$1100(x$0)),
        WHERE3(x$0 -> OperationMapper.access$1100(x$0)),
        SIGMOID(x$0 -> OperationMapper.access$1000(x$0)),
        SQUAREDDIFFERENCE(x$0 -> OperationMapper.access$900(x$0)),
        SUB(x$0 -> OperationMapper.access$800(x$0)),
        SUBTRACT(x$0 -> OperationMapper.access$800(x$0)),
        BIASADD(x$0 -> OperationMapper.access$700(x$0)),
        ELU(x$0 -> OperationMapper.access$600(x$0)),
        RELU(x$0 -> OperationMapper.access$500(x$0)),
        SELU(x$0 -> OperationMapper.access$400(x$0)),
        SOFTMAX(x$0 -> OperationMapper.access$300(x$0)),
        VARIABLE(x$0 -> OperationMapper.access$200(x$0)),
        VARIABLEV2(x$0 -> OperationMapper.access$200(x$0)),
        STOPGRADIENT(x$0 -> OperationMapper.access$100(x$0)),
        NOOP(x$0 -> OperationMapper.access$000(x$0));

        private final Function<TensorFlowImporter.Parameters, Optional<TypedTensorFunction>> func;

        private Operation(Function<TensorFlowImporter.Parameters, Optional<TypedTensorFunction>> func) {
            this.func = func;
        }

        Optional<TypedTensorFunction> map(TensorFlowImporter.Parameters params) {
            return this.func.apply(params);
        }
    }
}

