/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.google.common.collect.ImmutableList;
import com.yahoo.searchlib.rankingexpression.evaluation.BooleanValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.BooleanNode;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class SetMembershipNode
extends BooleanNode {
    private final ExpressionNode testValue;
    private final List<ExpressionNode> setValues;

    public SetMembershipNode(ExpressionNode testValue, List<ExpressionNode> setValues) {
        this.testValue = testValue;
        this.setValues = ImmutableList.copyOf(setValues);
    }

    public ExpressionNode getTestValue() {
        return this.testValue;
    }

    public List<ExpressionNode> getSetValues() {
        return this.setValues;
    }

    @Override
    public List<ExpressionNode> children() {
        ArrayList<ExpressionNode> children = new ArrayList<ExpressionNode>();
        children.add(this.testValue);
        children.addAll(this.setValues);
        return children;
    }

    @Override
    public String toString(SerializationContext context, Deque<String> path, CompositeNode parent) {
        StringBuilder b = new StringBuilder(this.testValue.toString(context, path, this));
        b.append(" in [");
        int len = this.setValues.size();
        for (int i = 0; i < len; ++i) {
            b.append(this.setValues.get(i).toString(context, path, this));
            if (i >= len - 1) continue;
            b.append(", ");
        }
        b.append("]");
        return b.toString();
    }

    @Override
    public Value evaluate(Context context) {
        Value value = this.testValue.evaluate(context);
        for (ExpressionNode setValue : this.setValues) {
            if (!setValue.evaluate(context).equals(value)) continue;
            return new BooleanValue(true);
        }
        return new BooleanValue(false);
    }

    @Override
    public SetMembershipNode setChildren(List<ExpressionNode> children) {
        if (children.size() < 1) {
            throw new IllegalArgumentException("A set membership test must have at least 1 child");
        }
        return new SetMembershipNode(children.get(0), children.subList(1, children.size()));
    }
}

