/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.NumericResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.nio.ByteBuffer;

public class IntegerResultNode
extends NumericResultNode {
    public static final int classId = IntegerResultNode.registerClass((int)16491, IntegerResultNode.class);
    private static IntegerResultNode negativeInfinity = new IntegerResultNode(Long.MIN_VALUE);
    private static IntegerResultNode positiveInfinity = new IntegerResultNode(Long.MAX_VALUE);
    private long value;

    public IntegerResultNode() {
    }

    public IntegerResultNode(long value) {
        this.setValue(value);
    }

    public IntegerResultNode setValue(long value) {
        this.value = value;
        return this;
    }

    void andOp(ResultNode b) {
        this.value &= b.getInteger();
    }

    void orOp(ResultNode b) {
        this.value |= b.getInteger();
    }

    void xorOp(ResultNode b) {
        this.value ^= b.getInteger();
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        buf.putLong(null, this.value);
    }

    protected void onDeserialize(Deserializer buf) {
        this.value = buf.getLong(null);
    }

    @Override
    public long getInteger() {
        return this.value;
    }

    @Override
    public double getFloat() {
        return this.value;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public byte[] getRaw() {
        return ByteBuffer.allocate(8).putLong(this.value).array();
    }

    @Override
    public void add(ResultNode rhs) {
        this.value += rhs.getInteger();
    }

    @Override
    public void negate() {
        this.value = -this.value;
    }

    @Override
    public void multiply(ResultNode rhs) {
        this.value *= rhs.getInteger();
    }

    @Override
    public void divide(ResultNode rhs) {
        long val = rhs.getInteger();
        this.value = val == 0L ? 0L : this.value / val;
    }

    @Override
    public void modulo(ResultNode rhs) {
        this.value %= rhs.getInteger();
    }

    @Override
    public void min(ResultNode rhs) {
        long value = rhs.getInteger();
        if (value < this.value) {
            this.value = value;
        }
    }

    @Override
    public void max(ResultNode rhs) {
        long value = rhs.getInteger();
        if (value > this.value) {
            this.value = value;
        }
    }

    @Override
    public Object getNumber() {
        return new Long(this.value);
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        long value = rhs.getInteger();
        return this.value < value ? -1 : (this.value > value ? 1 : 0);
    }

    public int hashCode() {
        return super.hashCode() + (int)this.value;
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("value", (Object)this.value);
    }

    @Override
    public void set(ResultNode rhs) {
        this.value = rhs.getInteger();
    }

    public static IntegerResultNode getNegativeInfinity() {
        return negativeInfinity;
    }

    public static IntegerResultNode getPositiveInfinity() {
        return positiveInfinity;
    }
}

