## expression

Contained in [first-phase](https://docs.vespa.ai/en/reference/applications/schemas.html#firstphase-rank) or [second-phase](https://docs.vespa.ai/en/reference/applications/schemas.html#secondphase-rank) or [global-phase](https://docs.vespa.ai/en/reference/applications/schemas.html#globalphase-rank). Specify a [ranking expression](https://docs.vespa.ai/en/reference/ranking/ranking-expressions.html). The expression can either be written directly or loaded from a file. When writing it directly, the syntax is:

```
expression: [ranking expression]
```

or

```
expression {
    [ranking expression]
    [ranking expression]
    [ranking expression]
}
```

The second format is primarily a convenience feature when using long expressions, enabling them to be split over multiple lines.

Expressions can also be loaded from a separate file. This is useful when dealing with the long expressions generated by e.g. MLR. The syntax is:

```
expression: file:[path-to-expressionfile]
```

The path is relative to the location of the schema definition file. The file itself must end with `.expression`. This suffix is optional in the schema. Therefore `expression: file:mlrranking.expression` and `expression: file:mlrranking` are identical. Both refer to a file called `mlrranking.expression` in the *schemas* directory.  
**Note:** Directories are not allowed in the path.
[Read more](https://docs.vespa.ai/en/reference/applications/schemas.html#expression)
