/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.parser.yqlplus;

import ai.vespa.schemals.parser.yqlplus.InvalidToken;
import ai.vespa.schemals.parser.yqlplus.Node;
import ai.vespa.schemals.parser.yqlplus.TokenSource;
import ai.vespa.schemals.parser.yqlplus.YQLPlusLexer;
import ai.vespa.schemals.parser.yqlplus.ast.ALL;
import ai.vespa.schemals.parser.yqlplus.ast.AND;
import ai.vespa.schemals.parser.yqlplus.ast.AS;
import ai.vespa.schemals.parser.yqlplus.ast.ASC;
import ai.vespa.schemals.parser.yqlplus.ast.AT;
import ai.vespa.schemals.parser.yqlplus.ast.BY;
import ai.vespa.schemals.parser.yqlplus.ast.COLON;
import ai.vespa.schemals.parser.yqlplus.ast.COMMA;
import ai.vespa.schemals.parser.yqlplus.ast.COMMENT;
import ai.vespa.schemals.parser.yqlplus.ast.CONTAINS;
import ai.vespa.schemals.parser.yqlplus.ast.COUNT;
import ai.vespa.schemals.parser.yqlplus.ast.DESC;
import ai.vespa.schemals.parser.yqlplus.ast.DIV;
import ai.vespa.schemals.parser.yqlplus.ast.DOT;
import ai.vespa.schemals.parser.yqlplus.ast.DQ;
import ai.vespa.schemals.parser.yqlplus.ast.EACH;
import ai.vespa.schemals.parser.yqlplus.ast.EQ;
import ai.vespa.schemals.parser.yqlplus.ast.ESC_SEQ;
import ai.vespa.schemals.parser.yqlplus.ast.EXCLAMATION;
import ai.vespa.schemals.parser.yqlplus.ast.EXPONENT;
import ai.vespa.schemals.parser.yqlplus.ast.FALSE;
import ai.vespa.schemals.parser.yqlplus.ast.FLOAT;
import ai.vespa.schemals.parser.yqlplus.ast.FROM;
import ai.vespa.schemals.parser.yqlplus.ast.GT;
import ai.vespa.schemals.parser.yqlplus.ast.GTEQ;
import ai.vespa.schemals.parser.yqlplus.ast.HEX_DIGIT;
import ai.vespa.schemals.parser.yqlplus.ast.IDENTIFIER;
import ai.vespa.schemals.parser.yqlplus.ast.IN;
import ai.vespa.schemals.parser.yqlplus.ast.INT;
import ai.vespa.schemals.parser.yqlplus.ast.IS_NOT_NULL;
import ai.vespa.schemals.parser.yqlplus.ast.IS_NULL;
import ai.vespa.schemals.parser.yqlplus.ast.LBRACE;
import ai.vespa.schemals.parser.yqlplus.ast.LBRACKET;
import ai.vespa.schemals.parser.yqlplus.ast.LETTER;
import ai.vespa.schemals.parser.yqlplus.ast.LIKE;
import ai.vespa.schemals.parser.yqlplus.ast.LIMIT;
import ai.vespa.schemals.parser.yqlplus.ast.LONG_INT;
import ai.vespa.schemals.parser.yqlplus.ast.LPAREN;
import ai.vespa.schemals.parser.yqlplus.ast.LT;
import ai.vespa.schemals.parser.yqlplus.ast.LTEQ;
import ai.vespa.schemals.parser.yqlplus.ast.MATCHES;
import ai.vespa.schemals.parser.yqlplus.ast.MINUS;
import ai.vespa.schemals.parser.yqlplus.ast.MODULO;
import ai.vespa.schemals.parser.yqlplus.ast.NEQ;
import ai.vespa.schemals.parser.yqlplus.ast.NOTLIKE;
import ai.vespa.schemals.parser.yqlplus.ast.NOTMATCHES;
import ai.vespa.schemals.parser.yqlplus.ast.NOT_IN;
import ai.vespa.schemals.parser.yqlplus.ast.NULL;
import ai.vespa.schemals.parser.yqlplus.ast.OFFSET;
import ai.vespa.schemals.parser.yqlplus.ast.OR;
import ai.vespa.schemals.parser.yqlplus.ast.ORDER;
import ai.vespa.schemals.parser.yqlplus.ast.ORDERBY;
import ai.vespa.schemals.parser.yqlplus.ast.OUTPUT;
import ai.vespa.schemals.parser.yqlplus.ast.PIPE;
import ai.vespa.schemals.parser.yqlplus.ast.PLUS;
import ai.vespa.schemals.parser.yqlplus.ast.RBRACE;
import ai.vespa.schemals.parser.yqlplus.ast.RBRACKET;
import ai.vespa.schemals.parser.yqlplus.ast.RPAREN;
import ai.vespa.schemals.parser.yqlplus.ast.SELECT;
import ai.vespa.schemals.parser.yqlplus.ast.SEMI;
import ai.vespa.schemals.parser.yqlplus.ast.SOURCES;
import ai.vespa.schemals.parser.yqlplus.ast.SQ;
import ai.vespa.schemals.parser.yqlplus.ast.STAR;
import ai.vespa.schemals.parser.yqlplus.ast.STRING;
import ai.vespa.schemals.parser.yqlplus.ast.TIMEOUT;
import ai.vespa.schemals.parser.yqlplus.ast.TRUE;
import ai.vespa.schemals.parser.yqlplus.ast.UNICODE_ESC;
import ai.vespa.schemals.parser.yqlplus.ast.WHERE;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Token
implements CharSequence,
Node.TerminalNode {
    private YQLPlusLexer tokenSource;
    private TokenType type = TokenType.DUMMY;
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;
    private Node parent;
    private boolean virtual;
    private boolean skipped;
    private boolean dirty;

    @Override
    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    @Override
    public YQLPlusLexer getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = (YQLPlusLexer)tokenSource;
    }

    public boolean isInvalid() {
        return this.getType().isInvalid();
    }

    @Override
    public TokenType getType() {
        return this.type;
    }

    protected void setType(TokenType type) {
        this.type = type;
    }

    public boolean isVirtual() {
        return this.virtual || this.type == TokenType.EOF;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    void setVirtual(boolean virtual) {
        this.virtual = virtual;
        if (virtual) {
            this.dirty = true;
        }
    }

    void setSkipped(boolean skipped) {
        this.skipped = skipped;
        if (skipped) {
            this.dirty = true;
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public int getBeginOffset() {
        return this.beginOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public final Token getNext() {
        return this.getNextParsedToken();
    }

    public final Token getPrevious() {
        Token result;
        for (result = this.previousCachedToken(); result != null && result.isUnparsed(); result = result.previousCachedToken()) {
        }
        return result;
    }

    private Token getNextParsedToken() {
        Token result;
        for (result = this.nextCachedToken(); result != null && result.isUnparsed(); result = result.nextCachedToken()) {
        }
        return result;
    }

    public Token nextCachedToken() {
        if (this.getType() == TokenType.EOF) {
            return null;
        }
        YQLPlusLexer tokenSource = this.getTokenSource();
        return tokenSource != null ? (Token)tokenSource.nextCachedToken(this.getEndOffset()) : null;
    }

    public Token previousCachedToken() {
        if (this.getTokenSource() == null) {
            return null;
        }
        return (Token)this.getTokenSource().previousCachedToken(this.getBeginOffset());
    }

    Token getPreviousToken() {
        return this.previousCachedToken();
    }

    public Token replaceType(TokenType type) {
        Token result = Token.newToken(type, this.getTokenSource(), this.getBeginOffset(), this.getEndOffset());
        this.getTokenSource().cacheToken(result);
        return result;
    }

    @Override
    public String getSource() {
        if (this.type == TokenType.EOF) {
            return "";
        }
        YQLPlusLexer ts = this.getTokenSource();
        return ts == null ? null : ts.getText(this.getBeginOffset(), this.getEndOffset());
    }

    protected Token() {
    }

    public Token(TokenType type, YQLPlusLexer tokenSource, int beginOffset, int endOffset) {
        this.type = type;
        this.tokenSource = tokenSource;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    @Override
    public boolean isUnparsed() {
        return this.unparsed;
    }

    @Override
    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    public Iterator<Token> precedingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.previousCachedToken() != null;
            }

            @Override
            public Token next() {
                Token previous = this.currentPoint.previousCachedToken();
                if (previous == null) {
                    throw new NoSuchElementException("No previous token!");
                }
                this.currentPoint = previous;
                return this.currentPoint;
            }
        };
    }

    public List<Token> precedingUnparsedTokens() {
        ArrayList<Token> result = new ArrayList<Token>();
        for (Token t = this.previousCachedToken(); t != null && t.isUnparsed(); t = t.previousCachedToken()) {
            result.add(t);
        }
        Collections.reverse(result);
        return result;
    }

    public Iterator<Token> followingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.nextCachedToken() != null;
            }

            @Override
            public Token next() {
                Token next = this.currentPoint.nextCachedToken();
                if (next == null) {
                    throw new NoSuchElementException("No next token!");
                }
                this.currentPoint = next;
                return this.currentPoint;
            }
        };
    }

    public void copyLocationInfo(Token from) {
        this.setTokenSource(from.getTokenSource());
        this.setBeginOffset(from.getBeginOffset());
        this.setEndOffset(from.getEndOffset());
    }

    public void copyLocationInfo(Token start, Token end) {
        this.setTokenSource(start.getTokenSource());
        if (this.tokenSource == null) {
            this.setTokenSource(end.getTokenSource());
        }
        this.setBeginOffset(start.getBeginOffset());
        this.setEndOffset(end.getEndOffset());
    }

    public static Token newToken(TokenType type, YQLPlusLexer tokenSource, int beginOffset, int endOffset) {
        switch (type) {
            case ALL: {
                return new ALL(TokenType.ALL, tokenSource, beginOffset, endOffset);
            }
            case LETTER: {
                return new LETTER(TokenType.LETTER, tokenSource, beginOffset, endOffset);
            }
            case UNICODE_ESC: {
                return new UNICODE_ESC(TokenType.UNICODE_ESC, tokenSource, beginOffset, endOffset);
            }
            case LT: {
                return new LT(TokenType.LT, tokenSource, beginOffset, endOffset);
            }
            case FROM: {
                return new FROM(TokenType.FROM, tokenSource, beginOffset, endOffset);
            }
            case PIPE: {
                return new PIPE(TokenType.PIPE, tokenSource, beginOffset, endOffset);
            }
            case DQ: {
                return new DQ(TokenType.DQ, tokenSource, beginOffset, endOffset);
            }
            case DESC: {
                return new DESC(TokenType.DESC, tokenSource, beginOffset, endOffset);
            }
            case MINUS: {
                return new MINUS(TokenType.MINUS, tokenSource, beginOffset, endOffset);
            }
            case LTEQ: {
                return new LTEQ(TokenType.LTEQ, tokenSource, beginOffset, endOffset);
            }
            case LONG_INT: {
                return new LONG_INT(TokenType.LONG_INT, tokenSource, beginOffset, endOffset);
            }
            case EACH: {
                return new EACH(TokenType.EACH, tokenSource, beginOffset, endOffset);
            }
            case NULL: {
                return new NULL(TokenType.NULL, tokenSource, beginOffset, endOffset);
            }
            case OUTPUT: {
                return new OUTPUT(TokenType.OUTPUT, tokenSource, beginOffset, endOffset);
            }
            case IN: {
                return new IN(TokenType.IN, tokenSource, beginOffset, endOffset);
            }
            case LPAREN: {
                return new LPAREN(TokenType.LPAREN, tokenSource, beginOffset, endOffset);
            }
            case MODULO: {
                return new MODULO(TokenType.MODULO, tokenSource, beginOffset, endOffset);
            }
            case DOT: {
                return new DOT(TokenType.DOT, tokenSource, beginOffset, endOffset);
            }
            case TRUE: {
                return new TRUE(TokenType.TRUE, tokenSource, beginOffset, endOffset);
            }
            case RPAREN: {
                return new RPAREN(TokenType.RPAREN, tokenSource, beginOffset, endOffset);
            }
            case NOT_IN: {
                return new NOT_IN(TokenType.NOT_IN, tokenSource, beginOffset, endOffset);
            }
            case WHERE: {
                return new WHERE(TokenType.WHERE, tokenSource, beginOffset, endOffset);
            }
            case EQ: {
                return new EQ(TokenType.EQ, tokenSource, beginOffset, endOffset);
            }
            case AS: {
                return new AS(TokenType.AS, tokenSource, beginOffset, endOffset);
            }
            case AT: {
                return new AT(TokenType.AT, tokenSource, beginOffset, endOffset);
            }
            case RBRACE: {
                return new RBRACE(TokenType.RBRACE, tokenSource, beginOffset, endOffset);
            }
            case LIKE: {
                return new LIKE(TokenType.LIKE, tokenSource, beginOffset, endOffset);
            }
            case AND: {
                return new AND(TokenType.AND, tokenSource, beginOffset, endOffset);
            }
            case COUNT: {
                return new COUNT(TokenType.COUNT, tokenSource, beginOffset, endOffset);
            }
            case TIMEOUT: {
                return new TIMEOUT(TokenType.TIMEOUT, tokenSource, beginOffset, endOffset);
            }
            case LBRACE: {
                return new LBRACE(TokenType.LBRACE, tokenSource, beginOffset, endOffset);
            }
            case PLUS: {
                return new PLUS(TokenType.PLUS, tokenSource, beginOffset, endOffset);
            }
            case IS_NOT_NULL: {
                return new IS_NOT_NULL(TokenType.IS_NOT_NULL, tokenSource, beginOffset, endOffset);
            }
            case FLOAT: {
                return new FLOAT(TokenType.FLOAT, tokenSource, beginOffset, endOffset);
            }
            case SEMI: {
                return new SEMI(TokenType.SEMI, tokenSource, beginOffset, endOffset);
            }
            case LIMIT: {
                return new LIMIT(TokenType.LIMIT, tokenSource, beginOffset, endOffset);
            }
            case NOTMATCHES: {
                return new NOTMATCHES(TokenType.NOTMATCHES, tokenSource, beginOffset, endOffset);
            }
            case CONTAINS: {
                return new CONTAINS(TokenType.CONTAINS, tokenSource, beginOffset, endOffset);
            }
            case INT: {
                return new INT(TokenType.INT, tokenSource, beginOffset, endOffset);
            }
            case COMMENT: {
                return new COMMENT(TokenType.COMMENT, tokenSource, beginOffset, endOffset);
            }
            case SOURCES: {
                return new SOURCES(TokenType.SOURCES, tokenSource, beginOffset, endOffset);
            }
            case ORDER: {
                return new ORDER(TokenType.ORDER, tokenSource, beginOffset, endOffset);
            }
            case ASC: {
                return new ASC(TokenType.ASC, tokenSource, beginOffset, endOffset);
            }
            case IS_NULL: {
                return new IS_NULL(TokenType.IS_NULL, tokenSource, beginOffset, endOffset);
            }
            case BY: {
                return new BY(TokenType.BY, tokenSource, beginOffset, endOffset);
            }
            case HEX_DIGIT: {
                return new HEX_DIGIT(TokenType.HEX_DIGIT, tokenSource, beginOffset, endOffset);
            }
            case OFFSET: {
                return new OFFSET(TokenType.OFFSET, tokenSource, beginOffset, endOffset);
            }
            case ESC_SEQ: {
                return new ESC_SEQ(TokenType.ESC_SEQ, tokenSource, beginOffset, endOffset);
            }
            case IDENTIFIER: {
                return new IDENTIFIER(TokenType.IDENTIFIER, tokenSource, beginOffset, endOffset);
            }
            case ORDERBY: {
                return new ORDERBY(TokenType.ORDERBY, tokenSource, beginOffset, endOffset);
            }
            case SQ: {
                return new SQ(TokenType.SQ, tokenSource, beginOffset, endOffset);
            }
            case COMMA: {
                return new COMMA(TokenType.COMMA, tokenSource, beginOffset, endOffset);
            }
            case OR: {
                return new OR(TokenType.OR, tokenSource, beginOffset, endOffset);
            }
            case LBRACKET: {
                return new LBRACKET(TokenType.LBRACKET, tokenSource, beginOffset, endOffset);
            }
            case RBRACKET: {
                return new RBRACKET(TokenType.RBRACKET, tokenSource, beginOffset, endOffset);
            }
            case COLON: {
                return new COLON(TokenType.COLON, tokenSource, beginOffset, endOffset);
            }
            case GT: {
                return new GT(TokenType.GT, tokenSource, beginOffset, endOffset);
            }
            case SELECT: {
                return new SELECT(TokenType.SELECT, tokenSource, beginOffset, endOffset);
            }
            case DIV: {
                return new DIV(TokenType.DIV, tokenSource, beginOffset, endOffset);
            }
            case NOTLIKE: {
                return new NOTLIKE(TokenType.NOTLIKE, tokenSource, beginOffset, endOffset);
            }
            case STAR: {
                return new STAR(TokenType.STAR, tokenSource, beginOffset, endOffset);
            }
            case EXCLAMATION: {
                return new EXCLAMATION(TokenType.EXCLAMATION, tokenSource, beginOffset, endOffset);
            }
            case GTEQ: {
                return new GTEQ(TokenType.GTEQ, tokenSource, beginOffset, endOffset);
            }
            case MATCHES: {
                return new MATCHES(TokenType.MATCHES, tokenSource, beginOffset, endOffset);
            }
            case EXPONENT: {
                return new EXPONENT(TokenType.EXPONENT, tokenSource, beginOffset, endOffset);
            }
            case STRING: {
                return new STRING(TokenType.STRING, tokenSource, beginOffset, endOffset);
            }
            case FALSE: {
                return new FALSE(TokenType.FALSE, tokenSource, beginOffset, endOffset);
            }
            case NEQ: {
                return new NEQ(TokenType.NEQ, tokenSource, beginOffset, endOffset);
            }
            case INVALID: {
                return new InvalidToken(tokenSource, beginOffset, endOffset);
            }
        }
        return new Token(type, tokenSource, beginOffset, endOffset);
    }

    @Override
    public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public int length() {
        return this.endOffset - this.beginOffset;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.getTokenSource().subSequence(this.beginOffset + start, this.beginOffset + end);
    }

    @Override
    public char charAt(int offset) {
        return this.getTokenSource().charAt(this.beginOffset + offset);
    }

    @Override
    @Deprecated
    public String getImage() {
        return this.getSource();
    }

    @Override
    public String toString() {
        return this.getSource();
    }

    public static enum TokenType implements Node.NodeType
    {
        EOF,
        _TOKEN_1,
        _TOKEN_2,
        _TOKEN_3,
        _TOKEN_4,
        SELECT,
        LIMIT,
        OFFSET,
        WHERE,
        BY,
        ORDER,
        DESC,
        ASC,
        FROM,
        SOURCES,
        AS,
        COMMA,
        OUTPUT,
        COUNT,
        TRUE,
        FALSE,
        LPAREN,
        RPAREN,
        LBRACKET,
        RBRACKET,
        LBRACE,
        RBRACE,
        COLON,
        PIPE,
        AND,
        OR,
        NOT_IN,
        IN,
        LT,
        GT,
        LTEQ,
        GTEQ,
        NEQ,
        STAR,
        EQ,
        LIKE,
        CONTAINS,
        MATCHES,
        PLUS,
        MINUS,
        DIV,
        MODULO,
        EXCLAMATION,
        NULL,
        DOT,
        AT,
        SQ,
        DQ,
        SEMI,
        TIMEOUT,
        ALL,
        EACH,
        ORDERBY,
        NOTLIKE,
        NOTMATCHES,
        IS_NULL,
        IS_NOT_NULL,
        IDENTIFIER,
        LONG_INT,
        INT,
        FLOAT,
        EXPONENT,
        LETTER,
        HEX_DIGIT,
        UNICODE_ESC,
        ESC_SEQ,
        STRING,
        COMMENT,
        DUMMY,
        INVALID;


        @Override
        public boolean isUndefined() {
            return this == DUMMY;
        }

        @Override
        public boolean isInvalid() {
            return this == INVALID;
        }

        @Override
        public boolean isEOF() {
            return this == EOF;
        }
    }
}

