/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument;

import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.Argument;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.ArgumentUtils;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import com.yahoo.tensor.TensorType;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class TensorTypeArgument
implements Argument {
    private String displayStr = "type";
    private String errorMessage = "";

    public TensorTypeArgument() {
    }

    public TensorTypeArgument(String displayStr) {
        this.displayStr = displayStr;
    }

    @Override
    public boolean validateArgument(RankNode node) {
        String typeString = node.getSchemaNode().getText().trim();
        try {
            TensorType.Value.fromId((String)typeString);
            return true;
        }
        catch (IllegalArgumentException ex) {
            this.errorMessage = ex.getMessage();
            return false;
        }
    }

    @Override
    public int getStrictness() {
        return 2;
    }

    @Override
    public String displayString() {
        return this.displayStr;
    }

    @Override
    public Optional<Diagnostic> parseArgument(ParseContext context, RankNode node) {
        Optional<Diagnostic> err = Optional.empty();
        if (!this.validateArgument(node)) {
            err = Optional.of(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage(this.errorMessage).setSeverity(DiagnosticSeverity.Error).setCode(SchemaDiagnostic.DiagnosticCode.INVALID_TYPE).build());
        }
        ArgumentUtils.modifyNodeSymbol(context, node, err.isPresent() ? null : Symbol.SymbolType.TENSOR_CELL_VALUE_TYPE, Symbol.SymbolStatus.OPAQUE);
        return err;
    }
}

