/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument;

import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.Argument;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.ArgumentUtils;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;

public class KeywordArgument
implements Argument {
    private String argument;
    private String displayStr;

    public KeywordArgument(String argument2, String displayStr) {
        this.argument = argument2;
        this.displayStr = displayStr;
    }

    public KeywordArgument(String argument2) {
        this(argument2, argument2);
    }

    @Override
    public String displayString() {
        return this.displayStr;
    }

    public String getArgument() {
        return this.argument;
    }

    @Override
    public int getStrictness() {
        return 8;
    }

    @Override
    public boolean validateArgument(RankNode node) {
        return node.getSchemaNode().getText().equals(this.argument);
    }

    @Override
    public Optional<Diagnostic> parseArgument(ParseContext context, RankNode node) {
        if (!this.validateArgument(node)) {
            return Optional.empty();
        }
        ArgumentUtils.modifyNodeSymbol(context, node, Symbol.SymbolType.DIMENSION, Symbol.SymbolStatus.BUILTIN_REFERENCE);
        return Optional.empty();
    }
}

