/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers.RankExpression;

import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.rankingexpression.ast.identifierStr;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.FunctionSignature;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.SpecificFunction;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.Argument;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class GenericFunction {
    private String name;
    List<FunctionSignature> signatures;
    Set<String> properties;

    public GenericFunction(String name, List<FunctionSignature> signatures) {
        this.name = name;
        this.signatures = signatures;
        this.properties = new HashSet<String>();
        for (FunctionSignature signature : signatures) {
            Set<String> addProps = signature.getProperties();
            if (addProps.size() == 0 && this.properties.size() > 0) {
                this.properties.add("");
                continue;
            }
            this.properties.addAll(addProps);
        }
    }

    public GenericFunction(String name, final FunctionSignature signature) {
        this(name, (List<FunctionSignature>)new ArrayList<FunctionSignature>(){
            {
                this.add(signature);
            }
        });
    }

    public GenericFunction(String name, Argument argument2, Set<String> properties) {
        this(name, new FunctionSignature(argument2, properties));
    }

    public GenericFunction(String name, List<Argument> arguments2, Set<String> proerties) {
        this(name, new FunctionSignature(arguments2, proerties));
    }

    public GenericFunction(String name) {
        this(name, new FunctionSignature());
    }

    public List<FunctionSignature> getSignatures() {
        return List.copyOf(this.signatures);
    }

    public String getName() {
        return this.name;
    }

    public List<Diagnostic> handleArgumentList(ParseContext context, RankNode node, boolean ignoreProperty) {
        String availableProps;
        Optional<FunctionSignature> signature;
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        Optional<Object> property = ignoreProperty ? Optional.empty() : node.getProperty();
        Optional<String> propertyString = Optional.empty();
        if (property.isPresent()) {
            propertyString = Optional.of(((SchemaNode)property.get()).getText());
        }
        if ((signature = this.findFunctionSignature(node.getChildren(), propertyString)).isEmpty()) {
            List signatureStrings = this.signatures.stream().map(func -> this.name + func.toString()).collect(Collectors.toList());
            String availableSignatures = String.join((CharSequence)"\n", signatureStrings);
            String message = "No function matched the given signature. Available signatures are:\n" + availableSignatures;
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage(message).setSeverity(DiagnosticSeverity.Error).build());
            return diagnostics;
        }
        diagnostics.addAll(signature.get().handleArgumentList(context, node.getChildren()));
        Set<String> signatureProps = signature.get().getProperties();
        if (property.isEmpty() && (signatureProps.contains("") || signatureProps.size() == 0)) {
            node.setFunctionSignature(new SpecificFunction(this, signature.get()));
            return diagnostics;
        }
        if (signature.get().anyPropertyAllowed()) {
            if (property.isEmpty()) {
                node.setFunctionSignature(new SpecificFunction(this, signature.get()));
            } else {
                node.setFunctionSignature(new SpecificFunction(this, signature.get(), Optional.of(((SchemaNode)property.get()).getText())));
            }
            return diagnostics;
        }
        String string = availableProps = signatureProps.size() == 0 ? "No one" : String.join((CharSequence)", ", signatureProps);
        if (!property.isPresent()) {
            String message = "The function '" + node.getSchemaNode().getText() + "' must be used with a property. Available properties are: " + availableProps;
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage(message).setSeverity(DiagnosticSeverity.Error).build());
            return diagnostics;
        }
        if (!this.properties.contains(((SchemaNode)property.get()).getText())) {
            String message = "Invalid property '" + ((SchemaNode)property.get()).getText() + "'. Available properties are: " + availableProps;
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(((SchemaNode)property.get()).getRange()).setMessage(message).setSeverity(DiagnosticSeverity.Error).build());
            return diagnostics;
        }
        if (!signature.get().getProperties().contains(((SchemaNode)property.get()).getText())) {
            String message = "This property is not available with with this signature. Available properties are: " + availableProps;
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(((SchemaNode)property.get()).getRange()).setMessage(message).setSeverity(DiagnosticSeverity.Warning).build());
        }
        Node symbolNode = (Node)property.get();
        while (!symbolNode.isASTInstance(identifierStr.class) && symbolNode.size() > 0) {
            symbolNode = symbolNode.get(0);
        }
        if (symbolNode.isASTInstance(identifierStr.class)) {
            symbolNode.setSymbol(Symbol.SymbolType.PROPERTY, context.fileURI()).setStatus(Symbol.SymbolStatus.BUILTIN_REFERENCE);
        }
        node.setFunctionSignature(new SpecificFunction(this, signature.get(), propertyString));
        return diagnostics;
    }

    private static boolean propertyInSet(Optional<String> string, Set<String> propertySet) {
        if (string.isEmpty() && (propertySet.size() == 0 || propertySet.contains(""))) {
            return true;
        }
        if (string.isEmpty()) {
            return false;
        }
        return propertySet.contains(string.get());
    }

    private Optional<FunctionSignature> findFunctionSignature(List<RankNode> arguments2, Optional<String> property) {
        ArrayList<FunctionSignature> bestMatches = new ArrayList();
        int maxScore = 0;
        for (final FunctionSignature signature : this.signatures) {
            int score = signature.matchScore(arguments2);
            if (score == maxScore) {
                bestMatches.add(signature);
                continue;
            }
            if (score <= maxScore) continue;
            maxScore = score;
            bestMatches = new ArrayList<FunctionSignature>(){
                {
                    this.add(signature);
                }
            };
        }
        if (bestMatches.size() == 1) {
            return Optional.of((FunctionSignature)bestMatches.get(0));
        }
        ArrayList possibleSignatures = new ArrayList(bestMatches);
        for (int i = possibleSignatures.size() - 1; i >= 0; --i) {
            if (GenericFunction.propertyInSet(property, ((FunctionSignature)possibleSignatures.get(i)).getProperties())) continue;
            possibleSignatures.remove(i);
        }
        if (possibleSignatures.size() == 1) {
            return Optional.of((FunctionSignature)possibleSignatures.get(0));
        }
        return Optional.empty();
    }
}

