/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.documentation;

import ai.vespa.schemals.common.FileUtils;
import ai.vespa.schemals.documentation.RankFeatureDocumentationFetcher;
import ai.vespa.schemals.documentation.SchemaDocumentationFetcher;
import ai.vespa.schemals.documentation.ServicesDocumentationFetcher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FetchDocumentation {
    private static final String SCHEMA_URL = "en/reference/schema-reference.html";
    private static final String RANK_FEATURE_URL = "en/reference/rank-features.html";
    private static final ServicesLocation[] SERVICES_PATHS = new ServicesLocation[]{new ServicesLocation("en/reference/services.html", ""), new ServicesLocation("en/reference/services-admin.html", "admin"), new ServicesLocation("en/reference/services-container.html", "container"), new ServicesLocation("en/reference/services-content.html", "content"), new ServicesLocation("en/reference/services-docproc.html", "container/document-processing"), new ServicesLocation("en/reference/services-http.html", "container/http"), new ServicesLocation("en/reference/services-processing.html", "container/processing"), new ServicesLocation("en/reference/services-search.html", "container/search")};
    private static final Map<String, List<String>> REPLACE_FILENAME_MAP = new HashMap<String, List<String>>(){
        {
            this.put("FUNCTION (INLINE)? [NAME]", List.of("FUNCTION"));
            this.put("IMPORT FIELD", List.of("IMPORT"));
        }
    };

    public static void fetchSchemaDocs(Path targetPath) throws IOException {
        Files.createDirectories(targetPath, new FileAttribute[0]);
        Files.createDirectories(targetPath.resolve("schema"), new FileAttribute[0]);
        Files.createDirectories(targetPath.resolve("rankExpression"), new FileAttribute[0]);
        Path writePath = targetPath.resolve("schema");
        Map<String, String> schemaMarkdownContent = new SchemaDocumentationFetcher(SCHEMA_URL).getMarkdownContent();
        for (Map.Entry<String, String> entry : schemaMarkdownContent.entrySet()) {
            String tokenName = FetchDocumentation.convertToToken(entry.getKey());
            String content = entry.getValue();
            List<String> fileNamesToWrite = REPLACE_FILENAME_MAP.getOrDefault(tokenName, List.of(tokenName));
            for (String fileName : fileNamesToWrite) {
                fileName = FileUtils.sanitizeFileName(fileName);
                FetchDocumentation.writeMarkdown(writePath.resolve(fileName + ".md"), content);
            }
        }
        Map<String, String> rankFeatureMarkdownContent = new RankFeatureDocumentationFetcher(RANK_FEATURE_URL).getMarkdownContent();
        writePath = targetPath.resolve("rankExpression");
        for (Map.Entry<String, String> entry : rankFeatureMarkdownContent.entrySet()) {
            String fileName = FileUtils.sanitizeFileName(entry.getKey());
            FetchDocumentation.writeMarkdown(writePath.resolve(fileName + ".md"), entry.getValue());
        }
    }

    public static void fetchServicesDocs(Path targetPath) throws IOException {
        Files.createDirectories(targetPath, new FileAttribute[0]);
        Files.createDirectories(targetPath.resolve("services"), new FileAttribute[0]);
        targetPath = targetPath.resolve("services");
        for (ServicesLocation locationEntry : SERVICES_PATHS) {
            Map<String, String> markdownContent = new ServicesDocumentationFetcher(locationEntry.relativeUrl(), locationEntry.relativeSavePath()).getMarkdownContent();
            Path writePath = targetPath.resolve(locationEntry.relativeSavePath());
            Files.createDirectories(writePath, new FileAttribute[0]);
            for (Map.Entry<String, String> entry : markdownContent.entrySet()) {
                if (entry.getKey().contains("/")) continue;
                String fileName = entry.getKey().toLowerCase();
                fileName = FileUtils.sanitizeFileName(fileName);
                FetchDocumentation.writeMarkdown(writePath.resolve(fileName + ".md"), entry.getValue());
            }
        }
    }

    private static void writeMarkdown(Path writePath, String markdown) throws IOException {
        Files.write(writePath, markdown.getBytes(), StandardOpenOption.CREATE);
    }

    private static String convertToToken(String h2Id) {
        return h2Id.toUpperCase().replaceAll("-", "_");
    }

    public static void main(String[] args2) {
        if (args2.length < 1) {
            System.err.println("FetchDocumentation requires one argument: <path-to-write-docs>");
            System.exit(1);
        }
        Path targetPath = Paths.get(args2[0], new String[0]);
        try {
            System.out.println("Fetching docs to " + args2[0]);
            FetchDocumentation.fetchSchemaDocs(targetPath);
            FetchDocumentation.fetchServicesDocs(targetPath);
        }
        catch (IOException ex) {
            System.err.println("FetchDocumentation failed to download documentation: " + ex.getMessage());
            System.exit(1);
        }
    }

    private record ServicesLocation(String relativeUrl, String relativeSavePath) {
    }
}

