/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers.RankExpression;

import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.Argument;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.Diagnostic;

public class FunctionSignature {
    private List<Argument> argumentList;
    private Set<String> properties;
    private boolean expandable = false;
    private boolean anyPropertyAllowed = false;

    public FunctionSignature(List<Argument> arguments2, Set<String> properties, boolean expandable) {
        this.argumentList = arguments2;
        this.properties = properties;
        this.expandable = expandable;
        if (expandable && arguments2.size() <= 0) {
            throw new IllegalArgumentException("An expandable function takes at least one argument");
        }
    }

    public FunctionSignature(List<Argument> argument2, Set<String> properties) {
        this(argument2, properties, false);
    }

    public FunctionSignature(List<Argument> arguments2, boolean expandable) {
        this(arguments2, new HashSet<String>(), expandable);
    }

    public FunctionSignature(List<Argument> arguments2) {
        this(arguments2, new HashSet<String>());
    }

    public FunctionSignature(final Argument argument2, Set<String> properties) {
        this((List<Argument>)new ArrayList<Argument>(){
            {
                this.add(argument2);
            }
        }, properties);
    }

    public FunctionSignature(Argument argument2, final String property) {
        this(argument2, (Set<String>)new HashSet<String>(){
            {
                this.add(property);
            }
        });
    }

    public FunctionSignature(final Argument argument2, boolean expandable) {
        this((List<Argument>)new ArrayList<Argument>(){
            {
                this.add(argument2);
            }
        }, new HashSet<String>(), expandable);
    }

    public FunctionSignature(final Argument argument2) {
        this((List<Argument>)new ArrayList<Argument>(){
            {
                this.add(argument2);
            }
        });
    }

    public FunctionSignature() {
        this(new ArrayList<Argument>());
    }

    public FunctionSignature withAnyProperty() {
        this.anyPropertyAllowed = true;
        return this;
    }

    public boolean anyPropertyAllowed() {
        return this.anyPropertyAllowed;
    }

    int matchScore(List<RankNode> arguments2) {
        if (!this.expandable && arguments2.size() != this.argumentList.size()) {
            return -1;
        }
        if (this.argumentList.size() == 0) {
            return 1;
        }
        int score = 0;
        for (int i = 0; i < arguments2.size(); ++i) {
            int j = Math.min(i, this.argumentList.size() - 1);
            boolean valid = this.argumentList.get(j).validateArgument(arguments2.get(i));
            if (!valid) continue;
            score += this.argumentList.get(j).getStrictness();
        }
        return score;
    }

    public List<Argument> getArgumentList() {
        return List.copyOf(this.argumentList);
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    List<Diagnostic> handleArgumentList(ParseContext context, List<RankNode> arguments2) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (int i = 0; i < arguments2.size(); ++i) {
            int j = Math.min(i, this.argumentList.size() - 1);
            Optional<Diagnostic> diagnostic = this.argumentList.get(j).parseArgument(context, arguments2.get(i));
            if (!diagnostic.isPresent()) continue;
            diagnostics.add(diagnostic.get());
        }
        return diagnostics;
    }

    public String toString() {
        List argumentListStrings = this.argumentList.stream().map(arg -> arg.displayString()).collect(Collectors.toList());
        Object arguments2 = String.join((CharSequence)",", argumentListStrings);
        if (this.expandable) {
            arguments2 = (String)arguments2 + ",...";
        }
        return "(" + (String)arguments2 + ")";
    }
}

