/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.common.editbuilder;

import ai.vespa.schemals.common.FileUtils;
import ai.vespa.schemals.common.editbuilder.TextDocumentEditBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class WorkspaceEditBuilder {
    ArrayList<Either<TextDocumentEditBuilder, ResourceOperation>> edits;
    Map<String, TextDocumentEditBuilder> textDocumentBuilders = new HashMap<String, TextDocumentEditBuilder>();

    public WorkspaceEditBuilder() {
        this.edits = new ArrayList();
    }

    public WorkspaceEditBuilder addTextEdit(String fileURI, TextEdit edit) {
        return this.addTextEdit(new VersionedTextDocumentIdentifier(fileURI, null), edit);
    }

    public WorkspaceEditBuilder addTextEdit(VersionedTextDocumentIdentifier identifier, TextEdit edit) {
        String fileURI = FileUtils.decodeURL(identifier.getUri());
        if (!this.textDocumentBuilders.containsKey(fileURI)) {
            this.registerVersionedDocumentIdentifier(identifier);
        }
        this.textDocumentBuilders.get(fileURI).addEdit(edit);
        return this;
    }

    public WorkspaceEditBuilder addTextEdits(VersionedTextDocumentIdentifier identifier, Iterable<TextEdit> edits) {
        String fileURI = FileUtils.decodeURL(identifier.getUri());
        if (!this.textDocumentBuilders.containsKey(fileURI)) {
            this.registerVersionedDocumentIdentifier(identifier);
        }
        TextDocumentEditBuilder builder = this.textDocumentBuilders.get(fileURI);
        edits.forEach(edit -> builder.addEdit((TextEdit)edit));
        return this;
    }

    public WorkspaceEditBuilder addResourceOperation(ResourceOperation resourceOperation) {
        this.edits.add((Either<TextDocumentEditBuilder, ResourceOperation>)Either.forRight((Object)resourceOperation));
        return this;
    }

    public WorkspaceEditBuilder registerVersionedDocumentIdentifier(VersionedTextDocumentIdentifier identifier) {
        TextDocumentEditBuilder builder = new TextDocumentEditBuilder().setVersionedTextDocumentIdentifier(identifier);
        this.textDocumentBuilders.put(FileUtils.decodeURL(identifier.getUri()), builder);
        this.edits.add((Either<TextDocumentEditBuilder, ResourceOperation>)Either.forLeft((Object)builder));
        return this;
    }

    public WorkspaceEdit build() {
        ArrayList<Either> result = new ArrayList<Either>();
        for (Either<TextDocumentEditBuilder, ResourceOperation> editEntry : this.edits) {
            if (editEntry.isLeft()) {
                result.add(Either.forLeft((Object)((TextDocumentEditBuilder)editEntry.getLeft()).build()));
                continue;
            }
            result.add(Either.forRight((Object)((ResourceOperation)editEntry.getRight())));
        }
        return new WorkspaceEdit(result);
    }
}

