/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.parser.schema;

import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.parser.ParseException;
import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.parser.TokenSource;
import ai.vespa.schemals.schemadocument.parser.Identifier;
import ai.vespa.schemals.schemadocument.parser.IdentifyDirtyNodes;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.List;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;

public class IdentifyDirtySchemaNodes
extends Identifier<SchemaNode> {
    private IdentifyDirtyNodes<SchemaNode> pureDirtyNodeIdentifier;

    public IdentifyDirtySchemaNodes(ParseContext context) {
        super(context);
        this.pureDirtyNodeIdentifier = new IdentifyDirtyNodes(context);
    }

    private String getParseExceptionMessage(ParseException exception) {
        Throwable cause = exception.getCause();
        if (cause == null) {
            return exception.getMessage();
        }
        return cause.getMessage();
    }

    @Override
    public void identify(SchemaNode node, List<Diagnostic> diagnostics) {
        IllegalArgumentException illegalArgumentException;
        if (!(node.getOriginalSchemaNode() instanceof Token)) {
            this.pureDirtyNodeIdentifier.identify(node, diagnostics);
            return;
        }
        Token nodeAsToken = (Token)node.getOriginalSchemaNode();
        Token.ParseExceptionSource parseException = nodeAsToken.getParseExceptionSource();
        if (parseException != null) {
            TokenSource tokenSource = node.getTokenSource();
            Range range = CSTUtils.getRangeFromOffsets(tokenSource, parseException.beginOffset, parseException.endOffset);
            String message = this.getParseExceptionMessage(parseException.parseException);
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(range).setMessage(message).setSeverity(DiagnosticSeverity.Error).build());
        }
        if ((illegalArgumentException = nodeAsToken.getIllegalArgumentException()) != null) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage(illegalArgumentException.getMessage()).setSeverity(DiagnosticSeverity.Error).build());
        }
        if (parseException == null && illegalArgumentException == null) {
            this.pureDirtyNodeIdentifier.identify(node, diagnostics);
        }
    }
}

