/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.parser.schema;

import ai.vespa.schemals.common.FileUtils;
import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.SchemaIndex;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.ast.AS;
import ai.vespa.schemals.parser.ast.RootRankProfile;
import ai.vespa.schemals.parser.ast.dataType;
import ai.vespa.schemals.parser.ast.fieldElm;
import ai.vespa.schemals.parser.ast.fieldOutsideDoc;
import ai.vespa.schemals.parser.ast.functionElm;
import ai.vespa.schemals.parser.ast.identifierWithDashStr;
import ai.vespa.schemals.parser.ast.importField;
import ai.vespa.schemals.parser.ast.mapDataType;
import ai.vespa.schemals.parser.ast.namedDocument;
import ai.vespa.schemals.parser.ast.onnxModelOutput;
import ai.vespa.schemals.parser.ast.rootSchema;
import ai.vespa.schemals.parser.ast.structFieldDefinition;
import ai.vespa.schemals.parser.ast.tensorTypeElm;
import ai.vespa.schemals.parser.rankingexpression.ast.LCURLY;
import ai.vespa.schemals.parser.rankingexpression.ast.identifierStr;
import ai.vespa.schemals.parser.rankingexpression.ast.lambdaFunction;
import ai.vespa.schemals.parser.rankingexpression.ast.tensorType;
import ai.vespa.schemals.parser.rankingexpression.ast.tensorTypeDimension;
import ai.vespa.schemals.schemadocument.parser.Identifier;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import com.yahoo.schema.parser.ParsedType;
import com.yahoo.schema.processing.ReservedFunctionNames;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.TensorTypeParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;

public class IdentifySymbolDefinition
extends Identifier<SchemaNode> {
    private static final Set<String> reservedFunctionNames = ReservedFunctionNames.getReservedNames();

    public IdentifySymbolDefinition(ParseContext context) {
        super(context);
    }

    public ArrayList<Diagnostic> identify(SchemaNode node) {
        ArrayList<Diagnostic> ret = new ArrayList<Diagnostic>();
        if (node.isASTInstance(dataType.class)) {
            this.handleDataTypeDefinition(node, ret);
            return ret;
        }
        if (node.getLanguageType() == Node.LanguageType.RANK_EXPRESSION) {
            return this.identifyDefinitionInRankExpression(node);
        }
        boolean isIdentifier = node.isASTInstance(ai.vespa.schemals.parser.ast.identifierStr.class);
        boolean isIdentifierWithDash = node.isASTInstance(identifierWithDashStr.class);
        if (!isIdentifier && !isIdentifierWithDash) {
            return ret;
        }
        Node parent = node.getParent();
        if (parent == null) {
            return ret;
        }
        if (this.handleSpecialCases(node.getSchemaNode(), parent.getSchemaNode(), ret)) {
            return ret;
        }
        HashMap<Class<?>, Symbol.SymbolType> searchMap = isIdentifier ? SchemaIndex.IDENTIFIER_TYPE_MAP : SchemaIndex.IDENTIFIER_WITH_DASH_TYPE_MAP;
        Symbol.SymbolType symbolType = (Symbol.SymbolType)((Object)searchMap.get(parent.getASTClass()));
        if (symbolType == null) {
            return ret;
        }
        if (parent.isASTInstance(namedDocument.class) || parent.isASTInstance(rootSchema.class)) {
            node.setSymbol(symbolType, this.context.fileURI());
            node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
            this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
            return ret;
        }
        Optional<Symbol> scope = CSTUtils.findScope(node);
        if (scope.isEmpty()) {
            if (symbolType == Symbol.SymbolType.RANK_PROFILE && parent.getParent() != null && parent.getParent().isASTInstance(RootRankProfile.class)) {
                String workspaceRootURI = this.context.scheduler().getWorkspaceURI();
                if (workspaceRootURI == null) {
                    return ret;
                }
                String currentURI = this.context.fileURI();
                String schemaName = FileUtils.firstPathComponentAfterPrefix(currentURI, workspaceRootURI);
                if (schemaName == null) {
                    return ret;
                }
                Optional<Symbol> schemaSymbol = this.context.schemaIndex().getSchemaDefinition(schemaName);
                if (schemaSymbol.isEmpty()) {
                    return ret;
                }
                node.setSymbol(symbolType, this.context.fileURI(), schemaSymbol.get());
                node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
                this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
            }
            return ret;
        }
        node.setSymbol(symbolType, this.context.fileURI(), scope.get());
        Optional<Symbol> existingSymbol = this.context.schemaIndex().findSymbolInScope(node.getSymbol());
        if (existingSymbol.isEmpty()) {
            node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
            this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
            if (node.getSymbol().getType() == Symbol.SymbolType.FUNCTION) {
                this.verifySymbolFunctionName(node, ret);
            }
            return ret;
        }
        node.setSymbolStatus(Symbol.SymbolStatus.INVALID);
        if (symbolType == Symbol.SymbolType.FIELD) {
            Range range = null;
            if (parent.getParent().isASTInstance(fieldOutsideDoc.class)) {
                range = node.getRange();
            } else if (!this.context.fieldIndex().getIsInsideDoc(existingSymbol.get())) {
                range = existingSymbol.get().getNode().getRange();
            }
            if (range != null) {
                ret.add(new SchemaDiagnostic.Builder().setRange(range).setMessage("Field '" + node.getText() + "' shadows a document field with the same name.").setSeverity(DiagnosticSeverity.Warning).build());
            }
        }
        return ret;
    }

    private boolean handleSpecialCases(SchemaNode node, SchemaNode parent, List<Diagnostic> diagnostics) {
        if (parent.isASTInstance(importField.class) && node.getPreviousSibling() != null && node.getPreviousSibling().isASTInstance(AS.class)) {
            this.createSymbol(node, Symbol.SymbolType.FIELD);
            return true;
        }
        if (parent.indexOf(node) >= 3 && parent.isASTInstance(functionElm.class) && node.isASTInstance(ai.vespa.schemals.parser.ast.identifierStr.class)) {
            this.createSymbol(node, Symbol.SymbolType.PARAMETER);
            return true;
        }
        return !parent.isASTInstance(onnxModelOutput.class) && parent.indexOf(node) >= 3;
    }

    private void handleDataTypeDefinition(SchemaNode node, List<Diagnostic> diagnostics) {
        Optional<Symbol> scope;
        if (node.getParent() == null) {
            return;
        }
        if (node.getParent().isASTInstance(mapDataType.class)) {
            scope = this.findMapScope(node.getParent());
            if (!scope.isPresent()) {
                return;
            }
            if (node.getParent().indexOf(node) == 2) {
                node.setSymbol(Symbol.SymbolType.MAP_KEY, this.context.fileURI(), scope.get(), "key");
                node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
                this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
            } else if (node.getParent().indexOf(node) == 4) {
                dataType dataTypeNode = (dataType)node.getOriginalSchemaNode();
                if (dataTypeNode.getParsedType().getVariant() == ParsedType.Variant.UNKNOWN) {
                    return;
                }
                node.setSymbol(Symbol.SymbolType.MAP_VALUE, this.context.fileURI(), scope.get(), "value");
                node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
                this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
            }
        }
        if (node.isASTInstance(tensorTypeElm.class)) {
            scope = CSTUtils.findScope(node);
            if (!scope.isPresent()) {
                return;
            }
            try {
                TensorType tensorType2 = TensorTypeParser.fromSpec((String)node.getText());
                node.setSymbol(Symbol.SymbolType.TENSOR, this.context.fileURI(), scope.get());
                node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
                this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
                for (TensorType.Dimension dimension : tensorType2.dimensions()) {
                    Symbol.SymbolType type = dimension instanceof TensorType.MappedDimension ? Symbol.SymbolType.TENSOR_DIMENSION_MAPPED : Symbol.SymbolType.TENSOR_DIMENSION_INDEXED;
                    Symbol dimensionSymbol = new Symbol(node, type, this.context.fileURI(), node.getSymbol(), dimension.name());
                    dimensionSymbol.setStatus(Symbol.SymbolStatus.DEFINITION);
                    this.context.schemaIndex().insertSymbolDefinition(dimensionSymbol);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Optional<Symbol> findMapScope(Node mapDataTypeNode) {
        while (mapDataTypeNode != null) {
            if ((mapDataTypeNode = mapDataTypeNode.getParent()) == null) {
                return Optional.empty();
            }
            if (mapDataTypeNode.hasSymbol()) {
                return Optional.of(mapDataTypeNode.getSymbol());
            }
            if (!mapDataTypeNode.isASTInstance(fieldElm.class) && !mapDataTypeNode.isASTInstance(structFieldDefinition.class)) continue;
            Node fieldIdentifierNode = mapDataTypeNode.get(1);
            if (fieldIdentifierNode == null) {
                return Optional.empty();
            }
            if (!fieldIdentifierNode.hasSymbol() || fieldIdentifierNode.getSymbol().getStatus() != Symbol.SymbolStatus.DEFINITION) {
                return Optional.empty();
            }
            return Optional.of(fieldIdentifierNode.getSymbol());
        }
        return Optional.empty();
    }

    private void createSymbol(SchemaNode node, Symbol.SymbolType type) {
        Optional<Symbol> scope = CSTUtils.findScope(node);
        if (scope.isPresent()) {
            node.setSymbol(type, this.context.fileURI(), scope.get());
        } else {
            node.setSymbol(type, this.context.fileURI());
        }
        node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
        this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
    }

    private ArrayList<Diagnostic> identifyDefinitionInRankExpression(SchemaNode node) {
        ArrayList<Diagnostic> ret = new ArrayList<Diagnostic>();
        if (!node.isASTInstance(identifierStr.class)) {
            return ret;
        }
        Node parent = node.getParent();
        if (parent == null) {
            return ret;
        }
        Node grandParent = parent.getParent();
        if (grandParent == null) {
            return ret;
        }
        if (parent.isASTInstance(tensorTypeDimension.class) && grandParent.isASTInstance(tensorType.class)) {
            this.handleTensorTypeDefinitions(node, grandParent.getSchemaNode(), ret);
            return ret;
        }
        if (!grandParent.isASTInstance(lambdaFunction.class) || grandParent.size() < 1) {
            return ret;
        }
        SchemaNode lambdaDefinitionNode = grandParent.get(0).getSchemaNode();
        if (!lambdaDefinitionNode.hasSymbol()) {
            Optional<Symbol> parentScope = CSTUtils.findScope(parent);
            if (parentScope.isEmpty()) {
                return ret;
            }
            lambdaDefinitionNode.setSymbol(Symbol.SymbolType.LAMBDA_FUNCTION, this.context.fileURI(), parentScope.get(), "lambda_" + node.hashCode());
            lambdaDefinitionNode.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
            this.context.schemaIndex().insertSymbolDefinition(lambdaDefinitionNode.getSymbol());
        }
        node.setSymbol(Symbol.SymbolType.PARAMETER, this.context.fileURI(), lambdaDefinitionNode.getSymbol());
        if (this.context.schemaIndex().findSymbolsInScope(node.getSymbol()).size() == 0) {
            node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
            this.context.schemaIndex().insertSymbolDefinition(node.getSymbol());
        } else {
            node.setSymbolStatus(Symbol.SymbolStatus.INVALID);
        }
        return ret;
    }

    private void handleTensorTypeDefinitions(SchemaNode identifierNode, SchemaNode tensorTypeNode, List<Diagnostic> diagnostics) {
        Optional<Symbol> parentScope = CSTUtils.findScope(tensorTypeNode.getParent());
        if (parentScope.isEmpty()) {
            return;
        }
        if (!tensorTypeNode.hasSymbol()) {
            tensorTypeNode.setSymbol(Symbol.SymbolType.TENSOR, this.context.fileURI(), parentScope.get(), "tensor_" + tensorTypeNode.hashCode());
            tensorTypeNode.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
            this.context.schemaIndex().insertSymbolDefinition(tensorTypeNode.getSymbol());
        }
        Symbol scope = tensorTypeNode.getSymbol();
        Symbol.SymbolType dimensionType = Symbol.SymbolType.TENSOR_DIMENSION_INDEXED;
        if (identifierNode.getNextSibling() != null && identifierNode.getNextSibling().isASTInstance(LCURLY.class)) {
            dimensionType = Symbol.SymbolType.TENSOR_DIMENSION_MAPPED;
        }
        identifierNode.setSymbol(dimensionType, this.context.fileURI(), scope, identifierNode.getText());
        Optional<Symbol> existingSymbolMapped = this.context.schemaIndex().findSymbolInScope(scope, Symbol.SymbolType.TENSOR_DIMENSION_MAPPED, identifierNode.getText());
        Optional<Symbol> existingSymbolIndexed = this.context.schemaIndex().findSymbolInScope(scope, Symbol.SymbolType.TENSOR_DIMENSION_INDEXED, identifierNode.getText());
        if (existingSymbolMapped.isPresent() || existingSymbolIndexed.isPresent()) {
            identifierNode.setSymbolStatus(Symbol.SymbolStatus.INVALID);
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(identifierNode.getRange()).setMessage("Duplicate tensor dimension " + identifierNode.getText()).setSeverity(DiagnosticSeverity.Error).build());
            return;
        }
        identifierNode.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
        this.context.schemaIndex().insertSymbolDefinition(identifierNode.getSymbol());
    }

    private void verifySymbolFunctionName(SchemaNode node, List<Diagnostic> diagnostics) {
        String functionName = node.getSymbol().getShortIdentifier();
        if (reservedFunctionNames.contains(functionName)) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage("Function '" + node.getText() + "' has a reserved name. This might mean that the function shadows the built-in function with the same name.").setSeverity(DiagnosticSeverity.Warning).build());
        }
    }
}

