/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.parser;

import ai.vespa.schemals.parser.InvalidToken;
import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.parser.TokenSource;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Objects;

public class SchemaParserLexer
extends TokenSource {
    private static MatcherHook MATCHER_HOOK;
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<Token.TokenType> activeTokenTypes = null;
    static final EnumSet<Token.TokenType> regularTokens;
    static final EnumSet<Token.TokenType> unparsedTokens;
    static final EnumSet<Token.TokenType> skippedTokens;
    static final EnumSet<Token.TokenType> moreTokens;
    private static NfaFunction[] nfaFunctions;

    public static EnumSet<Token.TokenType> getRegularTokens() {
        return EnumSet.copyOf(regularTokens);
    }

    public SchemaParserLexer(CharSequence input) {
        this("input", input);
    }

    public SchemaParserLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.DEFAULT, 1, 1);
    }

    public SchemaParserLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 1, true, false, false, "");
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public Token getNextToken(Token tok) {
        return this.getNextToken(tok, this.activeTokenTypes);
    }

    public Token getNextToken(Token tok, EnumSet<Token.TokenType> activeTokenTypes) {
        if (tok == null) {
            tok = this.tokenizeAt(0, null, activeTokenTypes);
            this.cacheToken(tok);
            return tok;
        }
        Token cachedToken = tok.nextCachedToken();
        if (cachedToken != null && activeTokenTypes != null && !activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            Token token = this.tokenizeAt(tok.getEndOffset(), null, activeTokenTypes);
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<Token.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions, BitSet currentStates, BitSet nextStates, MatchInfo matchInfo) {
        if (matchInfo == null) {
            matchInfo = new MatchInfo();
        }
        if (position >= input.length()) {
            matchInfo.matchedType = Token.TokenType.EOF;
            matchInfo.matchLength = 0;
            return matchInfo;
        }
        int start = position;
        int matchLength = 0;
        Token.TokenType matchedType = Token.TokenType.INVALID;
        EnumSet<Token.TokenType> alreadyMatchedTypes = EnumSet.noneOf(Token.TokenType.class);
        if (currentStates == null) {
            currentStates = new BitSet(2111);
        } else {
            currentStates.clear();
        }
        if (nextStates == null) {
            nextStates = new BitSet(2111);
        } else {
            nextStates.clear();
        }
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                Token.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes, alreadyMatchedTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                    alreadyMatchedTypes.add(returnedType);
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        matchInfo.matchedType = matchedType;
        matchInfo.matchLength = matchLength;
        return matchInfo;
    }

    final Token tokenizeAt(int position, LexicalState lexicalState, EnumSet<Token.TokenType> activeTokenTypes) {
        if (lexicalState == null) {
            lexicalState = this.lexicalState;
        }
        int tokenBeginOffset = position;
        boolean inMore = false;
        int invalidRegionStart = -1;
        Token matchedToken = null;
        Token.TokenType matchedType = null;
        MatchInfo matchInfo = new MatchInfo();
        BitSet currentStates = new BitSet(2111);
        BitSet nextStates = new BitSet(2111);
        while (matchedToken == null) {
            if (!inMore) {
                tokenBeginOffset = position;
            }
            if (MATCHER_HOOK != null) {
                if ((matchInfo = MATCHER_HOOK.apply(lexicalState, this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo)) == null) {
                    matchInfo = SchemaParserLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
                }
            } else {
                matchInfo = SchemaParserLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
            }
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            if (matchedType == Token.TokenType.INVALID) {
                if (invalidRegionStart == -1) {
                    invalidRegionStart = tokenBeginOffset;
                }
                int cp = Character.codePointAt(this, position);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidRegionStart != -1) {
                return new InvalidToken(this, invalidRegionStart, tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = Token.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        return matchedToken;
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(Token t, LexicalState state) {
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        }
    }

    void reset(Token t) {
        this.reset(t, null);
    }

    static {
        regularTokens = EnumSet.of(Token.TokenType.EOF, new Token.TokenType[]{Token.TokenType.NL, Token.TokenType.ANNOTATION, Token.TokenType.ANNOTATIONREFERENCE, Token.TokenType.SCHEMA, Token.TokenType.SEARCH, Token.TokenType.DIVERSITY, Token.TokenType.MIN_GROUPS, Token.TokenType.CUTOFF_FACTOR, Token.TokenType.CUTOFF_STRATEGY, Token.TokenType.LOOSE, Token.TokenType.STRICT, Token.TokenType.DOCUMENT, Token.TokenType.OPERATION, Token.TokenType.ON_MATCH, Token.TokenType.ON_FIRST_PHASE, Token.TokenType.ON_SECOND_PHASE, Token.TokenType.ON_SUMMARY, Token.TokenType.STRUCT, Token.TokenType.INHERITS, Token.TokenType.FIELD, Token.TokenType.FIELDS, Token.TokenType.FIELDSET, Token.TokenType.STRUCT_FIELD, Token.TokenType.IMPORT, Token.TokenType.AS, Token.TokenType.INDEXING, Token.TokenType.SUMMARY_TO, Token.TokenType.DOCUMENT_SUMMARY, Token.TokenType.ELEMENT_GAP, Token.TokenType.INFINITY, Token.TokenType.RANK_TYPE, Token.TokenType.WEIGHT, Token.TokenType.TYPE, Token.TokenType.INDEX, Token.TokenType.INPUTS, Token.TokenType.MTOKEN, Token.TokenType.TEXT, Token.TokenType.WORD, Token.TokenType.GRAM, Token.TokenType.GRAM_SIZE, Token.TokenType.MAX_LENGTH, Token.TokenType.MAX_OCCURRENCES, Token.TokenType.MAX_TOKEN_LENGTH, Token.TokenType.PREFIX, Token.TokenType.SUBSTRING, Token.TokenType.SUFFIX, Token.TokenType.CONSTANT, Token.TokenType.ONNX_MODEL, Token.TokenType.SIGNIFICANCE, Token.TokenType.USE_MODEL, Token.TokenType.WEAKAND, Token.TokenType.STOPWORD_LIMIT, Token.TokenType.ADJUST_TARGET, Token.TokenType.ALLOW_DROP_ALL, Token.TokenType.FILTER_THRESHOLD, Token.TokenType.INTRAOP_THREADS, Token.TokenType.INTEROP_THREADS, Token.TokenType.GPU_DEVICE, Token.TokenType.EXECUTION_MODE, Token.TokenType.PARALLEL, Token.TokenType.SEQUENTIAL, Token.TokenType.MODEL, Token.TokenType.MUTATE, Token.TokenType.QUERY, Token.TokenType.RANK_PROFILE, Token.TokenType.RAW_AS_BASE64_IN_SUMMARY, Token.TokenType.SUMMARY, Token.TokenType.FULL, Token.TokenType.STATIC, Token.TokenType.DYNAMIC, Token.TokenType.TOKENS, Token.TokenType.MATCHED_ELEMENTS_ONLY, Token.TokenType.SSCONTEXTUAL, Token.TokenType.SSOVERRIDE, Token.TokenType.SSTITLE, Token.TokenType.SSURL, Token.TokenType.PROPERTIES, Token.TokenType.ATTRIBUTE, Token.TokenType.SORTING, Token.TokenType.DICTIONARY, Token.TokenType.ASCENDING, Token.TokenType.DESCENDING, Token.TokenType.UCA, Token.TokenType.RAW, Token.TokenType.LOWERCASE, Token.TokenType.FUNCTION, Token.TokenType.LOCALE, Token.TokenType.STRENGTH, Token.TokenType.PRIMARY, Token.TokenType.SECONDARY, Token.TokenType.TERTIARY, Token.TokenType.QUATERNARY, Token.TokenType.IDENTICAL, Token.TokenType.STEMMING, Token.TokenType.NORMALIZING, Token.TokenType.HASH, Token.TokenType.BTREE, Token.TokenType.CASED, Token.TokenType.UNCASED, Token.TokenType.BOLDING, Token.TokenType.NONE, Token.TokenType.ON, Token.TokenType.OFF, Token.TokenType.TRUE, Token.TokenType.FALSE, Token.TokenType.SYMMETRIC, Token.TokenType.QUERY_COMMAND, Token.TokenType.ALIAS, Token.TokenType.MATCH, Token.TokenType.RANK, Token.TokenType.LITERAL, Token.TokenType.EXACT, Token.TokenType.FILTER, Token.TokenType.NORMAL, Token.TokenType.EXACT_TERMINATOR, Token.TokenType.IGNORE_DEFAULT_RANK_FEATURES, Token.TokenType.ID, Token.TokenType.SOURCE, Token.TokenType.TO, Token.TokenType.DIRECT, Token.TokenType.FROM_DISK, Token.TokenType.OMIT_SUMMARY_FEATURES, Token.TokenType.ALWAYS, Token.TokenType.ON_DEMAND, Token.TokenType.NEVER, Token.TokenType.ENABLE_BIT_VECTORS, Token.TokenType.ENABLE_ONLY_BIT_VECTOR, Token.TokenType.FAST_ACCESS, Token.TokenType.MUTABLE, Token.TokenType.PAGED, Token.TokenType.FAST_RANK, Token.TokenType.FAST_SEARCH, Token.TokenType.LBRACE, Token.TokenType.RBRACE, Token.TokenType.COLON, Token.TokenType.DOT, Token.TokenType.COMMA, Token.TokenType.ARRAY, Token.TokenType.WEIGHTEDSET, Token.TokenType.MAP, Token.TokenType.REFERENCE, Token.TokenType.QUESTIONMARK, Token.TokenType.CREATE_IF_NONEXISTENT, Token.TokenType.REMOVE_IF_ZERO, Token.TokenType.MATCH_PHASE, Token.TokenType.EVALUATION_POINT, Token.TokenType.PRE_POST_FILTER_TIPPING_POINT, Token.TokenType.ORDER, Token.TokenType.MAX_FILTER_COVERAGE, Token.TokenType.MAX_HITS, Token.TokenType.FIRST_PHASE, Token.TokenType.SECOND_PHASE, Token.TokenType.GLOBAL_PHASE, Token.TokenType.MACRO, Token.TokenType.INLINE, Token.TokenType.ARITY, Token.TokenType.LOWER_BOUND, Token.TokenType.UPPER_BOUND, Token.TokenType.DENSE_POSTING_LIST_THRESHOLD, Token.TokenType.ENABLE_BM25, Token.TokenType.HNSW, Token.TokenType.MAX_LINKS_PER_NODE, Token.TokenType.DOUBLE_KEYWORD, Token.TokenType.FLOAT_KEYWORD, Token.TokenType.LONG_KEYWORD, Token.TokenType.STRING_KEYWORD, Token.TokenType.DISTANCE_METRIC, Token.TokenType.NEIGHBORS_TO_EXPLORE_AT_INSERT, Token.TokenType.MULTI_THREADED_INDEXING, Token.TokenType.RANK_PROPERTIES, Token.TokenType.RERANK_COUNT, Token.TokenType.NUM_THREADS_PER_SEARCH, Token.TokenType.MIN_HITS_PER_THREAD, Token.TokenType.NUM_SEARCH_PARTITIONS, Token.TokenType.TERMWISE_LIMIT, Token.TokenType.POST_FILTER_THRESHOLD, Token.TokenType.APPROXIMATE_THRESHOLD, Token.TokenType.TARGET_HITS_MAX_ADJUSTMENT_FACTOR, Token.TokenType.KEEP_RANK_COUNT, Token.TokenType.RANK_SCORE_DROP_LIMIT, Token.TokenType.CONSTANTS, Token.TokenType.FILE, Token.TokenType.URI, Token.TokenType.LESSTHAN, Token.TokenType.GREATERTHAN, Token.TokenType._TOKEN_190, Token.TokenType._TOKEN_191, Token.TokenType._TOKEN_192, Token.TokenType._TOKEN_193, Token.TokenType.$, Token.TokenType._TOKEN_195, Token.TokenType._TOKEN_196, Token.TokenType._TOKEN_197, Token.TokenType._TOKEN_198, Token.TokenType.TENSOR_TYPE, Token.TokenType.TENSOR_VALUE_SL, Token.TokenType.TENSOR_VALUE_ML, Token.TokenType.MATCHFEATURES_SL, Token.TokenType.MATCHFEATURES_ML, Token.TokenType.MATCHFEATURES_ML_INHERITS, Token.TokenType.SUMMARYFEATURES_SL, Token.TokenType.SUMMARYFEATURES_ML, Token.TokenType.SUMMARYFEATURES_ML_INHERITS, Token.TokenType.RANKFEATURES_SL, Token.TokenType.RANKFEATURES_ML, Token.TokenType.EXPRESSION_SL, Token.TokenType.EXPRESSION_ML, Token.TokenType.IDENTIFIER, Token.TokenType.IDENTIFIER_WITH_DASH, Token.TokenType.DOUBLEQUOTEDSTRING, Token.TokenType.SINGLEQUOTEDSTRING, Token.TokenType.CONTEXT, Token.TokenType.DOUBLE, Token.TokenType.INTEGER, Token.TokenType.LONG, Token.TokenType.STRING, Token.TokenType.FILE_PATH, Token.TokenType.HTTP, Token.TokenType.URI_PATH, Token.TokenType.ONNX_INPUT_SL, Token.TokenType.ONNX_OUTPUT_SL, Token.TokenType.VARIABLE});
        unparsedTokens = EnumSet.of(Token.TokenType.SINGLE_LINE_COMMENT);
        skippedTokens = EnumSet.of(Token.TokenType._TOKEN_1, Token.TokenType._TOKEN_2, Token.TokenType._TOKEN_3, Token.TokenType._TOKEN_4);
        moreTokens = EnumSet.noneOf(Token.TokenType.class);
        DEFAULT.NFA_FUNCTIONS_init();
    }

    public static enum LexicalState {
        DEFAULT;

    }

    static class MatchInfo {
        Token.TokenType matchedType;
        int matchLength;

        MatchInfo() {
        }

        public int hashCode() {
            return Objects.hash(this.matchLength, this.matchedType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchInfo other = (MatchInfo)obj;
            return this.matchLength == other.matchLength && this.matchedType == other.matchedType;
        }
    }

    @FunctionalInterface
    static interface NfaFunction {
        public Token.TokenType apply(int var1, BitSet var2, EnumSet<Token.TokenType> var3, EnumSet<Token.TokenType> var4);
    }

    @FunctionalInterface
    private static interface MatcherHook {
        public MatchInfo apply(LexicalState var1, CharSequence var2, int var3, EnumSet<Token.TokenType> var4, NfaFunction[] var5, BitSet var6, BitSet var7, MatchInfo var8);
    }

    private static class DEFAULT {
        private DEFAULT() {
        }

        private static Token.TokenType getNfaIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 34) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLEQUOTEDSTRING)) {
                    nextStates.set(194);
                }
            } else if (ch == 36) {
                if (validTypes == null || validTypes.contains(Token.TokenType.VARIABLE)) {
                    nextStates.set(45);
                }
            } else if (ch == 39) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SINGLEQUOTEDSTRING)) {
                    nextStates.set(36);
                }
            } else if (ch == 43) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_191)) {
                    nextStates.set(214);
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE)) {
                    nextStates.set(841);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_192)) {
                    nextStates.set(122);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LONG)) {
                    nextStates.set(1225);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER)) {
                    nextStates.set(175);
                }
            } else if (ch >= 48 && ch <= 57) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LONG)) {
                    nextStates.set(79);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE)) {
                    nextStates.set(842);
                }
            } else if ((ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) && (validTypes == null || validTypes.contains(Token.TokenType.FILE_PATH))) {
                nextStates.set(182);
            }
            if (ch == 72 || ch == 104) {
                if (validTypes == null || validTypes.contains(Token.TokenType.URI_PATH)) {
                    nextStates.set(238);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.HTTP)) {
                    nextStates.set(303);
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_190)) {
                    nextStates.set(49);
                }
            } else if (ch == 97) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ARITY)) {
                    nextStates.set(355);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.APPROXIMATE_THRESHOLD)) {
                    nextStates.set(419);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ALWAYS)) {
                    nextStates.set(440);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ADJUST_TARGET)) {
                    nextStates.set(596);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ARRAY)) {
                    nextStates.set(796);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ANNOTATION)) {
                    nextStates.set(859);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ANNOTATIONREFERENCE)) {
                    nextStates.set(1019);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ALIAS)) {
                    nextStates.set(1109);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ALLOW_DROP_ALL)) {
                    nextStates.set(1148);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ASCENDING)) {
                    nextStates.set(1353);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.AS)) {
                    nextStates.set(183);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ATTRIBUTE)) {
                    nextStates.set(1698);
                }
            } else if (ch == 98) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BTREE)) {
                    nextStates.set(1337);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.BOLDING)) {
                    nextStates.set(1587);
                }
            } else if (ch == 99) {
                if (validTypes == null || validTypes.contains(Token.TokenType.CUTOFF_FACTOR)) {
                    nextStates.set(358);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SSCONTEXTUAL)) {
                    nextStates.set(539);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CONSTANTS)) {
                    nextStates.set(653);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CONSTANT)) {
                    nextStates.set(1129);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CASED)) {
                    nextStates.set(1170);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CREATE_IF_NONEXISTENT)) {
                    nextStates.set(1449);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CUTOFF_STRATEGY)) {
                    nextStates.set(1682);
                }
            } else if (ch == 100) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DISTANCE_METRIC)) {
                    nextStates.set(569);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE_KEYWORD)) {
                    nextStates.set(981);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.DICTIONARY)) {
                    nextStates.set(1101);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.DENSE_POSTING_LIST_THRESHOLD)) {
                    nextStates.set(1199);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.DYNAMIC)) {
                    nextStates.set(1234);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.DIRECT)) {
                    nextStates.set(1415);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.DESCENDING)) {
                    nextStates.set(1549);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.DOCUMENT)) {
                    nextStates.set(1576);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.DOCUMENT_SUMMARY)) {
                    nextStates.set(1705);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.DIVERSITY)) {
                    nextStates.set(1770);
                }
            } else if (ch == 101) {
                if (validTypes == null || validTypes.contains(Token.TokenType.EVALUATION_POINT)) {
                    nextStates.set(275);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.EXPRESSION_ML)) {
                    nextStates.set(309);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.EXACT)) {
                    nextStates.set(323);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ENABLE_BIT_VECTORS)) {
                    nextStates.set(824);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ENABLE_ONLY_BIT_VECTOR)) {
                    nextStates.set(985);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ENABLE_BM25)) {
                    nextStates.set(1008);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.EXPRESSION_SL)) {
                    nextStates.set(1299);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.EXECUTION_MODE)) {
                    nextStates.set(1419);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ELEMENT_GAP)) {
                    nextStates.set(1521);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.EXACT_TERMINATOR)) {
                    nextStates.set(1719);
                }
            } else if (ch == 102) {
                if (validTypes == null || validTypes.contains(Token.TokenType.FAST_SEARCH)) {
                    nextStates.set(225);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FIELDS)) {
                    nextStates.set(234);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FAST_RANK)) {
                    nextStates.set(393);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FILTER_THRESHOLD)) {
                    nextStates.set(450);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FUNCTION)) {
                    nextStates.set(501);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FAST_ACCESS)) {
                    nextStates.set(626);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FIELD)) {
                    nextStates.set(635);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOAT_KEYWORD)) {
                    nextStates.set(710);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FROM_DISK)) {
                    nextStates.set(755);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FIRST_PHASE)) {
                    nextStates.set(924);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FILTER)) {
                    nextStates.set(936);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FIELDSET)) {
                    nextStates.set(1160);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FULL)) {
                    nextStates.set(1272);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FILE)) {
                    nextStates.set(1360);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FALSE)) {
                    nextStates.set(1733);
                }
            } else if (ch == 103) {
                if (validTypes == null || validTypes.contains(Token.TokenType.GRAM)) {
                    nextStates.set(651);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.GRAM_SIZE)) {
                    nextStates.set(946);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.GPU_DEVICE)) {
                    nextStates.set(1226);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.GLOBAL_PHASE)) {
                    nextStates.set(1243);
                }
            }
            if (ch == 104) {
                if (validTypes == null || validTypes.contains(Token.TokenType.HNSW)) {
                    nextStates.set(1017);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.HASH)) {
                    nextStates.set(1530);
                }
            } else if (ch == 105) {
                if (validTypes == null || validTypes.contains(Token.TokenType.INFINITY)) {
                    nextStates.set(263);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.IDENTICAL)) {
                    nextStates.set(524);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ONNX_INPUT_SL)) {
                    nextStates.set(672);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.IGNORE_DEFAULT_RANK_FEATURES)) {
                    nextStates.set(722);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.INLINE)) {
                    nextStates.set(920);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.INDEXING)) {
                    nextStates.set(940);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.INHERITS)) {
                    nextStates.set(1076);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ID)) {
                    nextStates.set(140);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.INPUTS)) {
                    nextStates.set(1532);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEROP_THREADS)) {
                    nextStates.set(1536);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.INDEX)) {
                    nextStates.set(1572);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.INTRAOP_THREADS)) {
                    nextStates.set(1609);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.IMPORT)) {
                    nextStates.set(1751);
                }
            } else if (ch == 107) {
                if (validTypes == null || validTypes.contains(Token.TokenType.KEEP_RANK_COUNT)) {
                    nextStates.set(1340);
                }
            } else if (ch == 108) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LITERAL)) {
                    nextStates.set(582);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LOWER_BOUND)) {
                    nextStates.set(587);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LONG_KEYWORD)) {
                    nextStates.set(713);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LOWERCASE)) {
                    nextStates.set(748);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LOCALE)) {
                    nextStates.set(969);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LOOSE)) {
                    nextStates.set(1755);
                }
            } else if (ch == 109) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MATCHFEATURES_ML)) {
                    nextStates.set(289);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MAX_LINKS_PER_NODE)) {
                    nextStates.set(369);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MUTATE)) {
                    nextStates.set(415);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MAX_HITS)) {
                    nextStates.set(444);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MIN_HITS_PER_THREAD)) {
                    nextStates.set(507);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MIN_GROUPS)) {
                    nextStates.set(554);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MUTABLE)) {
                    nextStates.set(646);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MATCHED_ELEMENTS_ONLY)) {
                    nextStates.set(777);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MAP)) {
                    nextStates.set(858);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MACRO)) {
                    nextStates.set(953);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MAX_OCCURRENCES)) {
                    nextStates.set(956);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MATCH)) {
                    nextStates.set(1005);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MULTI_THREADED_INDEXING)) {
                    nextStates.set(1055);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MATCH_PHASE)) {
                    nextStates.set(1135);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MAX_TOKEN_LENGTH)) {
                    nextStates.set(1311);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MAX_LENGTH)) {
                    nextStates.set(1431);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MATCHFEATURES_SL)) {
                    nextStates.set(1508);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MAX_FILTER_COVERAGE)) {
                    nextStates.set(1592);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MODEL)) {
                    nextStates.set(1626);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MATCHFEATURES_ML_INHERITS)) {
                    nextStates.set(1810);
                }
            } else if (ch == 110) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NORMAL)) {
                    nextStates.set(400);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NORMALIZING)) {
                    nextStates.set(678);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NUM_SEARCH_PARTITIONS)) {
                    nextStates.set(1180);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NEVER)) {
                    nextStates.set(1334);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NONE)) {
                    nextStates.set(1394);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NEIGHBORS_TO_EXPLORE_AT_INSERT)) {
                    nextStates.set(1480);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NUM_THREADS_PER_SEARCH)) {
                    nextStates.set(1658);
                }
            } else if (ch == 111) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ON_FIRST_PHASE)) {
                    nextStates.set(251);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ONNX_MODEL)) {
                    nextStates.set(531);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ON_DEMAND)) {
                    nextStates.set(547);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ONNX_OUTPUT_SL)) {
                    nextStates.set(660);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.OMIT_SUMMARY_FEATURES)) {
                    nextStates.set(867);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ON)) {
                    nextStates.set(135);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.OPERATION)) {
                    nextStates.set(1284);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ON_SUMMARY)) {
                    nextStates.set(1291);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ON_SECOND_PHASE)) {
                    nextStates.set(1396);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ON_MATCH)) {
                    nextStates.set(1409);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SSOVERRIDE)) {
                    nextStates.set(1439);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.OFF)) {
                    nextStates.set(1575);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ORDER)) {
                    nextStates.set(1695);
                }
            } else if (ch == 112) {
                if (validTypes == null || validTypes.contains(Token.TokenType.PROPERTIES)) {
                    nextStates.set(404);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.PRE_POST_FILTER_TIPPING_POINT)) {
                    nextStates.set(464);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.PAGED)) {
                    nextStates.set(933);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.PARALLEL)) {
                    nextStates.set(1095);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.PREFIX)) {
                    nextStates.set(1239);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.POST_FILTER_THRESHOLD)) {
                    nextStates.set(1253);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.PRIMARY)) {
                    nextStates.set(1653);
                }
            } else if (ch == 113) {
                if (validTypes == null || validTypes.contains(Token.TokenType.QUERY)) {
                    nextStates.set(799);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.QUERY_COMMAND)) {
                    nextStates.set(843);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.QUATERNARY)) {
                    nextStates.set(973);
                }
            } else if (ch == 114) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RAW)) {
                    nextStates.set(248);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.REFERENCE)) {
                    nextStates.set(562);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RANK_SCORE_DROP_LIMIT)) {
                    nextStates.set(607);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RANK_PROPERTIES)) {
                    nextStates.set(697);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RAW_AS_BASE64_IN_SUMMARY)) {
                    nextStates.set(802);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.REMOVE_IF_ZERO)) {
                    nextStates.set(908);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RERANK_COUNT)) {
                    nextStates.set(1043);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RANK_PROFILE)) {
                    nextStates.set(1274);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RANKFEATURES_ML)) {
                    nextStates.set(1371);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RANK_TYPE)) {
                    nextStates.set(1468);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RANKFEATURES_SL)) {
                    nextStates.set(1758);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RANK)) {
                    nextStates.set(1808);
                }
            } else if (ch == 115) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SUFFIX)) {
                    nextStates.set(244);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SCHEMA)) {
                    nextStates.set(305);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SUMMARYFEATURES_ML_INHERITS)) {
                    nextStates.set(326);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SEQUENTIAL)) {
                    nextStates.set(385);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SUMMARY_TO)) {
                    nextStates.set(638);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SORTING)) {
                    nextStates.set(667);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.STRUCT_FIELD)) {
                    nextStates.set(687);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SUBSTRING)) {
                    nextStates.set(715);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.STEMMING)) {
                    nextStates.set(771);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SEARCH)) {
                    nextStates.set(854);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SECONDARY)) {
                    nextStates.set(886);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.STRENGTH)) {
                    nextStates.set(902);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.STRING_KEYWORD)) {
                    nextStates.set(1091);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SUMMARYFEATURES_ML)) {
                    nextStates.set(1113);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.STRUCT)) {
                    nextStates.set(1144);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SYMMETRIC)) {
                    nextStates.set(1173);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.STRICT)) {
                    nextStates.set(1362);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SECOND_PHASE)) {
                    nextStates.set(1384);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SOURCE)) {
                    nextStates.set(1445);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SUMMARY)) {
                    nextStates.set(1557);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SIGNIFICANCE)) {
                    nextStates.set(1562);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.STOPWORD_LIMIT)) {
                    nextStates.set(1629);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.STATIC)) {
                    nextStates.set(1678);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SUMMARYFEATURES_SL)) {
                    nextStates.set(1736);
                }
            } else if (ch == 116) {
                if (validTypes == null || validTypes.contains(Token.TokenType.TRUE)) {
                    nextStates.set(249);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TERTIARY)) {
                    nextStates.set(269);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MTOKEN)) {
                    nextStates.set(412);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TO)) {
                    nextStates.set(29);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TEXT)) {
                    nextStates.set(438);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TENSOR_TYPE)) {
                    nextStates.set(762);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TOKENS)) {
                    nextStates.set(1166);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TYPE)) {
                    nextStates.set(1582);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SSTITLE)) {
                    nextStates.set(1584);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TERMWISE_LIMIT)) {
                    nextStates.set(1641);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TARGET_HITS_MAX_ADJUSTMENT_FACTOR)) {
                    nextStates.set(1777);
                }
            } else if (ch == 117) {
                if (validTypes == null || validTypes.contains(Token.TokenType.UCA)) {
                    nextStates.set(354);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SSURL)) {
                    nextStates.set(840);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.UPPER_BOUND)) {
                    nextStates.set(893);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.USE_MODEL)) {
                    nextStates.set(1036);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.URI)) {
                    nextStates.set(1112);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.UNCASED)) {
                    nextStates.set(1366);
                }
            } else if (ch == 118) {
                if (validTypes == null || validTypes.contains(Token.TokenType.TENSOR_VALUE_ML)) {
                    nextStates.set(491);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TENSOR_VALUE_SL)) {
                    nextStates.set(1082);
                }
            } else if (ch == 119) {
                if (validTypes == null || validTypes.contains(Token.TokenType.WORD)) {
                    nextStates.set(1053);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.WEIGHTEDSET)) {
                    nextStates.set(1325);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.WEAKAND)) {
                    nextStates.set(1475);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.WEIGHT)) {
                    nextStates.set(1622);
                }
            } else if (ch == 35 && (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_COMMENT))) {
                nextStates.set(213);
                type = Token.TokenType.SINGLE_LINE_COMMENT;
            }
            if ((ch == 46 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) && (validTypes == null || validTypes.contains(Token.TokenType.STRING))) {
                nextStates.set(204);
                type = Token.TokenType.STRING;
            }
            if (ch >= 48 && ch <= 57) {
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER)) {
                    nextStates.set(175);
                    type = Token.TokenType.INTEGER;
                }
            } else if ((ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) && (validTypes == null || validTypes.contains(Token.TokenType.CONTEXT))) {
                nextStates.set(52);
                type = Token.TokenType.CONTEXT;
            }
            if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                if (validTypes == null || validTypes.contains(Token.TokenType.IDENTIFIER_WITH_DASH)) {
                    nextStates.set(6);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.IDENTIFIER)) {
                    nextStates.set(88);
                    type = Token.TokenType.IDENTIFIER;
                }
            } else if (ch == 93) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_198)) {
                    type = Token.TokenType._TOKEN_198;
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_197)) {
                    type = Token.TokenType._TOKEN_197;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_196)) {
                    type = Token.TokenType._TOKEN_196;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_195)) {
                    type = Token.TokenType._TOKEN_195;
                }
            } else if (ch == 36) {
                if (validTypes == null || validTypes.contains(Token.TokenType.$)) {
                    type = Token.TokenType.$;
                }
            } else if (ch == 61) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_193)) {
                    type = Token.TokenType._TOKEN_193;
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(Token.TokenType.GREATERTHAN)) {
                    type = Token.TokenType.GREATERTHAN;
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LESSTHAN)) {
                    type = Token.TokenType.LESSTHAN;
                }
            } else if (ch == 63) {
                if (validTypes == null || validTypes.contains(Token.TokenType.QUESTIONMARK)) {
                    type = Token.TokenType.QUESTIONMARK;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COMMA)) {
                    type = Token.TokenType.COMMA;
                }
            } else if (ch == 46) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DOT)) {
                    type = Token.TokenType.DOT;
                }
            } else if (ch == 58) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COLON)) {
                    type = Token.TokenType.COLON;
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RBRACE)) {
                    type = Token.TokenType.RBRACE;
                }
            } else if (ch == 123) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LBRACE)) {
                    type = Token.TokenType.LBRACE;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NL)) {
                    type = Token.TokenType.NL;
                }
            } else if (ch == 12) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_4)) {
                    type = Token.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_3)) {
                    type = Token.TokenType._TOKEN_3;
                }
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_2)) {
                    type = Token.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_1))) {
                type = Token.TokenType._TOKEN_1;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.FAST_SEARCH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.FIELDS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 47) {
                nextStates.set(242);
            }
            if (ch >= 45 && ch <= 58 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(4);
                type = Token.TokenType.URI_PATH;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 45 && ch <= 58 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(4);
                return Token.TokenType.URI_PATH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                return Token.TokenType.SUFFIX;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(6);
                return Token.TokenType.IDENTIFIER_WITH_DASH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                return Token.TokenType.RAW;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.TRUE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.ON_FIRST_PHASE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.INFINITY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.TERTIARY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.EVALUATION_POINT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 124 || ch >= 126) {
                nextStates.set(13);
            } else if (ch == 125) {
                type = Token.TokenType.MATCHFEATURES_ML;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(15);
                return Token.TokenType.HTTP;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                return Token.TokenType.HTTP;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                return Token.TokenType.SCHEMA;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(17);
            } else if (ch == 123) {
                nextStates.set(319);
            } else if (ch == 125) {
                type = Token.TokenType.EXPRESSION_ML;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.EXACT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 124 || ch >= 126) {
                nextStates.set(19);
            } else if (ch == 125) {
                type = Token.TokenType.SUMMARYFEATURES_ML_INHERITS;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                return Token.TokenType.UCA;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.ARITY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return Token.TokenType.CUTOFF_FACTOR;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.MAX_LINKS_PER_NODE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.SEQUENTIAL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                return Token.TokenType.FAST_RANK;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.NORMAL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.PROPERTIES;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.MTOKEN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                return Token.TokenType.TO;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.MUTATE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.APPROXIMATE_THRESHOLD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.TEXT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.ALWAYS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.MAX_HITS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.FILTER_THRESHOLD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(36);
            } else if (ch == 39) {
                type = Token.TokenType.SINGLEQUOTEDSTRING;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.PRE_POST_FILTER_TIPPING_POINT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 10 || ch == 32) {
                nextStates.set(38);
            } else if (ch == 125) {
                nextStates.set(39);
                type = Token.TokenType.TENSOR_VALUE_ML;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 10) {
                return Token.TokenType.TENSOR_VALUE_ML;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.FUNCTION;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.MIN_HITS_PER_THREAD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.IDENTICAL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.ONNX_MODEL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.SSCONTEXTUAL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(46);
                return Token.TokenType.VARIABLE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(46);
                return Token.TokenType.VARIABLE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.ON_DEMAND;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.MIN_GROUPS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 93) {
                return Token.TokenType._TOKEN_190;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.REFERENCE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                return Token.TokenType.DISTANCE_METRIC;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) {
                nextStates.set(52);
                return Token.TokenType.CONTEXT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.LITERAL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.LOWER_BOUND;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.ADJUST_TARGET;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.RANK_SCORE_DROP_LIMIT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.FAST_ACCESS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.FIELD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                return Token.TokenType.SUMMARY_TO;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.MUTABLE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                return Token.TokenType.GRAM;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.CONSTANTS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 32) {
                nextStates.set(66);
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(63);
            } else if (ch == 58) {
                nextStates.set(64);
                type = Token.TokenType.ONNX_OUTPUT_SL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11) {
                nextStates.set(65);
                type = Token.TokenType.ONNX_OUTPUT_SL;
            }
            if (ch == 32) {
                nextStates.set(64);
                type = Token.TokenType.ONNX_OUTPUT_SL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11) {
                nextStates.set(65);
                return Token.TokenType.ONNX_OUTPUT_SL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 32) {
                nextStates.set(66);
            } else if (ch == 58) {
                nextStates.set(64);
                type = Token.TokenType.ONNX_OUTPUT_SL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.SORTING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 32) {
                nextStates.set(69);
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(68);
            } else if (ch == 58) {
                nextStates.set(70);
                type = Token.TokenType.ONNX_INPUT_SL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 32) {
                nextStates.set(69);
            } else if (ch == 58) {
                nextStates.set(70);
                type = Token.TokenType.ONNX_INPUT_SL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11) {
                nextStates.set(71);
                type = Token.TokenType.ONNX_INPUT_SL;
            }
            if (ch == 32) {
                nextStates.set(70);
                type = Token.TokenType.ONNX_INPUT_SL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11) {
                nextStates.set(71);
                return Token.TokenType.ONNX_INPUT_SL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.NORMALIZING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.STRUCT_FIELD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.RANK_PROPERTIES;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.FLOAT_KEYWORD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.LONG_KEYWORD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.SUBSTRING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex78(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.IGNORE_DEFAULT_RANK_FEATURES;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex79(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(79);
            } else if (ch == 76) {
                type = Token.TokenType.LONG;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex80(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.LOWERCASE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex81(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                return Token.TokenType.FROM_DISK;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex82(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 39 || ch >= 42) {
                nextStates.set(82);
            } else if (ch == 41) {
                type = Token.TokenType.TENSOR_TYPE;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex83(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.STEMMING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex84(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.MATCHED_ELEMENTS_ONLY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex85(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.ARRAY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex86(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.QUERY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex87(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.RAW_AS_BASE64_IN_SUMMARY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex88(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(88);
                return Token.TokenType.IDENTIFIER;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex89(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.ENABLE_BIT_VECTORS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex90(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.SSURL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex91(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(91);
                return Token.TokenType.DOUBLE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex92(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.QUERY_COMMAND;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex93(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.SEARCH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex94(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                return Token.TokenType.MAP;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex95(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.ANNOTATION;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex96(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.OMIT_SUMMARY_FEATURES;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex97(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.SECONDARY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex98(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.UPPER_BOUND;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex99(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.STRENGTH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex100(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                return Token.TokenType.REMOVE_IF_ZERO;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex101(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.INLINE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex102(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.FIRST_PHASE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex103(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.PAGED;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex104(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return Token.TokenType.FILTER;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex105(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.INDEXING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex106(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.GRAM_SIZE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex107(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                return Token.TokenType.MACRO;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex108(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.MAX_OCCURRENCES;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex109(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.LOCALE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex110(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.QUATERNARY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex111(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.DOUBLE_KEYWORD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex112(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return Token.TokenType.ENABLE_ONLY_BIT_VECTOR;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex113(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.MATCH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex114(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 53) {
                return Token.TokenType.ENABLE_BM25;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex115(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                return Token.TokenType.HNSW;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex116(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.ANNOTATIONREFERENCE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex117(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.USE_MODEL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex118(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.RERANK_COUNT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex119(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.WORD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex120(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.MULTI_THREADED_INDEXING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex121(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.INHERITS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex122(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType._TOKEN_192;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex123(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(123);
            } else if (ch == 123) {
                nextStates.set(1088);
            } else if (ch == 125) {
                nextStates.set(124);
                type = Token.TokenType.TENSOR_VALUE_SL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex124(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 10) {
                return Token.TokenType.TENSOR_VALUE_SL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex125(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.STRING_KEYWORD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex126(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.PARALLEL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex127(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.DICTIONARY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex128(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.ALIAS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex129(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                return Token.TokenType.URI;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex130(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 124 || ch >= 126) {
                nextStates.set(130);
            } else if (ch == 125) {
                type = Token.TokenType.SUMMARYFEATURES_ML;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex131(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.CONSTANT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex132(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.MATCH_PHASE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex133(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.STRUCT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex134(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.ALLOW_DROP_ALL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex135(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.ON;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex136(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.FIELDSET;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex137(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.TOKENS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex138(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.CASED;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex139(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                return Token.TokenType.SYMMETRIC;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex140(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.ID;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex141(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.NUM_SEARCH_PARTITIONS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex142(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.DENSE_POSTING_LIST_THRESHOLD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex143(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.GPU_DEVICE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex144(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                return Token.TokenType.DYNAMIC;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex145(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                return Token.TokenType.PREFIX;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex146(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.GLOBAL_PHASE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex147(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.POST_FILTER_THRESHOLD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex148(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.FULL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex149(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.RANK_PROFILE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex150(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.OPERATION;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex151(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.ON_SUMMARY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex152(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 32) {
                nextStates.set(152);
            } else if (ch == 58) {
                nextStates.set(153);
                type = Token.TokenType.EXPRESSION_SL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex153(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 123) {
                nextStates.set(154);
            } else if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(153);
                type = Token.TokenType.EXPRESSION_SL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex154(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(154);
            } else if (ch == 123) {
                nextStates.set(1308);
            } else if (ch == 125) {
                nextStates.set(153);
                type = Token.TokenType.EXPRESSION_SL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex155(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.MAX_TOKEN_LENGTH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex156(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.WEIGHTEDSET;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex157(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return Token.TokenType.NEVER;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex158(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.BTREE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex159(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.KEEP_RANK_COUNT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex160(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.ASCENDING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex161(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.FILE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex162(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.STRICT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex163(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.UNCASED;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex164(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 124 || ch >= 126) {
                nextStates.set(164);
            } else if (ch == 125) {
                type = Token.TokenType.RANKFEATURES_ML;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex165(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.SECOND_PHASE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex166(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.NONE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex167(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.ON_SECOND_PHASE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex168(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.ON_MATCH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex169(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.DIRECT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex170(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.EXECUTION_MODE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex171(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.MAX_LENGTH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex172(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.SSOVERRIDE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex173(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.SOURCE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex174(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.CREATE_IF_NONEXISTENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex175(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(175);
                return Token.TokenType.INTEGER;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex176(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.RANK_TYPE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex177(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.WEAKAND;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex178(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.NEIGHBORS_TO_EXPLORE_AT_INSERT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex179(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 32) {
                nextStates.set(179);
            } else if (ch == 58) {
                nextStates.set(180);
                type = Token.TokenType.MATCHFEATURES_SL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex180(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 124 || ch >= 126) {
                nextStates.set(180);
                return Token.TokenType.MATCHFEATURES_SL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex181(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                return Token.TokenType.ELEMENT_GAP;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex182(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 45 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(182);
                return Token.TokenType.FILE_PATH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex183(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.AS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex184(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.HASH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex185(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.INPUTS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex186(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.INTEROP_THREADS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex187(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.DESCENDING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex188(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.SUMMARY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex189(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.SIGNIFICANCE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex190(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                return Token.TokenType.INDEX;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex191(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                return Token.TokenType.OFF;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex192(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.DOCUMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex193(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.TYPE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex194(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(194);
            } else if (ch == 34) {
                type = Token.TokenType.DOUBLEQUOTEDSTRING;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex195(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.SSTITLE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex196(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.BOLDING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex197(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.MAX_FILTER_COVERAGE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex198(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.INTRAOP_THREADS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex199(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.WEIGHT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex200(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.MODEL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex201(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.STOPWORD_LIMIT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex202(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.TERMWISE_LIMIT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex203(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.PRIMARY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex204(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 46 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(204);
                return Token.TokenType.STRING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex205(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.NUM_THREADS_PER_SEARCH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex206(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                return Token.TokenType.STATIC;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex207(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.CUTOFF_STRATEGY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex208(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return Token.TokenType.ORDER;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex209(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.ATTRIBUTE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex210(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.DOCUMENT_SUMMARY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex211(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return Token.TokenType.EXACT_TERMINATOR;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex212(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.FALSE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex213(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14) {
                nextStates.set(213);
                return Token.TokenType.SINGLE_LINE_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex214(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType._TOKEN_191;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex215(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 32) {
                nextStates.set(215);
            } else if (ch == 58) {
                nextStates.set(216);
                type = Token.TokenType.SUMMARYFEATURES_SL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex216(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 124 || ch >= 126) {
                nextStates.set(216);
                return Token.TokenType.SUMMARYFEATURES_SL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex217(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.IMPORT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex218(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.LOOSE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex219(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 32) {
                nextStates.set(219);
            } else if (ch == 58) {
                nextStates.set(220);
                type = Token.TokenType.RANKFEATURES_SL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex220(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 124 || ch >= 126) {
                nextStates.set(220);
                return Token.TokenType.RANKFEATURES_SL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex221(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.DIVERSITY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex222(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return Token.TokenType.TARGET_HITS_MAX_ADJUSTMENT_FACTOR;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex223(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                return Token.TokenType.RANK;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex224(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 124 || ch >= 126) {
                nextStates.set(224);
            } else if (ch == 125) {
                type = Token.TokenType.MATCHFEATURES_ML_INHERITS;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex225(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(226);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex226(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(227);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex227(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(228);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex228(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(229);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex229(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(230);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex230(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(231);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex231(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(232);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex232(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(233);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex233(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex234(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(235);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex235(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(236);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex236(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(237);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex237(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(2);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex238(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(239);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex239(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(240);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex240(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(241);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex241(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 58) {
                nextStates.set(3);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(243);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex242(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 47) {
                nextStates.set(4);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex243(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 58) {
                nextStates.set(3);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex244(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(245);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex245(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(246);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex246(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(247);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex247(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(5);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex248(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(7);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex249(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(250);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex250(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(8);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex251(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(252);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex252(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(253);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex253(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(254);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex254(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(255);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex255(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(256);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex256(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(257);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex257(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(258);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex258(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(259);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex259(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(260);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex260(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(261);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex261(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(262);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex262(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(9);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex263(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(264);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex264(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(265);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex265(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(266);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex266(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(267);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex267(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(268);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex268(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(10);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex269(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(270);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex270(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(271);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex271(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(272);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex272(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(273);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex273(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(274);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex274(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(11);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex275(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(276);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex276(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(277);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex277(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(278);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex278(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(279);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex279(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(280);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex280(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(281);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex281(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(282);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex282(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(283);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex283(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(284);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex284(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(285);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex285(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(286);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex286(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(287);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex287(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(288);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex288(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(12);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex289(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(290);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex290(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(291);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex291(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(292);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex292(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(293);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex293(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(294);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex294(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(295);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex295(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(296);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex296(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(297);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex297(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(298);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex298(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(299);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex299(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(300);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex300(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(301);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex301(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(302);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex302(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 9 || ch == 10 || ch == 12 || ch == 13 || ch == 32) {
                nextStates.set(302);
            } else if (ch == 123) {
                nextStates.set(13);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex303(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(304);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex304(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(14);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex305(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(306);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex306(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(307);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex307(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(308);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex308(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(16);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex309(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(310);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex310(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(311);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex311(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(312);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex312(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(313);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex313(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(314);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex314(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(315);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex315(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(316);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex316(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(317);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex317(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(318);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex318(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 9 || ch == 10 || ch == 12 || ch == 13 || ch == 32) {
                nextStates.set(318);
            } else if (ch == 123) {
                nextStates.set(17);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex319(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(319);
            } else if (ch == 123) {
                nextStates.set(320);
            } else if (ch == 125) {
                nextStates.set(17);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex320(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(320);
            } else if (ch == 123) {
                nextStates.set(321);
            } else if (ch == 125) {
                nextStates.set(319);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex321(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(322);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex322(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(322);
            } else if (ch == 125) {
                nextStates.set(320);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex323(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(324);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex324(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(325);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex325(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(18);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex326(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(327);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex327(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(328);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex328(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(329);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex329(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(330);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex330(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(331);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex331(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(332);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex332(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(333);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex333(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(334);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex334(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(335);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex335(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(336);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex336(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(337);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex337(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(338);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex338(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(339);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex339(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(340);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex340(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(341);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex341(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(342);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex342(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(343);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex343(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(344);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex344(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(345);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex345(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(346);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex346(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(347);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex347(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(348);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex348(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(349);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex349(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(350);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex350(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(351);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex351(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(352);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex352(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 9 || ch == 10 || ch == 12 || ch == 13 || ch == 32) {
                nextStates.set(353);
            } else if (ch == 45 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(352);
            } else if (ch == 123) {
                nextStates.set(19);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex353(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 9 || ch == 10 || ch == 12 || ch == 13 || ch == 32) {
                nextStates.set(353);
            } else if (ch == 123) {
                nextStates.set(19);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex354(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(20);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex355(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(356);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex356(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(357);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex357(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(21);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex358(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(359);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex359(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(360);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex360(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(361);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex361(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(362);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex362(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(363);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex363(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(364);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex364(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(365);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex365(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(366);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex366(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(367);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex367(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(368);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex368(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(22);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex369(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(370);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex370(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(371);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex371(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(372);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex372(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(373);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex373(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(374);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex374(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(375);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex375(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(376);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex376(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(377);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex377(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(378);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex378(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(379);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex379(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(380);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex380(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(381);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex381(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(382);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex382(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(383);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex383(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(384);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex384(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(23);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex385(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(386);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex386(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 113) {
                nextStates.set(387);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex387(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(388);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex388(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(389);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex389(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(390);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex390(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(391);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex391(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(392);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex392(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(24);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex393(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(394);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex394(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(395);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex395(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(396);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex396(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(397);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex397(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(398);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex398(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(399);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex399(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(25);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex400(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(401);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex401(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(402);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex402(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(403);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex403(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(26);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex404(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(405);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex405(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(406);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex406(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(407);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex407(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(408);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex408(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(409);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex409(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(410);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex410(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(411);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex411(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(27);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex412(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(413);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex413(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(414);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex414(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(28);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex415(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(416);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex416(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(417);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex417(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(418);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex418(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(30);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex419(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(420);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex420(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(421);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex421(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(422);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex422(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(423);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex423(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(424);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex424(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(425);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex425(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(426);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex426(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(427);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex427(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(428);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex428(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(429);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex429(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(430);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex430(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(431);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex431(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(432);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex432(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(433);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex433(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(434);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex434(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(435);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex435(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(436);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex436(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(437);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex437(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(31);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex438(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(439);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex439(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(32);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex440(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(441);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex441(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(442);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex442(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(443);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex443(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(33);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex444(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(445);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex445(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(446);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex446(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(447);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex447(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(448);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex448(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(449);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex449(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(34);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex450(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(451);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex451(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(452);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex452(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(453);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex453(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(454);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex454(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(455);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex455(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(456);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex456(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(457);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex457(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(458);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex458(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(459);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex459(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(460);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex460(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(461);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex461(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(462);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex462(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(463);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex463(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(35);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex464(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(465);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex465(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(466);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex466(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(467);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex467(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(468);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex468(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(469);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex469(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(470);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex470(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(471);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex471(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(472);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex472(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(473);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex473(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(474);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex474(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(475);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex475(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(476);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex476(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(477);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex477(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(478);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex478(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(479);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex479(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(480);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex480(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(481);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex481(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(482);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex482(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(483);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex483(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(484);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex484(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(485);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex485(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(486);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex486(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(487);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex487(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(488);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex488(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(489);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex489(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(490);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex490(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(37);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex491(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(492);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex492(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(493);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex493(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(494);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex494(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(495);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex495(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 9 || ch == 10 || ch == 12 || ch == 13 || ch == 32) {
                nextStates.set(495);
            } else if (ch == 123) {
                nextStates.set(496);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex496(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 10 || ch == 32) {
                nextStates.set(496);
            } else if (ch == 123) {
                nextStates.set(497);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex497(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(497);
            } else if (ch == 123) {
                nextStates.set(498);
            } else if (ch == 125) {
                nextStates.set(38);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex498(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(498);
            } else if (ch == 123) {
                nextStates.set(499);
            } else if (ch == 125) {
                nextStates.set(497);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex499(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(500);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex500(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(500);
            } else if (ch == 125) {
                nextStates.set(498);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex501(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(502);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex502(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(503);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex503(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(504);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex504(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(505);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex505(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(506);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex506(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(40);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex507(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(508);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex508(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(509);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex509(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(510);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex510(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(511);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex511(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(512);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex512(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(513);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex513(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(514);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex514(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(515);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex515(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(516);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex516(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(517);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex517(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(518);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex518(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(519);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex519(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(520);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex520(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(521);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex521(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(522);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex522(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(523);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex523(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(41);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex524(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(525);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex525(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(526);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex526(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(527);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex527(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(528);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex528(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(529);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex529(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(530);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex530(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(42);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex531(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(532);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex532(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(533);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex533(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(534);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex534(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(535);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex535(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(536);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex536(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(537);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex537(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(538);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex538(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(43);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex539(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(540);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex540(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(541);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex541(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(542);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex542(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(543);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex543(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(544);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex544(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(545);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex545(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(546);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex546(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(44);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex547(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(548);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex548(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(549);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex549(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(550);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex550(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(551);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex551(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(552);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex552(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(553);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex553(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(47);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex554(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(555);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex555(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(556);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex556(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(557);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex557(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(558);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex558(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(559);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex559(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(560);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex560(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(561);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex561(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(48);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex562(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(563);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex563(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(564);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex564(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(565);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex565(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(566);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex566(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(567);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex567(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(568);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex568(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(50);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex569(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(570);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex570(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(571);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex571(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(572);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex572(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(573);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex573(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(574);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex574(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(575);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex575(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(576);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex576(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(577);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex577(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(578);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex578(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(579);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex579(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(580);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex580(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(581);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex581(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(51);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex582(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(583);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex583(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(584);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex584(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(585);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex585(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(586);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex586(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(53);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex587(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(588);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex588(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(589);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex589(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(590);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex590(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(591);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex591(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(592);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex592(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(593);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex593(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(594);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex594(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(595);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex595(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(54);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex596(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(597);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex597(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 106) {
                nextStates.set(598);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex598(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(599);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex599(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(600);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex600(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(601);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex601(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(602);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex602(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(603);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex603(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(604);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex604(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(605);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex605(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(606);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex606(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(55);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex607(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(608);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex608(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(609);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex609(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(610);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex610(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(611);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex611(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(612);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex612(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(613);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex613(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(614);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex614(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(615);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex615(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(616);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex616(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(617);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex617(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(618);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex618(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(619);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex619(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(620);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex620(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(621);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex621(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(622);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex622(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(623);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex623(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(624);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex624(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(625);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex625(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(56);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex626(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(627);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex627(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(628);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex628(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(629);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex629(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(630);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex630(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(631);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex631(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(632);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex632(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(633);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex633(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(634);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex634(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(57);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex635(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(636);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex636(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(637);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex637(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(58);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex638(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(639);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex639(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(640);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex640(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(641);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex641(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(642);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex642(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(643);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex643(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(644);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex644(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(645);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex645(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(59);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex646(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(647);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex647(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(648);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex648(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(649);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex649(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(650);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex650(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(60);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex651(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(652);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex652(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(61);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex653(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(654);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex654(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(655);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex655(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(656);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex656(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(657);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex657(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(658);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex658(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(659);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex659(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(62);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex660(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(661);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex661(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(662);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex662(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(663);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex663(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(664);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex664(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(665);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex665(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(665);
            } else if (ch == 34) {
                nextStates.set(666);
            } else if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(63);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex666(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(666);
            } else if (ch == 34) {
                nextStates.set(66);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex667(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(668);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex668(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(669);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex669(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(670);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex670(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(671);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex671(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(67);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex672(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(673);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex673(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(674);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex674(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(675);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex675(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(676);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex676(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(676);
            } else if (ch == 34) {
                nextStates.set(677);
            } else if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(68);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex677(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(677);
            } else if (ch == 34) {
                nextStates.set(69);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex678(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(679);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex679(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(680);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex680(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(681);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex681(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(682);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex682(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(683);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex683(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(684);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex684(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 122) {
                nextStates.set(685);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex685(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(686);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex686(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(72);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex687(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(688);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex688(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(689);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex689(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(690);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex690(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(691);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex691(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(692);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex692(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(693);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex693(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(694);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex694(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(695);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex695(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(696);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex696(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(73);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex697(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(698);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex698(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(699);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex699(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(700);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex700(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(701);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex701(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(702);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex702(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(703);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex703(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(704);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex704(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(705);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex705(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(706);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex706(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(707);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex707(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(708);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex708(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(709);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex709(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(74);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex710(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(711);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex711(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(712);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex712(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(75);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex713(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(714);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex714(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(76);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex715(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(716);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex716(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(717);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex717(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(718);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex718(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(719);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex719(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(720);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex720(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(721);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex721(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(77);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex722(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(723);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex723(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(724);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex724(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(725);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex725(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(726);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex726(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(727);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex727(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(728);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex728(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(729);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex729(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(730);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex730(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(731);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex731(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(732);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex732(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(733);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex733(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(734);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex734(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(735);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex735(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(736);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex736(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(737);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex737(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(738);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex738(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(739);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex739(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(740);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex740(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(741);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex741(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(742);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex742(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(743);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex743(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(744);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex744(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(745);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex745(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(746);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex746(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(747);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex747(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(78);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex748(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(749);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex749(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(750);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex750(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(751);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex751(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(752);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex752(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(753);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex753(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(754);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex754(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(80);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex755(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(756);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex756(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(757);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex757(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(758);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex758(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(759);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex759(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(760);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex760(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(761);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex761(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(81);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex762(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(763);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex763(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(764);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex764(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(765);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex765(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(766);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex766(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(767);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex767(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 40) {
                nextStates.set(82);
            } else if (ch == 60) {
                nextStates.set(768);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex768(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 59 || ch == 61 || ch >= 63) {
                nextStates.set(769);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex769(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 59 || ch == 61 || ch >= 63) {
                nextStates.set(769);
            } else if (ch == 62) {
                nextStates.set(770);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex770(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 40) {
                nextStates.set(82);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex771(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(772);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex772(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(773);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex773(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(774);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex774(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(775);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex775(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(776);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex776(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(83);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex777(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(778);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex778(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(779);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex779(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(780);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex780(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(781);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex781(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(782);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex782(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(783);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex783(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(784);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex784(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(785);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex785(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(786);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex786(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(787);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex787(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(788);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex788(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(789);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex789(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(790);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex790(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(791);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex791(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(792);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex792(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(793);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex793(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(794);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex794(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(795);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex795(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(84);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex796(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(797);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex797(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(798);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex798(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(85);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex799(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(800);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex800(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(801);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex801(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(86);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex802(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(803);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex803(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(804);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex804(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(805);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex805(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(806);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex806(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(807);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex807(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(808);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex808(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(809);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex809(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(810);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex810(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(811);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex811(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(812);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex812(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 54) {
                nextStates.set(813);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex813(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 52) {
                nextStates.set(814);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex814(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(815);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex815(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(816);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex816(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(817);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex817(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(818);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex818(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(819);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex819(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(820);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex820(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(821);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex821(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(822);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex822(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(823);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex823(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(87);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex824(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(825);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex825(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(826);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex826(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(827);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex827(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(828);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex828(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(829);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex829(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(830);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex830(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(831);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex831(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(832);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex832(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(833);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex833(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(834);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex834(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(835);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex835(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(836);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex836(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(837);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex837(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(838);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex838(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(839);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex839(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(89);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex840(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(90);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex841(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(842);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex842(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 46) {
                nextStates.set(91);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(842);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex843(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(844);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex844(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(845);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex845(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(846);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex846(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(847);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex847(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(848);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex848(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(849);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex849(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(850);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex850(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(851);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex851(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(852);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex852(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(853);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex853(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(92);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex854(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(855);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex855(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(856);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex856(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(857);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex857(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(93);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex858(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(94);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex859(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(860);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex860(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(861);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex861(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(862);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex862(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(863);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex863(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(864);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex864(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(865);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex865(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(866);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex866(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(95);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex867(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(868);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex868(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(869);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex869(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(870);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex870(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(871);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex871(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(872);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex872(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(873);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex873(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(874);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex874(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(875);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex875(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(876);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex876(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(877);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex877(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(878);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex878(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(879);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex879(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(880);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex880(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(881);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex881(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(882);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex882(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(883);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex883(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(884);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex884(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(885);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex885(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(96);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex886(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(887);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex887(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(888);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex888(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(889);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex889(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(890);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex890(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(891);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex891(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(892);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex892(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(97);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex893(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(894);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex894(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(895);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex895(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(896);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex896(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(897);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex897(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(898);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex898(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(899);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex899(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(900);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex900(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(901);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex901(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(98);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex902(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(903);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex903(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(904);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex904(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(905);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex905(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(906);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex906(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(907);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex907(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(99);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex908(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(909);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex909(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(910);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex910(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(911);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex911(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(912);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex912(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(913);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex913(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(914);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex914(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(915);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex915(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(916);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex916(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(917);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex917(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 122) {
                nextStates.set(918);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex918(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(919);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex919(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(100);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex920(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(921);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex921(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(922);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex922(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(923);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex923(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(101);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex924(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(925);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex925(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(926);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex926(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(927);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex927(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(928);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex928(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(929);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex929(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(930);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex930(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(931);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex931(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(932);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex932(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(102);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex933(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(934);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex934(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(935);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex935(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(103);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex936(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(937);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex937(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(938);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex938(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(939);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex939(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(104);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex940(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(941);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex941(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(942);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex942(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(943);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex943(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(944);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex944(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(945);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex945(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(105);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex946(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(947);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex947(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(948);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex948(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(949);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex949(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(950);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex950(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(951);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex951(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(952);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex952(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 122) {
                nextStates.set(106);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex953(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(954);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex954(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(955);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex955(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(107);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex956(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(957);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex957(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(958);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex958(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(959);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex959(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(960);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex960(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(961);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex961(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(962);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex962(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(963);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex963(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(964);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex964(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(965);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex965(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(966);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex966(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(967);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex967(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(968);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex968(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(108);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex969(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(970);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex970(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(971);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex971(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(972);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex972(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(109);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex973(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(974);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex974(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(975);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex975(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(976);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex976(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(977);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex977(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(978);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex978(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(979);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex979(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(980);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex980(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(110);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex981(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(982);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex982(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(983);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex983(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(984);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex984(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(111);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex985(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(986);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex986(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(987);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex987(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(988);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex988(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(989);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex989(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(990);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex990(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(991);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex991(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(992);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex992(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(993);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex993(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(994);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex994(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(995);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex995(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(996);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex996(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(997);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex997(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(998);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex998(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(999);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex999(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1000);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1000(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(1001);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1001(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1002);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1002(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1003);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1003(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1004);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1004(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(112);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1005(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1006);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1006(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1007);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1007(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(113);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1008(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1009);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1009(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1010);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1010(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(1011);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1011(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1012);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1012(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1013);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1013(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1014);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1014(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(1015);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1015(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1016);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1016(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 50) {
                nextStates.set(114);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1017(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1018);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1018(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(115);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1019(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1020);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1020(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1021);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1021(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1022);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1022(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1023);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1023(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1024);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1024(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1025);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1025(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1026);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1026(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1027);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1027(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1028);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1028(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1029);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1029(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1030);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1030(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1031);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1031(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1032);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1032(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1033);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1033(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1034);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1034(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1035);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1035(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(116);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1036(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1037);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1037(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1038);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1038(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1039);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1039(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1040);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1040(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1041);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1041(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1042);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1042(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(117);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1043(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1044);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1044(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1045);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1045(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1046);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1046(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1047);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1047(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(1048);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1048(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1049);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1049(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1050);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1050(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1051);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1051(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1052);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1052(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(118);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1053(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1054);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1054(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(119);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1055(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1056);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1056(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1057);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1057(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1058);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1058(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1059);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1059(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1060);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1060(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1061);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1061(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1062);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1062(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1063);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1063(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1064);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1064(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1065);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1065(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1066);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1066(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1067);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1067(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1068);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1068(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1069);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1069(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1070);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1070(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1071);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1071(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1072);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1072(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1073);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1073(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(1074);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1074(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1075);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1075(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(120);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1076(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1077);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1077(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1078);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1078(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1079);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1079(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1080);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1080(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1081);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1081(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(121);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1082(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1083);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1083(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1084);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1084(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1085);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1085(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1086);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1086(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(1086);
            } else if (ch == 58) {
                nextStates.set(1087);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1087(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(1087);
            } else if (ch == 123) {
                nextStates.set(123);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1088(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(1088);
            } else if (ch == 123) {
                nextStates.set(1089);
            } else if (ch == 125) {
                nextStates.set(123);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1089(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(1090);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1090(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(1090);
            } else if (ch == 125) {
                nextStates.set(1088);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1091(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1092);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1092(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1093);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1093(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1094);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1094(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(125);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1095(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1096);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1096(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1097);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1097(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1098);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1098(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1099);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1099(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1100);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1100(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(126);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1101(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1102);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1102(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1103);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1103(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1104);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1104(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1105);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1105(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1106);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1106(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1107);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1107(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1108);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1108(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(127);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1109(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1110);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1110(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1111);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1111(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(128);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1112(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(129);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1113(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1114);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1114(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1115);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1115(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1116);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1116(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1117);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1117(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1118);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1118(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(1119);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1119(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1120);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1120(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1121);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1121(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1122);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1122(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1123);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1123(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1124);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1124(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1125);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1125(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1126);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1126(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1127);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1127(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1128);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1128(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 9 || ch == 10 || ch == 12 || ch == 13 || ch == 32) {
                nextStates.set(1128);
            } else if (ch == 123) {
                nextStates.set(130);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1129(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1130);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1130(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1131);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1131(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1132);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1132(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1133);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1133(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1134);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1134(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(131);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1135(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1136);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1136(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1137);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1137(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1138);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1138(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1139);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1139(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1140);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1140(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1141);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1141(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1142);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1142(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1143);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1143(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(132);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1144(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1145);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1145(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1146);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1146(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1147);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1147(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(133);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1148(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1149);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1149(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1150);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1150(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1151);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1151(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(1152);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1152(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1153);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1153(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1154);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1154(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1155);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1155(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1156);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1156(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1157);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1157(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1158);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1158(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1159);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1159(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(134);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1160(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1161);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1161(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1162);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1162(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1163);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1163(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1164);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1164(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1165);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1165(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(136);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1166(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1167);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1167(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(1168);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1168(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1169);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1169(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(137);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1170(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1171);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1171(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1172);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1172(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(138);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1173(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(1174);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1174(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1175);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1175(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1176);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1176(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1177);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1177(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1178);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1178(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1179);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1179(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(139);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1180(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1181);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1181(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1182);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1182(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1183);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1183(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1184);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1184(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1185);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1185(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1186);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1186(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1187);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1187(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1188);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1188(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1189);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1189(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1190);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1190(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1191);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1191(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1192);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1192(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1193);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1193(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1194);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1194(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1195);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1195(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1196);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1196(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1197);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1197(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1198);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1198(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(141);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1199(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1200);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1200(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1201);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1201(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1202);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1202(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1203);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1203(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1204);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1204(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1205);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1205(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1206);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1206(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1207);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1207(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1208);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1208(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1209);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1209(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1210);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1210(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(1211);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1211(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1212);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1212(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1213);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1213(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1214);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1214(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1215);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1215(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1216);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1216(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1217);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1217(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1218);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1218(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1219);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1219(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1220);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1220(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1221);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1221(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1222);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1222(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1223);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1223(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1224);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1224(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(142);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1225(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(79);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1226(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1227);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1227(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1228);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1228(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1229);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1229(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1230);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1230(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1231);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1231(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(1232);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1232(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1233);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1233(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(143);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1234(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(1235);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1235(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1236);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1236(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1237);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1237(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1238);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1238(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(144);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1239(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1240);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1240(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1241);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1241(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1242);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1242(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(145);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1243(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1244);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1244(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1245);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1245(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(1246);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1246(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1247);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1247(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1248);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1248(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1249);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1249(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1250);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1250(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1251);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1251(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1252);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1252(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(146);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1253(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1254);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1254(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1255);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1255(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1256);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1256(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1257);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1257(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1258);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1258(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1259);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1259(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1260);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1260(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1261);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1261(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1262);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1262(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1263);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1263(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1264);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1264(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1265);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1265(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1266);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1266(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1267);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1267(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1268);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1268(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1269);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1269(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1270);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1270(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1271);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1271(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(147);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1272(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1273);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1273(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(148);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1274(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1275);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1275(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1276);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1276(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(1277);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1277(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1278);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1278(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1279);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1279(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1280);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1280(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1281);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1281(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1282);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1282(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1283);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1283(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(149);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1284(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1285);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1285(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1286);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1286(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1287);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1287(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1288);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1288(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1289);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1289(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1290);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1290(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(150);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1291(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1292);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1292(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1293);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1293(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1294);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1294(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1295);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1295(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1296);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1296(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1297);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1297(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1298);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1298(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(151);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1299(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(1300);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1300(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1301);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1301(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1302);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1302(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1303);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1303(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1304);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1304(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1305);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1305(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1306);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1306(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1307);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1307(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(152);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1308(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(1308);
            } else if (ch == 123) {
                nextStates.set(1309);
            } else if (ch == 125) {
                nextStates.set(154);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1309(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(1310);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1310(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(1310);
            } else if (ch == 125) {
                nextStates.set(1308);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1311(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1312);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1312(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(1313);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1313(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1314);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1314(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1315);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1315(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1316);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1316(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(1317);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1317(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1318);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1318(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1319);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1319(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1320);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1320(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1321);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1321(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1322);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1322(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1323);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1323(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(1324);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1324(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(155);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1325(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1326);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1326(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1327);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1327(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(1328);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1328(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1329);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1329(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1330);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1330(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1331);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1331(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1332);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1332(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1333);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1333(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(156);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1334(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1335);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1335(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(1336);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1336(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(157);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1337(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1338);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1338(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1339);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1339(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(158);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1340(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1341);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1341(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1342);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1342(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1343);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1343(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1344);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1344(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1345);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1345(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1346);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1346(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1347);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1347(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(1348);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1348(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1349);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1349(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1350);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1350(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1351);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1351(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1352);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1352(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(159);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1353(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1354);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1354(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1355);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1355(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1356);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1356(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1357);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1357(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1358);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1358(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1359);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1359(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(160);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1360(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1361);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1361(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(161);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1362(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1363);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1363(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1364);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1364(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1365);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1365(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(162);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1366(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1367);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1367(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1368);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1368(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1369);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1369(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1370);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1370(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(163);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1371(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1372);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1372(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1373);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1373(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(1374);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1374(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1375);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1375(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1376);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1376(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1377);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1377(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1378);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1378(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1379);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1379(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1380);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1380(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1381);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1381(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1382);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1382(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1383);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1383(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 9 || ch == 10 || ch == 12 || ch == 13 || ch == 32) {
                nextStates.set(1383);
            } else if (ch == 123) {
                nextStates.set(164);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1384(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1385);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1385(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1386);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1386(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1387);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1387(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1388);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1388(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1389);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1389(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1390);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1390(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1391);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1391(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1392);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1392(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1393);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1393(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(165);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1394(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1395);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1395(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(166);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1396(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1397);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1397(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1398);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1398(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1399);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1399(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1400);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1400(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1401);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1401(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1402);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1402(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1403);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1403(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1404);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1404(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1405);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1405(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1406);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1406(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1407);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1407(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1408);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1408(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(167);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1409(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1410);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1410(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1411);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1411(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1412);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1412(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1413);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1413(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1414);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1414(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(168);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1415(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1416);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1416(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1417);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1417(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1418);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1418(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(169);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1419(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(1420);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1420(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1421);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1421(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1422);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1422(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1423);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1423(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1424);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1424(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1425);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1425(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1426);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1426(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1427);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1427(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1428);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1428(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1429);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1429(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1430);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1430(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(170);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1431(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1432);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1432(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(1433);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1433(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1434);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1434(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1435);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1435(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1436);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1436(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1437);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1437(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(1438);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1438(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(171);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1439(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(1440);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1440(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1441);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1441(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1442);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1442(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1443);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1443(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1444);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1444(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(172);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1445(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1446);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1446(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1447);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1447(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1448);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1448(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(173);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1449(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1450);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1450(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1451);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1451(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1452);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1452(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1453);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1453(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1454);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1454(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1455);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1455(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1456);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1456(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1457);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1457(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1458);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1458(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1459);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1459(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1460);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1460(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1461);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1461(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1462);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1462(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(1463);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1463(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1464);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1464(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1465);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1465(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1466);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1466(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1467);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1467(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(174);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1468(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1469);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1469(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1470);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1470(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(1471);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1471(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1472);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1472(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1473);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1473(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(1474);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1474(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(176);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1475(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1476);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1476(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1477);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1477(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(1478);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1478(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1479);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1479(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(177);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1480(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1481);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1481(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1482);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1482(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(1483);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1483(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1484);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1484(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(1485);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1485(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1486);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1486(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1487);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1487(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1488);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1488(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1489);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1489(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1490);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1490(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1491);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1491(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1492);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1492(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1493);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1493(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(1494);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1494(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1495);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1495(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1496);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1496(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1497);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1497(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1498);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1498(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1499);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1499(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1500);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1500(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1501);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1501(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1502);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1502(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1503);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1503(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1504);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1504(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1505);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1505(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1506);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1506(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1507);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1507(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(178);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1508(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1509);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1509(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1510);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1510(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1511);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1511(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1512);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1512(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1513);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1513(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1514);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1514(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1515);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1515(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1516);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1516(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1517);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1517(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1518);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1518(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1519);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1519(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1520);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1520(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(179);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1521(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1522);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1522(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1523);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1523(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1524);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1524(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1525);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1525(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1526);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1526(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1527);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1527(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1528);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1528(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(1529);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1529(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(181);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1530(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1531);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1531(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(184);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1532(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1533);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1533(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1534);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1534(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1535);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1535(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(185);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1536(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1537);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1537(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1538);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1538(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1539);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1539(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1540);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1540(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1541);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1541(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1542);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1542(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1543);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1543(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1544);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1544(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1545);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1545(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1546);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1546(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1547);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1547(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1548);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1548(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(186);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1549(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1550);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1550(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1551);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1551(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1552);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1552(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1553);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1553(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1554);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1554(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1555);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1555(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1556);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1556(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(187);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1557(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1558);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1558(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1559);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1559(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1560);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1560(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1561);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1561(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(188);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1562(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1563);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1563(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(1564);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1564(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1565);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1565(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1566);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1566(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1567);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1567(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1568);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1568(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1569);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1569(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1570);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1570(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1571);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1571(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(189);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1572(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1573);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1573(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1574);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1574(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(190);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1575(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(191);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1576(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1577);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1577(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1578);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1578(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1579);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1579(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1580);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1580(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1581);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1581(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(192);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1582(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(1583);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1583(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(193);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1584(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1585);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1585(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1586);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1586(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(195);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1587(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1588);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1588(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1589);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1589(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1590);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1590(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1591);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1591(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(196);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1592(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1593);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1593(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(1594);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1594(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1595);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1595(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1596);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1596(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1597);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1597(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1598);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1598(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1599);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1599(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1600);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1600(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1601);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1601(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1602);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1602(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1603);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1603(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1604);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1604(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(1605);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1605(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1606);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1606(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1607);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1607(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1608);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1608(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(197);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1609(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1610);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1610(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1611);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1611(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1612);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1612(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1613);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1613(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1614);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1614(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1615);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1615(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1616);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1616(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1617);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1617(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1618);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1618(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1619);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1619(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1620);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1620(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1621);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1621(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(198);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1622(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1623);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1623(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1624);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1624(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(1625);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1625(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(199);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1626(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1627);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1627(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1628);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1628(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(200);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1629(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1630);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1630(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1631);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1631(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1632);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1632(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(1633);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1633(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1634);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1634(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1635);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1635(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1636);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1636(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1637);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1637(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1638);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1638(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1639);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1639(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1640);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1640(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(201);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1641(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1642);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1642(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1643);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1643(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1644);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1644(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(1645);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1645(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1646);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1646(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1647);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1647(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1648);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1648(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1649);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1649(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1650);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1650(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1651);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1651(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1652);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1652(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(202);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1653(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1654);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1654(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1655);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1655(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1656);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1656(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1657);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1657(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(203);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1658(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1659);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1659(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1660);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1660(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1661);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1661(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1662);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1662(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1663);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1663(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1664);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1664(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1665);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1665(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1666);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1666(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1667);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1667(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1668);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1668(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1669);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1669(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1670);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1670(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1671);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1671(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1672);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1672(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1673);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1673(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1674);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1674(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1675);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1675(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1676);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1676(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1677);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1677(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(205);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1678(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1679);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1679(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1680);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1680(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1681);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1681(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(206);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1682(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1683);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1683(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1684);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1684(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1685);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1685(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1686);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1686(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1687);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1687(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1688);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1688(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1689);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1689(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1690);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1690(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1691);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1691(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1692);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1692(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1693);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1693(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1694);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1694(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(207);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1695(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1696);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1696(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1697);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1697(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(208);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1698(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1699);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1699(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1700);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1700(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1701);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1701(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1702);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1702(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(1703);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1703(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1704);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1704(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(209);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1705(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1706);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1706(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1707);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1707(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1708);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1708(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1709);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1709(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1710);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1710(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1711);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1711(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1712);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1712(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1713);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1713(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1714);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1714(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1715);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1715(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1716);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1716(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1717);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1717(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1718);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1718(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(210);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1719(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(1720);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1720(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1721);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1721(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1722);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1722(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1723);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1723(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1724);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1724(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1725);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1725(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1726);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1726(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1727);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1727(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1728);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1728(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1729);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1729(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1730);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1730(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1731);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1731(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1732);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1732(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(211);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1733(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1734);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1734(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(1735);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1735(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(212);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1736(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1737);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1737(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1738);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1738(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1739);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1739(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1740);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1740(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1741);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1741(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(1742);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1742(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1743);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1743(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1744);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1744(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1745);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1745(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1746);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1746(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1747);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1747(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1748);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1748(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1749);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1749(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1750);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1750(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(215);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1751(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1752);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1752(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(1753);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1753(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1754);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1754(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(217);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1755(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1756);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1756(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1757);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1757(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(218);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1758(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1759);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1759(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1760);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1760(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(1761);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1761(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1762);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1762(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1763);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1763(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1764);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1764(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1765);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1765(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1766);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1766(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1767);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1767(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1768);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1768(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1769);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1769(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(219);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1770(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1771);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1771(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(1772);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1772(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1773);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1773(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1774);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1774(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1775);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1775(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1776);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1776(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(221);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1777(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1778);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1778(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1779);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1779(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(1780);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1780(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1781);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1781(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1782);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1782(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1783);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1783(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1784);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1784(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1785);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1785(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1786);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1786(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1787);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1787(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1788);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1788(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1789);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1789(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1790);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1790(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(1791);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1791(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1792);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1792(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1793);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1793(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(1794);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1794(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 106) {
                nextStates.set(1795);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1795(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1796);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1796(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1797);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1797(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1798);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1798(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(1799);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1799(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1800);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1800(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1801);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1801(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1802);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1802(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1803);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1803(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1804);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1804(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1805);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1805(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1806);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1806(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1807);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1807(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(222);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1808(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1809);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1809(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(223);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1810(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1811);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1811(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1812);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1812(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1813);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1813(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1814);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1814(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(1815);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1815(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(1816);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1816(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1817);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1817(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(1818);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1818(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1819);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1819(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1820);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1820(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1821);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1821(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1822);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1822(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1823);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1823(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(1824);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1824(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1825);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1825(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(1826);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1826(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(1827);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1827(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1828);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1828(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(1829);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1829(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(1830);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1830(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(1831);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1831(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(1832);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1832(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(1833);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1833(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(1834);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1834(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 9 || ch == 10 || ch == 12 || ch == 13 || ch == 32) {
                nextStates.set(1835);
            } else if (ch == 45 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(1834);
            } else if (ch == 123) {
                nextStates.set(224);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex1835(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 9 || ch == 10 || ch == 12 || ch == 13 || ch == 32) {
                nextStates.set(1835);
            } else if (ch == 123) {
                nextStates.set(224);
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            nfaFunctions = new NfaFunction[]{DEFAULT::getNfaIndex0, DEFAULT::getNfaIndex1, DEFAULT::getNfaIndex2, DEFAULT::getNfaIndex3, DEFAULT::getNfaIndex4, DEFAULT::getNfaIndex5, DEFAULT::getNfaIndex6, DEFAULT::getNfaIndex7, DEFAULT::getNfaIndex8, DEFAULT::getNfaIndex9, DEFAULT::getNfaIndex10, DEFAULT::getNfaIndex11, DEFAULT::getNfaIndex12, DEFAULT::getNfaIndex13, DEFAULT::getNfaIndex14, DEFAULT::getNfaIndex15, DEFAULT::getNfaIndex16, DEFAULT::getNfaIndex17, DEFAULT::getNfaIndex18, DEFAULT::getNfaIndex19, DEFAULT::getNfaIndex20, DEFAULT::getNfaIndex21, DEFAULT::getNfaIndex22, DEFAULT::getNfaIndex23, DEFAULT::getNfaIndex24, DEFAULT::getNfaIndex25, DEFAULT::getNfaIndex26, DEFAULT::getNfaIndex27, DEFAULT::getNfaIndex28, DEFAULT::getNfaIndex29, DEFAULT::getNfaIndex30, DEFAULT::getNfaIndex31, DEFAULT::getNfaIndex32, DEFAULT::getNfaIndex33, DEFAULT::getNfaIndex34, DEFAULT::getNfaIndex35, DEFAULT::getNfaIndex36, DEFAULT::getNfaIndex37, DEFAULT::getNfaIndex38, DEFAULT::getNfaIndex39, DEFAULT::getNfaIndex40, DEFAULT::getNfaIndex41, DEFAULT::getNfaIndex42, DEFAULT::getNfaIndex43, DEFAULT::getNfaIndex44, DEFAULT::getNfaIndex45, DEFAULT::getNfaIndex46, DEFAULT::getNfaIndex47, DEFAULT::getNfaIndex48, DEFAULT::getNfaIndex49, DEFAULT::getNfaIndex50, DEFAULT::getNfaIndex51, DEFAULT::getNfaIndex52, DEFAULT::getNfaIndex53, DEFAULT::getNfaIndex54, DEFAULT::getNfaIndex55, DEFAULT::getNfaIndex56, DEFAULT::getNfaIndex57, DEFAULT::getNfaIndex58, DEFAULT::getNfaIndex59, DEFAULT::getNfaIndex60, DEFAULT::getNfaIndex61, DEFAULT::getNfaIndex62, DEFAULT::getNfaIndex63, DEFAULT::getNfaIndex64, DEFAULT::getNfaIndex65, DEFAULT::getNfaIndex66, DEFAULT::getNfaIndex67, DEFAULT::getNfaIndex68, DEFAULT::getNfaIndex69, DEFAULT::getNfaIndex70, DEFAULT::getNfaIndex71, DEFAULT::getNfaIndex72, DEFAULT::getNfaIndex73, DEFAULT::getNfaIndex74, DEFAULT::getNfaIndex75, DEFAULT::getNfaIndex76, DEFAULT::getNfaIndex77, DEFAULT::getNfaIndex78, DEFAULT::getNfaIndex79, DEFAULT::getNfaIndex80, DEFAULT::getNfaIndex81, DEFAULT::getNfaIndex82, DEFAULT::getNfaIndex83, DEFAULT::getNfaIndex84, DEFAULT::getNfaIndex85, DEFAULT::getNfaIndex86, DEFAULT::getNfaIndex87, DEFAULT::getNfaIndex88, DEFAULT::getNfaIndex89, DEFAULT::getNfaIndex90, DEFAULT::getNfaIndex91, DEFAULT::getNfaIndex92, DEFAULT::getNfaIndex93, DEFAULT::getNfaIndex94, DEFAULT::getNfaIndex95, DEFAULT::getNfaIndex96, DEFAULT::getNfaIndex97, DEFAULT::getNfaIndex98, DEFAULT::getNfaIndex99, DEFAULT::getNfaIndex100, DEFAULT::getNfaIndex101, DEFAULT::getNfaIndex102, DEFAULT::getNfaIndex103, DEFAULT::getNfaIndex104, DEFAULT::getNfaIndex105, DEFAULT::getNfaIndex106, DEFAULT::getNfaIndex107, DEFAULT::getNfaIndex108, DEFAULT::getNfaIndex109, DEFAULT::getNfaIndex110, DEFAULT::getNfaIndex111, DEFAULT::getNfaIndex112, DEFAULT::getNfaIndex113, DEFAULT::getNfaIndex114, DEFAULT::getNfaIndex115, DEFAULT::getNfaIndex116, DEFAULT::getNfaIndex117, DEFAULT::getNfaIndex118, DEFAULT::getNfaIndex119, DEFAULT::getNfaIndex120, DEFAULT::getNfaIndex121, DEFAULT::getNfaIndex122, DEFAULT::getNfaIndex123, DEFAULT::getNfaIndex124, DEFAULT::getNfaIndex125, DEFAULT::getNfaIndex126, DEFAULT::getNfaIndex127, DEFAULT::getNfaIndex128, DEFAULT::getNfaIndex129, DEFAULT::getNfaIndex130, DEFAULT::getNfaIndex131, DEFAULT::getNfaIndex132, DEFAULT::getNfaIndex133, DEFAULT::getNfaIndex134, DEFAULT::getNfaIndex135, DEFAULT::getNfaIndex136, DEFAULT::getNfaIndex137, DEFAULT::getNfaIndex138, DEFAULT::getNfaIndex139, DEFAULT::getNfaIndex140, DEFAULT::getNfaIndex141, DEFAULT::getNfaIndex142, DEFAULT::getNfaIndex143, DEFAULT::getNfaIndex144, DEFAULT::getNfaIndex145, DEFAULT::getNfaIndex146, DEFAULT::getNfaIndex147, DEFAULT::getNfaIndex148, DEFAULT::getNfaIndex149, DEFAULT::getNfaIndex150, DEFAULT::getNfaIndex151, DEFAULT::getNfaIndex152, DEFAULT::getNfaIndex153, DEFAULT::getNfaIndex154, DEFAULT::getNfaIndex155, DEFAULT::getNfaIndex156, DEFAULT::getNfaIndex157, DEFAULT::getNfaIndex158, DEFAULT::getNfaIndex159, DEFAULT::getNfaIndex160, DEFAULT::getNfaIndex161, DEFAULT::getNfaIndex162, DEFAULT::getNfaIndex163, DEFAULT::getNfaIndex164, DEFAULT::getNfaIndex165, DEFAULT::getNfaIndex166, DEFAULT::getNfaIndex167, DEFAULT::getNfaIndex168, DEFAULT::getNfaIndex169, DEFAULT::getNfaIndex170, DEFAULT::getNfaIndex171, DEFAULT::getNfaIndex172, DEFAULT::getNfaIndex173, DEFAULT::getNfaIndex174, DEFAULT::getNfaIndex175, DEFAULT::getNfaIndex176, DEFAULT::getNfaIndex177, DEFAULT::getNfaIndex178, DEFAULT::getNfaIndex179, DEFAULT::getNfaIndex180, DEFAULT::getNfaIndex181, DEFAULT::getNfaIndex182, DEFAULT::getNfaIndex183, DEFAULT::getNfaIndex184, DEFAULT::getNfaIndex185, DEFAULT::getNfaIndex186, DEFAULT::getNfaIndex187, DEFAULT::getNfaIndex188, DEFAULT::getNfaIndex189, DEFAULT::getNfaIndex190, DEFAULT::getNfaIndex191, DEFAULT::getNfaIndex192, DEFAULT::getNfaIndex193, DEFAULT::getNfaIndex194, DEFAULT::getNfaIndex195, DEFAULT::getNfaIndex196, DEFAULT::getNfaIndex197, DEFAULT::getNfaIndex198, DEFAULT::getNfaIndex199, DEFAULT::getNfaIndex200, DEFAULT::getNfaIndex201, DEFAULT::getNfaIndex202, DEFAULT::getNfaIndex203, DEFAULT::getNfaIndex204, DEFAULT::getNfaIndex205, DEFAULT::getNfaIndex206, DEFAULT::getNfaIndex207, DEFAULT::getNfaIndex208, DEFAULT::getNfaIndex209, DEFAULT::getNfaIndex210, DEFAULT::getNfaIndex211, DEFAULT::getNfaIndex212, DEFAULT::getNfaIndex213, DEFAULT::getNfaIndex214, DEFAULT::getNfaIndex215, DEFAULT::getNfaIndex216, DEFAULT::getNfaIndex217, DEFAULT::getNfaIndex218, DEFAULT::getNfaIndex219, DEFAULT::getNfaIndex220, DEFAULT::getNfaIndex221, DEFAULT::getNfaIndex222, DEFAULT::getNfaIndex223, DEFAULT::getNfaIndex224, DEFAULT::getNfaIndex225, DEFAULT::getNfaIndex226, DEFAULT::getNfaIndex227, DEFAULT::getNfaIndex228, DEFAULT::getNfaIndex229, DEFAULT::getNfaIndex230, DEFAULT::getNfaIndex231, DEFAULT::getNfaIndex232, DEFAULT::getNfaIndex233, DEFAULT::getNfaIndex234, DEFAULT::getNfaIndex235, DEFAULT::getNfaIndex236, DEFAULT::getNfaIndex237, DEFAULT::getNfaIndex238, DEFAULT::getNfaIndex239, DEFAULT::getNfaIndex240, DEFAULT::getNfaIndex241, DEFAULT::getNfaIndex242, DEFAULT::getNfaIndex243, DEFAULT::getNfaIndex244, DEFAULT::getNfaIndex245, DEFAULT::getNfaIndex246, DEFAULT::getNfaIndex247, DEFAULT::getNfaIndex248, DEFAULT::getNfaIndex249, DEFAULT::getNfaIndex250, DEFAULT::getNfaIndex251, DEFAULT::getNfaIndex252, DEFAULT::getNfaIndex253, DEFAULT::getNfaIndex254, DEFAULT::getNfaIndex255, DEFAULT::getNfaIndex256, DEFAULT::getNfaIndex257, DEFAULT::getNfaIndex258, DEFAULT::getNfaIndex259, DEFAULT::getNfaIndex260, DEFAULT::getNfaIndex261, DEFAULT::getNfaIndex262, DEFAULT::getNfaIndex263, DEFAULT::getNfaIndex264, DEFAULT::getNfaIndex265, DEFAULT::getNfaIndex266, DEFAULT::getNfaIndex267, DEFAULT::getNfaIndex268, DEFAULT::getNfaIndex269, DEFAULT::getNfaIndex270, DEFAULT::getNfaIndex271, DEFAULT::getNfaIndex272, DEFAULT::getNfaIndex273, DEFAULT::getNfaIndex274, DEFAULT::getNfaIndex275, DEFAULT::getNfaIndex276, DEFAULT::getNfaIndex277, DEFAULT::getNfaIndex278, DEFAULT::getNfaIndex279, DEFAULT::getNfaIndex280, DEFAULT::getNfaIndex281, DEFAULT::getNfaIndex282, DEFAULT::getNfaIndex283, DEFAULT::getNfaIndex284, DEFAULT::getNfaIndex285, DEFAULT::getNfaIndex286, DEFAULT::getNfaIndex287, DEFAULT::getNfaIndex288, DEFAULT::getNfaIndex289, DEFAULT::getNfaIndex290, DEFAULT::getNfaIndex291, DEFAULT::getNfaIndex292, DEFAULT::getNfaIndex293, DEFAULT::getNfaIndex294, DEFAULT::getNfaIndex295, DEFAULT::getNfaIndex296, DEFAULT::getNfaIndex297, DEFAULT::getNfaIndex298, DEFAULT::getNfaIndex299, DEFAULT::getNfaIndex300, DEFAULT::getNfaIndex301, DEFAULT::getNfaIndex302, DEFAULT::getNfaIndex303, DEFAULT::getNfaIndex304, DEFAULT::getNfaIndex305, DEFAULT::getNfaIndex306, DEFAULT::getNfaIndex307, DEFAULT::getNfaIndex308, DEFAULT::getNfaIndex309, DEFAULT::getNfaIndex310, DEFAULT::getNfaIndex311, DEFAULT::getNfaIndex312, DEFAULT::getNfaIndex313, DEFAULT::getNfaIndex314, DEFAULT::getNfaIndex315, DEFAULT::getNfaIndex316, DEFAULT::getNfaIndex317, DEFAULT::getNfaIndex318, DEFAULT::getNfaIndex319, DEFAULT::getNfaIndex320, DEFAULT::getNfaIndex321, DEFAULT::getNfaIndex322, DEFAULT::getNfaIndex323, DEFAULT::getNfaIndex324, DEFAULT::getNfaIndex325, DEFAULT::getNfaIndex326, DEFAULT::getNfaIndex327, DEFAULT::getNfaIndex328, DEFAULT::getNfaIndex329, DEFAULT::getNfaIndex330, DEFAULT::getNfaIndex331, DEFAULT::getNfaIndex332, DEFAULT::getNfaIndex333, DEFAULT::getNfaIndex334, DEFAULT::getNfaIndex335, DEFAULT::getNfaIndex336, DEFAULT::getNfaIndex337, DEFAULT::getNfaIndex338, DEFAULT::getNfaIndex339, DEFAULT::getNfaIndex340, DEFAULT::getNfaIndex341, DEFAULT::getNfaIndex342, DEFAULT::getNfaIndex343, DEFAULT::getNfaIndex344, DEFAULT::getNfaIndex345, DEFAULT::getNfaIndex346, DEFAULT::getNfaIndex347, DEFAULT::getNfaIndex348, DEFAULT::getNfaIndex349, DEFAULT::getNfaIndex350, DEFAULT::getNfaIndex351, DEFAULT::getNfaIndex352, DEFAULT::getNfaIndex353, DEFAULT::getNfaIndex354, DEFAULT::getNfaIndex355, DEFAULT::getNfaIndex356, DEFAULT::getNfaIndex357, DEFAULT::getNfaIndex358, DEFAULT::getNfaIndex359, DEFAULT::getNfaIndex360, DEFAULT::getNfaIndex361, DEFAULT::getNfaIndex362, DEFAULT::getNfaIndex363, DEFAULT::getNfaIndex364, DEFAULT::getNfaIndex365, DEFAULT::getNfaIndex366, DEFAULT::getNfaIndex367, DEFAULT::getNfaIndex368, DEFAULT::getNfaIndex369, DEFAULT::getNfaIndex370, DEFAULT::getNfaIndex371, DEFAULT::getNfaIndex372, DEFAULT::getNfaIndex373, DEFAULT::getNfaIndex374, DEFAULT::getNfaIndex375, DEFAULT::getNfaIndex376, DEFAULT::getNfaIndex377, DEFAULT::getNfaIndex378, DEFAULT::getNfaIndex379, DEFAULT::getNfaIndex380, DEFAULT::getNfaIndex381, DEFAULT::getNfaIndex382, DEFAULT::getNfaIndex383, DEFAULT::getNfaIndex384, DEFAULT::getNfaIndex385, DEFAULT::getNfaIndex386, DEFAULT::getNfaIndex387, DEFAULT::getNfaIndex388, DEFAULT::getNfaIndex389, DEFAULT::getNfaIndex390, DEFAULT::getNfaIndex391, DEFAULT::getNfaIndex392, DEFAULT::getNfaIndex393, DEFAULT::getNfaIndex394, DEFAULT::getNfaIndex395, DEFAULT::getNfaIndex396, DEFAULT::getNfaIndex397, DEFAULT::getNfaIndex398, DEFAULT::getNfaIndex399, DEFAULT::getNfaIndex400, DEFAULT::getNfaIndex401, DEFAULT::getNfaIndex402, DEFAULT::getNfaIndex403, DEFAULT::getNfaIndex404, DEFAULT::getNfaIndex405, DEFAULT::getNfaIndex406, DEFAULT::getNfaIndex407, DEFAULT::getNfaIndex408, DEFAULT::getNfaIndex409, DEFAULT::getNfaIndex410, DEFAULT::getNfaIndex411, DEFAULT::getNfaIndex412, DEFAULT::getNfaIndex413, DEFAULT::getNfaIndex414, DEFAULT::getNfaIndex415, DEFAULT::getNfaIndex416, DEFAULT::getNfaIndex417, DEFAULT::getNfaIndex418, DEFAULT::getNfaIndex419, DEFAULT::getNfaIndex420, DEFAULT::getNfaIndex421, DEFAULT::getNfaIndex422, DEFAULT::getNfaIndex423, DEFAULT::getNfaIndex424, DEFAULT::getNfaIndex425, DEFAULT::getNfaIndex426, DEFAULT::getNfaIndex427, DEFAULT::getNfaIndex428, DEFAULT::getNfaIndex429, DEFAULT::getNfaIndex430, DEFAULT::getNfaIndex431, DEFAULT::getNfaIndex432, DEFAULT::getNfaIndex433, DEFAULT::getNfaIndex434, DEFAULT::getNfaIndex435, DEFAULT::getNfaIndex436, DEFAULT::getNfaIndex437, DEFAULT::getNfaIndex438, DEFAULT::getNfaIndex439, DEFAULT::getNfaIndex440, DEFAULT::getNfaIndex441, DEFAULT::getNfaIndex442, DEFAULT::getNfaIndex443, DEFAULT::getNfaIndex444, DEFAULT::getNfaIndex445, DEFAULT::getNfaIndex446, DEFAULT::getNfaIndex447, DEFAULT::getNfaIndex448, DEFAULT::getNfaIndex449, DEFAULT::getNfaIndex450, DEFAULT::getNfaIndex451, DEFAULT::getNfaIndex452, DEFAULT::getNfaIndex453, DEFAULT::getNfaIndex454, DEFAULT::getNfaIndex455, DEFAULT::getNfaIndex456, DEFAULT::getNfaIndex457, DEFAULT::getNfaIndex458, DEFAULT::getNfaIndex459, DEFAULT::getNfaIndex460, DEFAULT::getNfaIndex461, DEFAULT::getNfaIndex462, DEFAULT::getNfaIndex463, DEFAULT::getNfaIndex464, DEFAULT::getNfaIndex465, DEFAULT::getNfaIndex466, DEFAULT::getNfaIndex467, DEFAULT::getNfaIndex468, DEFAULT::getNfaIndex469, DEFAULT::getNfaIndex470, DEFAULT::getNfaIndex471, DEFAULT::getNfaIndex472, DEFAULT::getNfaIndex473, DEFAULT::getNfaIndex474, DEFAULT::getNfaIndex475, DEFAULT::getNfaIndex476, DEFAULT::getNfaIndex477, DEFAULT::getNfaIndex478, DEFAULT::getNfaIndex479, DEFAULT::getNfaIndex480, DEFAULT::getNfaIndex481, DEFAULT::getNfaIndex482, DEFAULT::getNfaIndex483, DEFAULT::getNfaIndex484, DEFAULT::getNfaIndex485, DEFAULT::getNfaIndex486, DEFAULT::getNfaIndex487, DEFAULT::getNfaIndex488, DEFAULT::getNfaIndex489, DEFAULT::getNfaIndex490, DEFAULT::getNfaIndex491, DEFAULT::getNfaIndex492, DEFAULT::getNfaIndex493, DEFAULT::getNfaIndex494, DEFAULT::getNfaIndex495, DEFAULT::getNfaIndex496, DEFAULT::getNfaIndex497, DEFAULT::getNfaIndex498, DEFAULT::getNfaIndex499, DEFAULT::getNfaIndex500, DEFAULT::getNfaIndex501, DEFAULT::getNfaIndex502, DEFAULT::getNfaIndex503, DEFAULT::getNfaIndex504, DEFAULT::getNfaIndex505, DEFAULT::getNfaIndex506, DEFAULT::getNfaIndex507, DEFAULT::getNfaIndex508, DEFAULT::getNfaIndex509, DEFAULT::getNfaIndex510, DEFAULT::getNfaIndex511, DEFAULT::getNfaIndex512, DEFAULT::getNfaIndex513, DEFAULT::getNfaIndex514, DEFAULT::getNfaIndex515, DEFAULT::getNfaIndex516, DEFAULT::getNfaIndex517, DEFAULT::getNfaIndex518, DEFAULT::getNfaIndex519, DEFAULT::getNfaIndex520, DEFAULT::getNfaIndex521, DEFAULT::getNfaIndex522, DEFAULT::getNfaIndex523, DEFAULT::getNfaIndex524, DEFAULT::getNfaIndex525, DEFAULT::getNfaIndex526, DEFAULT::getNfaIndex527, DEFAULT::getNfaIndex528, DEFAULT::getNfaIndex529, DEFAULT::getNfaIndex530, DEFAULT::getNfaIndex531, DEFAULT::getNfaIndex532, DEFAULT::getNfaIndex533, DEFAULT::getNfaIndex534, DEFAULT::getNfaIndex535, DEFAULT::getNfaIndex536, DEFAULT::getNfaIndex537, DEFAULT::getNfaIndex538, DEFAULT::getNfaIndex539, DEFAULT::getNfaIndex540, DEFAULT::getNfaIndex541, DEFAULT::getNfaIndex542, DEFAULT::getNfaIndex543, DEFAULT::getNfaIndex544, DEFAULT::getNfaIndex545, DEFAULT::getNfaIndex546, DEFAULT::getNfaIndex547, DEFAULT::getNfaIndex548, DEFAULT::getNfaIndex549, DEFAULT::getNfaIndex550, DEFAULT::getNfaIndex551, DEFAULT::getNfaIndex552, DEFAULT::getNfaIndex553, DEFAULT::getNfaIndex554, DEFAULT::getNfaIndex555, DEFAULT::getNfaIndex556, DEFAULT::getNfaIndex557, DEFAULT::getNfaIndex558, DEFAULT::getNfaIndex559, DEFAULT::getNfaIndex560, DEFAULT::getNfaIndex561, DEFAULT::getNfaIndex562, DEFAULT::getNfaIndex563, DEFAULT::getNfaIndex564, DEFAULT::getNfaIndex565, DEFAULT::getNfaIndex566, DEFAULT::getNfaIndex567, DEFAULT::getNfaIndex568, DEFAULT::getNfaIndex569, DEFAULT::getNfaIndex570, DEFAULT::getNfaIndex571, DEFAULT::getNfaIndex572, DEFAULT::getNfaIndex573, DEFAULT::getNfaIndex574, DEFAULT::getNfaIndex575, DEFAULT::getNfaIndex576, DEFAULT::getNfaIndex577, DEFAULT::getNfaIndex578, DEFAULT::getNfaIndex579, DEFAULT::getNfaIndex580, DEFAULT::getNfaIndex581, DEFAULT::getNfaIndex582, DEFAULT::getNfaIndex583, DEFAULT::getNfaIndex584, DEFAULT::getNfaIndex585, DEFAULT::getNfaIndex586, DEFAULT::getNfaIndex587, DEFAULT::getNfaIndex588, DEFAULT::getNfaIndex589, DEFAULT::getNfaIndex590, DEFAULT::getNfaIndex591, DEFAULT::getNfaIndex592, DEFAULT::getNfaIndex593, DEFAULT::getNfaIndex594, DEFAULT::getNfaIndex595, DEFAULT::getNfaIndex596, DEFAULT::getNfaIndex597, DEFAULT::getNfaIndex598, DEFAULT::getNfaIndex599, DEFAULT::getNfaIndex600, DEFAULT::getNfaIndex601, DEFAULT::getNfaIndex602, DEFAULT::getNfaIndex603, DEFAULT::getNfaIndex604, DEFAULT::getNfaIndex605, DEFAULT::getNfaIndex606, DEFAULT::getNfaIndex607, DEFAULT::getNfaIndex608, DEFAULT::getNfaIndex609, DEFAULT::getNfaIndex610, DEFAULT::getNfaIndex611, DEFAULT::getNfaIndex612, DEFAULT::getNfaIndex613, DEFAULT::getNfaIndex614, DEFAULT::getNfaIndex615, DEFAULT::getNfaIndex616, DEFAULT::getNfaIndex617, DEFAULT::getNfaIndex618, DEFAULT::getNfaIndex619, DEFAULT::getNfaIndex620, DEFAULT::getNfaIndex621, DEFAULT::getNfaIndex622, DEFAULT::getNfaIndex623, DEFAULT::getNfaIndex624, DEFAULT::getNfaIndex625, DEFAULT::getNfaIndex626, DEFAULT::getNfaIndex627, DEFAULT::getNfaIndex628, DEFAULT::getNfaIndex629, DEFAULT::getNfaIndex630, DEFAULT::getNfaIndex631, DEFAULT::getNfaIndex632, DEFAULT::getNfaIndex633, DEFAULT::getNfaIndex634, DEFAULT::getNfaIndex635, DEFAULT::getNfaIndex636, DEFAULT::getNfaIndex637, DEFAULT::getNfaIndex638, DEFAULT::getNfaIndex639, DEFAULT::getNfaIndex640, DEFAULT::getNfaIndex641, DEFAULT::getNfaIndex642, DEFAULT::getNfaIndex643, DEFAULT::getNfaIndex644, DEFAULT::getNfaIndex645, DEFAULT::getNfaIndex646, DEFAULT::getNfaIndex647, DEFAULT::getNfaIndex648, DEFAULT::getNfaIndex649, DEFAULT::getNfaIndex650, DEFAULT::getNfaIndex651, DEFAULT::getNfaIndex652, DEFAULT::getNfaIndex653, DEFAULT::getNfaIndex654, DEFAULT::getNfaIndex655, DEFAULT::getNfaIndex656, DEFAULT::getNfaIndex657, DEFAULT::getNfaIndex658, DEFAULT::getNfaIndex659, DEFAULT::getNfaIndex660, DEFAULT::getNfaIndex661, DEFAULT::getNfaIndex662, DEFAULT::getNfaIndex663, DEFAULT::getNfaIndex664, DEFAULT::getNfaIndex665, DEFAULT::getNfaIndex666, DEFAULT::getNfaIndex667, DEFAULT::getNfaIndex668, DEFAULT::getNfaIndex669, DEFAULT::getNfaIndex670, DEFAULT::getNfaIndex671, DEFAULT::getNfaIndex672, DEFAULT::getNfaIndex673, DEFAULT::getNfaIndex674, DEFAULT::getNfaIndex675, DEFAULT::getNfaIndex676, DEFAULT::getNfaIndex677, DEFAULT::getNfaIndex678, DEFAULT::getNfaIndex679, DEFAULT::getNfaIndex680, DEFAULT::getNfaIndex681, DEFAULT::getNfaIndex682, DEFAULT::getNfaIndex683, DEFAULT::getNfaIndex684, DEFAULT::getNfaIndex685, DEFAULT::getNfaIndex686, DEFAULT::getNfaIndex687, DEFAULT::getNfaIndex688, DEFAULT::getNfaIndex689, DEFAULT::getNfaIndex690, DEFAULT::getNfaIndex691, DEFAULT::getNfaIndex692, DEFAULT::getNfaIndex693, DEFAULT::getNfaIndex694, DEFAULT::getNfaIndex695, DEFAULT::getNfaIndex696, DEFAULT::getNfaIndex697, DEFAULT::getNfaIndex698, DEFAULT::getNfaIndex699, DEFAULT::getNfaIndex700, DEFAULT::getNfaIndex701, DEFAULT::getNfaIndex702, DEFAULT::getNfaIndex703, DEFAULT::getNfaIndex704, DEFAULT::getNfaIndex705, DEFAULT::getNfaIndex706, DEFAULT::getNfaIndex707, DEFAULT::getNfaIndex708, DEFAULT::getNfaIndex709, DEFAULT::getNfaIndex710, DEFAULT::getNfaIndex711, DEFAULT::getNfaIndex712, DEFAULT::getNfaIndex713, DEFAULT::getNfaIndex714, DEFAULT::getNfaIndex715, DEFAULT::getNfaIndex716, DEFAULT::getNfaIndex717, DEFAULT::getNfaIndex718, DEFAULT::getNfaIndex719, DEFAULT::getNfaIndex720, DEFAULT::getNfaIndex721, DEFAULT::getNfaIndex722, DEFAULT::getNfaIndex723, DEFAULT::getNfaIndex724, DEFAULT::getNfaIndex725, DEFAULT::getNfaIndex726, DEFAULT::getNfaIndex727, DEFAULT::getNfaIndex728, DEFAULT::getNfaIndex729, DEFAULT::getNfaIndex730, DEFAULT::getNfaIndex731, DEFAULT::getNfaIndex732, DEFAULT::getNfaIndex733, DEFAULT::getNfaIndex734, DEFAULT::getNfaIndex735, DEFAULT::getNfaIndex736, DEFAULT::getNfaIndex737, DEFAULT::getNfaIndex738, DEFAULT::getNfaIndex739, DEFAULT::getNfaIndex740, DEFAULT::getNfaIndex741, DEFAULT::getNfaIndex742, DEFAULT::getNfaIndex743, DEFAULT::getNfaIndex744, DEFAULT::getNfaIndex745, DEFAULT::getNfaIndex746, DEFAULT::getNfaIndex747, DEFAULT::getNfaIndex748, DEFAULT::getNfaIndex749, DEFAULT::getNfaIndex750, DEFAULT::getNfaIndex751, DEFAULT::getNfaIndex752, DEFAULT::getNfaIndex753, DEFAULT::getNfaIndex754, DEFAULT::getNfaIndex755, DEFAULT::getNfaIndex756, DEFAULT::getNfaIndex757, DEFAULT::getNfaIndex758, DEFAULT::getNfaIndex759, DEFAULT::getNfaIndex760, DEFAULT::getNfaIndex761, DEFAULT::getNfaIndex762, DEFAULT::getNfaIndex763, DEFAULT::getNfaIndex764, DEFAULT::getNfaIndex765, DEFAULT::getNfaIndex766, DEFAULT::getNfaIndex767, DEFAULT::getNfaIndex768, DEFAULT::getNfaIndex769, DEFAULT::getNfaIndex770, DEFAULT::getNfaIndex771, DEFAULT::getNfaIndex772, DEFAULT::getNfaIndex773, DEFAULT::getNfaIndex774, DEFAULT::getNfaIndex775, DEFAULT::getNfaIndex776, DEFAULT::getNfaIndex777, DEFAULT::getNfaIndex778, DEFAULT::getNfaIndex779, DEFAULT::getNfaIndex780, DEFAULT::getNfaIndex781, DEFAULT::getNfaIndex782, DEFAULT::getNfaIndex783, DEFAULT::getNfaIndex784, DEFAULT::getNfaIndex785, DEFAULT::getNfaIndex786, DEFAULT::getNfaIndex787, DEFAULT::getNfaIndex788, DEFAULT::getNfaIndex789, DEFAULT::getNfaIndex790, DEFAULT::getNfaIndex791, DEFAULT::getNfaIndex792, DEFAULT::getNfaIndex793, DEFAULT::getNfaIndex794, DEFAULT::getNfaIndex795, DEFAULT::getNfaIndex796, DEFAULT::getNfaIndex797, DEFAULT::getNfaIndex798, DEFAULT::getNfaIndex799, DEFAULT::getNfaIndex800, DEFAULT::getNfaIndex801, DEFAULT::getNfaIndex802, DEFAULT::getNfaIndex803, DEFAULT::getNfaIndex804, DEFAULT::getNfaIndex805, DEFAULT::getNfaIndex806, DEFAULT::getNfaIndex807, DEFAULT::getNfaIndex808, DEFAULT::getNfaIndex809, DEFAULT::getNfaIndex810, DEFAULT::getNfaIndex811, DEFAULT::getNfaIndex812, DEFAULT::getNfaIndex813, DEFAULT::getNfaIndex814, DEFAULT::getNfaIndex815, DEFAULT::getNfaIndex816, DEFAULT::getNfaIndex817, DEFAULT::getNfaIndex818, DEFAULT::getNfaIndex819, DEFAULT::getNfaIndex820, DEFAULT::getNfaIndex821, DEFAULT::getNfaIndex822, DEFAULT::getNfaIndex823, DEFAULT::getNfaIndex824, DEFAULT::getNfaIndex825, DEFAULT::getNfaIndex826, DEFAULT::getNfaIndex827, DEFAULT::getNfaIndex828, DEFAULT::getNfaIndex829, DEFAULT::getNfaIndex830, DEFAULT::getNfaIndex831, DEFAULT::getNfaIndex832, DEFAULT::getNfaIndex833, DEFAULT::getNfaIndex834, DEFAULT::getNfaIndex835, DEFAULT::getNfaIndex836, DEFAULT::getNfaIndex837, DEFAULT::getNfaIndex838, DEFAULT::getNfaIndex839, DEFAULT::getNfaIndex840, DEFAULT::getNfaIndex841, DEFAULT::getNfaIndex842, DEFAULT::getNfaIndex843, DEFAULT::getNfaIndex844, DEFAULT::getNfaIndex845, DEFAULT::getNfaIndex846, DEFAULT::getNfaIndex847, DEFAULT::getNfaIndex848, DEFAULT::getNfaIndex849, DEFAULT::getNfaIndex850, DEFAULT::getNfaIndex851, DEFAULT::getNfaIndex852, DEFAULT::getNfaIndex853, DEFAULT::getNfaIndex854, DEFAULT::getNfaIndex855, DEFAULT::getNfaIndex856, DEFAULT::getNfaIndex857, DEFAULT::getNfaIndex858, DEFAULT::getNfaIndex859, DEFAULT::getNfaIndex860, DEFAULT::getNfaIndex861, DEFAULT::getNfaIndex862, DEFAULT::getNfaIndex863, DEFAULT::getNfaIndex864, DEFAULT::getNfaIndex865, DEFAULT::getNfaIndex866, DEFAULT::getNfaIndex867, DEFAULT::getNfaIndex868, DEFAULT::getNfaIndex869, DEFAULT::getNfaIndex870, DEFAULT::getNfaIndex871, DEFAULT::getNfaIndex872, DEFAULT::getNfaIndex873, DEFAULT::getNfaIndex874, DEFAULT::getNfaIndex875, DEFAULT::getNfaIndex876, DEFAULT::getNfaIndex877, DEFAULT::getNfaIndex878, DEFAULT::getNfaIndex879, DEFAULT::getNfaIndex880, DEFAULT::getNfaIndex881, DEFAULT::getNfaIndex882, DEFAULT::getNfaIndex883, DEFAULT::getNfaIndex884, DEFAULT::getNfaIndex885, DEFAULT::getNfaIndex886, DEFAULT::getNfaIndex887, DEFAULT::getNfaIndex888, DEFAULT::getNfaIndex889, DEFAULT::getNfaIndex890, DEFAULT::getNfaIndex891, DEFAULT::getNfaIndex892, DEFAULT::getNfaIndex893, DEFAULT::getNfaIndex894, DEFAULT::getNfaIndex895, DEFAULT::getNfaIndex896, DEFAULT::getNfaIndex897, DEFAULT::getNfaIndex898, DEFAULT::getNfaIndex899, DEFAULT::getNfaIndex900, DEFAULT::getNfaIndex901, DEFAULT::getNfaIndex902, DEFAULT::getNfaIndex903, DEFAULT::getNfaIndex904, DEFAULT::getNfaIndex905, DEFAULT::getNfaIndex906, DEFAULT::getNfaIndex907, DEFAULT::getNfaIndex908, DEFAULT::getNfaIndex909, DEFAULT::getNfaIndex910, DEFAULT::getNfaIndex911, DEFAULT::getNfaIndex912, DEFAULT::getNfaIndex913, DEFAULT::getNfaIndex914, DEFAULT::getNfaIndex915, DEFAULT::getNfaIndex916, DEFAULT::getNfaIndex917, DEFAULT::getNfaIndex918, DEFAULT::getNfaIndex919, DEFAULT::getNfaIndex920, DEFAULT::getNfaIndex921, DEFAULT::getNfaIndex922, DEFAULT::getNfaIndex923, DEFAULT::getNfaIndex924, DEFAULT::getNfaIndex925, DEFAULT::getNfaIndex926, DEFAULT::getNfaIndex927, DEFAULT::getNfaIndex928, DEFAULT::getNfaIndex929, DEFAULT::getNfaIndex930, DEFAULT::getNfaIndex931, DEFAULT::getNfaIndex932, DEFAULT::getNfaIndex933, DEFAULT::getNfaIndex934, DEFAULT::getNfaIndex935, DEFAULT::getNfaIndex936, DEFAULT::getNfaIndex937, DEFAULT::getNfaIndex938, DEFAULT::getNfaIndex939, DEFAULT::getNfaIndex940, DEFAULT::getNfaIndex941, DEFAULT::getNfaIndex942, DEFAULT::getNfaIndex943, DEFAULT::getNfaIndex944, DEFAULT::getNfaIndex945, DEFAULT::getNfaIndex946, DEFAULT::getNfaIndex947, DEFAULT::getNfaIndex948, DEFAULT::getNfaIndex949, DEFAULT::getNfaIndex950, DEFAULT::getNfaIndex951, DEFAULT::getNfaIndex952, DEFAULT::getNfaIndex953, DEFAULT::getNfaIndex954, DEFAULT::getNfaIndex955, DEFAULT::getNfaIndex956, DEFAULT::getNfaIndex957, DEFAULT::getNfaIndex958, DEFAULT::getNfaIndex959, DEFAULT::getNfaIndex960, DEFAULT::getNfaIndex961, DEFAULT::getNfaIndex962, DEFAULT::getNfaIndex963, DEFAULT::getNfaIndex964, DEFAULT::getNfaIndex965, DEFAULT::getNfaIndex966, DEFAULT::getNfaIndex967, DEFAULT::getNfaIndex968, DEFAULT::getNfaIndex969, DEFAULT::getNfaIndex970, DEFAULT::getNfaIndex971, DEFAULT::getNfaIndex972, DEFAULT::getNfaIndex973, DEFAULT::getNfaIndex974, DEFAULT::getNfaIndex975, DEFAULT::getNfaIndex976, DEFAULT::getNfaIndex977, DEFAULT::getNfaIndex978, DEFAULT::getNfaIndex979, DEFAULT::getNfaIndex980, DEFAULT::getNfaIndex981, DEFAULT::getNfaIndex982, DEFAULT::getNfaIndex983, DEFAULT::getNfaIndex984, DEFAULT::getNfaIndex985, DEFAULT::getNfaIndex986, DEFAULT::getNfaIndex987, DEFAULT::getNfaIndex988, DEFAULT::getNfaIndex989, DEFAULT::getNfaIndex990, DEFAULT::getNfaIndex991, DEFAULT::getNfaIndex992, DEFAULT::getNfaIndex993, DEFAULT::getNfaIndex994, DEFAULT::getNfaIndex995, DEFAULT::getNfaIndex996, DEFAULT::getNfaIndex997, DEFAULT::getNfaIndex998, DEFAULT::getNfaIndex999, DEFAULT::getNfaIndex1000, DEFAULT::getNfaIndex1001, DEFAULT::getNfaIndex1002, DEFAULT::getNfaIndex1003, DEFAULT::getNfaIndex1004, DEFAULT::getNfaIndex1005, DEFAULT::getNfaIndex1006, DEFAULT::getNfaIndex1007, DEFAULT::getNfaIndex1008, DEFAULT::getNfaIndex1009, DEFAULT::getNfaIndex1010, DEFAULT::getNfaIndex1011, DEFAULT::getNfaIndex1012, DEFAULT::getNfaIndex1013, DEFAULT::getNfaIndex1014, DEFAULT::getNfaIndex1015, DEFAULT::getNfaIndex1016, DEFAULT::getNfaIndex1017, DEFAULT::getNfaIndex1018, DEFAULT::getNfaIndex1019, DEFAULT::getNfaIndex1020, DEFAULT::getNfaIndex1021, DEFAULT::getNfaIndex1022, DEFAULT::getNfaIndex1023, DEFAULT::getNfaIndex1024, DEFAULT::getNfaIndex1025, DEFAULT::getNfaIndex1026, DEFAULT::getNfaIndex1027, DEFAULT::getNfaIndex1028, DEFAULT::getNfaIndex1029, DEFAULT::getNfaIndex1030, DEFAULT::getNfaIndex1031, DEFAULT::getNfaIndex1032, DEFAULT::getNfaIndex1033, DEFAULT::getNfaIndex1034, DEFAULT::getNfaIndex1035, DEFAULT::getNfaIndex1036, DEFAULT::getNfaIndex1037, DEFAULT::getNfaIndex1038, DEFAULT::getNfaIndex1039, DEFAULT::getNfaIndex1040, DEFAULT::getNfaIndex1041, DEFAULT::getNfaIndex1042, DEFAULT::getNfaIndex1043, DEFAULT::getNfaIndex1044, DEFAULT::getNfaIndex1045, DEFAULT::getNfaIndex1046, DEFAULT::getNfaIndex1047, DEFAULT::getNfaIndex1048, DEFAULT::getNfaIndex1049, DEFAULT::getNfaIndex1050, DEFAULT::getNfaIndex1051, DEFAULT::getNfaIndex1052, DEFAULT::getNfaIndex1053, DEFAULT::getNfaIndex1054, DEFAULT::getNfaIndex1055, DEFAULT::getNfaIndex1056, DEFAULT::getNfaIndex1057, DEFAULT::getNfaIndex1058, DEFAULT::getNfaIndex1059, DEFAULT::getNfaIndex1060, DEFAULT::getNfaIndex1061, DEFAULT::getNfaIndex1062, DEFAULT::getNfaIndex1063, DEFAULT::getNfaIndex1064, DEFAULT::getNfaIndex1065, DEFAULT::getNfaIndex1066, DEFAULT::getNfaIndex1067, DEFAULT::getNfaIndex1068, DEFAULT::getNfaIndex1069, DEFAULT::getNfaIndex1070, DEFAULT::getNfaIndex1071, DEFAULT::getNfaIndex1072, DEFAULT::getNfaIndex1073, DEFAULT::getNfaIndex1074, DEFAULT::getNfaIndex1075, DEFAULT::getNfaIndex1076, DEFAULT::getNfaIndex1077, DEFAULT::getNfaIndex1078, DEFAULT::getNfaIndex1079, DEFAULT::getNfaIndex1080, DEFAULT::getNfaIndex1081, DEFAULT::getNfaIndex1082, DEFAULT::getNfaIndex1083, DEFAULT::getNfaIndex1084, DEFAULT::getNfaIndex1085, DEFAULT::getNfaIndex1086, DEFAULT::getNfaIndex1087, DEFAULT::getNfaIndex1088, DEFAULT::getNfaIndex1089, DEFAULT::getNfaIndex1090, DEFAULT::getNfaIndex1091, DEFAULT::getNfaIndex1092, DEFAULT::getNfaIndex1093, DEFAULT::getNfaIndex1094, DEFAULT::getNfaIndex1095, DEFAULT::getNfaIndex1096, DEFAULT::getNfaIndex1097, DEFAULT::getNfaIndex1098, DEFAULT::getNfaIndex1099, DEFAULT::getNfaIndex1100, DEFAULT::getNfaIndex1101, DEFAULT::getNfaIndex1102, DEFAULT::getNfaIndex1103, DEFAULT::getNfaIndex1104, DEFAULT::getNfaIndex1105, DEFAULT::getNfaIndex1106, DEFAULT::getNfaIndex1107, DEFAULT::getNfaIndex1108, DEFAULT::getNfaIndex1109, DEFAULT::getNfaIndex1110, DEFAULT::getNfaIndex1111, DEFAULT::getNfaIndex1112, DEFAULT::getNfaIndex1113, DEFAULT::getNfaIndex1114, DEFAULT::getNfaIndex1115, DEFAULT::getNfaIndex1116, DEFAULT::getNfaIndex1117, DEFAULT::getNfaIndex1118, DEFAULT::getNfaIndex1119, DEFAULT::getNfaIndex1120, DEFAULT::getNfaIndex1121, DEFAULT::getNfaIndex1122, DEFAULT::getNfaIndex1123, DEFAULT::getNfaIndex1124, DEFAULT::getNfaIndex1125, DEFAULT::getNfaIndex1126, DEFAULT::getNfaIndex1127, DEFAULT::getNfaIndex1128, DEFAULT::getNfaIndex1129, DEFAULT::getNfaIndex1130, DEFAULT::getNfaIndex1131, DEFAULT::getNfaIndex1132, DEFAULT::getNfaIndex1133, DEFAULT::getNfaIndex1134, DEFAULT::getNfaIndex1135, DEFAULT::getNfaIndex1136, DEFAULT::getNfaIndex1137, DEFAULT::getNfaIndex1138, DEFAULT::getNfaIndex1139, DEFAULT::getNfaIndex1140, DEFAULT::getNfaIndex1141, DEFAULT::getNfaIndex1142, DEFAULT::getNfaIndex1143, DEFAULT::getNfaIndex1144, DEFAULT::getNfaIndex1145, DEFAULT::getNfaIndex1146, DEFAULT::getNfaIndex1147, DEFAULT::getNfaIndex1148, DEFAULT::getNfaIndex1149, DEFAULT::getNfaIndex1150, DEFAULT::getNfaIndex1151, DEFAULT::getNfaIndex1152, DEFAULT::getNfaIndex1153, DEFAULT::getNfaIndex1154, DEFAULT::getNfaIndex1155, DEFAULT::getNfaIndex1156, DEFAULT::getNfaIndex1157, DEFAULT::getNfaIndex1158, DEFAULT::getNfaIndex1159, DEFAULT::getNfaIndex1160, DEFAULT::getNfaIndex1161, DEFAULT::getNfaIndex1162, DEFAULT::getNfaIndex1163, DEFAULT::getNfaIndex1164, DEFAULT::getNfaIndex1165, DEFAULT::getNfaIndex1166, DEFAULT::getNfaIndex1167, DEFAULT::getNfaIndex1168, DEFAULT::getNfaIndex1169, DEFAULT::getNfaIndex1170, DEFAULT::getNfaIndex1171, DEFAULT::getNfaIndex1172, DEFAULT::getNfaIndex1173, DEFAULT::getNfaIndex1174, DEFAULT::getNfaIndex1175, DEFAULT::getNfaIndex1176, DEFAULT::getNfaIndex1177, DEFAULT::getNfaIndex1178, DEFAULT::getNfaIndex1179, DEFAULT::getNfaIndex1180, DEFAULT::getNfaIndex1181, DEFAULT::getNfaIndex1182, DEFAULT::getNfaIndex1183, DEFAULT::getNfaIndex1184, DEFAULT::getNfaIndex1185, DEFAULT::getNfaIndex1186, DEFAULT::getNfaIndex1187, DEFAULT::getNfaIndex1188, DEFAULT::getNfaIndex1189, DEFAULT::getNfaIndex1190, DEFAULT::getNfaIndex1191, DEFAULT::getNfaIndex1192, DEFAULT::getNfaIndex1193, DEFAULT::getNfaIndex1194, DEFAULT::getNfaIndex1195, DEFAULT::getNfaIndex1196, DEFAULT::getNfaIndex1197, DEFAULT::getNfaIndex1198, DEFAULT::getNfaIndex1199, DEFAULT::getNfaIndex1200, DEFAULT::getNfaIndex1201, DEFAULT::getNfaIndex1202, DEFAULT::getNfaIndex1203, DEFAULT::getNfaIndex1204, DEFAULT::getNfaIndex1205, DEFAULT::getNfaIndex1206, DEFAULT::getNfaIndex1207, DEFAULT::getNfaIndex1208, DEFAULT::getNfaIndex1209, DEFAULT::getNfaIndex1210, DEFAULT::getNfaIndex1211, DEFAULT::getNfaIndex1212, DEFAULT::getNfaIndex1213, DEFAULT::getNfaIndex1214, DEFAULT::getNfaIndex1215, DEFAULT::getNfaIndex1216, DEFAULT::getNfaIndex1217, DEFAULT::getNfaIndex1218, DEFAULT::getNfaIndex1219, DEFAULT::getNfaIndex1220, DEFAULT::getNfaIndex1221, DEFAULT::getNfaIndex1222, DEFAULT::getNfaIndex1223, DEFAULT::getNfaIndex1224, DEFAULT::getNfaIndex1225, DEFAULT::getNfaIndex1226, DEFAULT::getNfaIndex1227, DEFAULT::getNfaIndex1228, DEFAULT::getNfaIndex1229, DEFAULT::getNfaIndex1230, DEFAULT::getNfaIndex1231, DEFAULT::getNfaIndex1232, DEFAULT::getNfaIndex1233, DEFAULT::getNfaIndex1234, DEFAULT::getNfaIndex1235, DEFAULT::getNfaIndex1236, DEFAULT::getNfaIndex1237, DEFAULT::getNfaIndex1238, DEFAULT::getNfaIndex1239, DEFAULT::getNfaIndex1240, DEFAULT::getNfaIndex1241, DEFAULT::getNfaIndex1242, DEFAULT::getNfaIndex1243, DEFAULT::getNfaIndex1244, DEFAULT::getNfaIndex1245, DEFAULT::getNfaIndex1246, DEFAULT::getNfaIndex1247, DEFAULT::getNfaIndex1248, DEFAULT::getNfaIndex1249, DEFAULT::getNfaIndex1250, DEFAULT::getNfaIndex1251, DEFAULT::getNfaIndex1252, DEFAULT::getNfaIndex1253, DEFAULT::getNfaIndex1254, DEFAULT::getNfaIndex1255, DEFAULT::getNfaIndex1256, DEFAULT::getNfaIndex1257, DEFAULT::getNfaIndex1258, DEFAULT::getNfaIndex1259, DEFAULT::getNfaIndex1260, DEFAULT::getNfaIndex1261, DEFAULT::getNfaIndex1262, DEFAULT::getNfaIndex1263, DEFAULT::getNfaIndex1264, DEFAULT::getNfaIndex1265, DEFAULT::getNfaIndex1266, DEFAULT::getNfaIndex1267, DEFAULT::getNfaIndex1268, DEFAULT::getNfaIndex1269, DEFAULT::getNfaIndex1270, DEFAULT::getNfaIndex1271, DEFAULT::getNfaIndex1272, DEFAULT::getNfaIndex1273, DEFAULT::getNfaIndex1274, DEFAULT::getNfaIndex1275, DEFAULT::getNfaIndex1276, DEFAULT::getNfaIndex1277, DEFAULT::getNfaIndex1278, DEFAULT::getNfaIndex1279, DEFAULT::getNfaIndex1280, DEFAULT::getNfaIndex1281, DEFAULT::getNfaIndex1282, DEFAULT::getNfaIndex1283, DEFAULT::getNfaIndex1284, DEFAULT::getNfaIndex1285, DEFAULT::getNfaIndex1286, DEFAULT::getNfaIndex1287, DEFAULT::getNfaIndex1288, DEFAULT::getNfaIndex1289, DEFAULT::getNfaIndex1290, DEFAULT::getNfaIndex1291, DEFAULT::getNfaIndex1292, DEFAULT::getNfaIndex1293, DEFAULT::getNfaIndex1294, DEFAULT::getNfaIndex1295, DEFAULT::getNfaIndex1296, DEFAULT::getNfaIndex1297, DEFAULT::getNfaIndex1298, DEFAULT::getNfaIndex1299, DEFAULT::getNfaIndex1300, DEFAULT::getNfaIndex1301, DEFAULT::getNfaIndex1302, DEFAULT::getNfaIndex1303, DEFAULT::getNfaIndex1304, DEFAULT::getNfaIndex1305, DEFAULT::getNfaIndex1306, DEFAULT::getNfaIndex1307, DEFAULT::getNfaIndex1308, DEFAULT::getNfaIndex1309, DEFAULT::getNfaIndex1310, DEFAULT::getNfaIndex1311, DEFAULT::getNfaIndex1312, DEFAULT::getNfaIndex1313, DEFAULT::getNfaIndex1314, DEFAULT::getNfaIndex1315, DEFAULT::getNfaIndex1316, DEFAULT::getNfaIndex1317, DEFAULT::getNfaIndex1318, DEFAULT::getNfaIndex1319, DEFAULT::getNfaIndex1320, DEFAULT::getNfaIndex1321, DEFAULT::getNfaIndex1322, DEFAULT::getNfaIndex1323, DEFAULT::getNfaIndex1324, DEFAULT::getNfaIndex1325, DEFAULT::getNfaIndex1326, DEFAULT::getNfaIndex1327, DEFAULT::getNfaIndex1328, DEFAULT::getNfaIndex1329, DEFAULT::getNfaIndex1330, DEFAULT::getNfaIndex1331, DEFAULT::getNfaIndex1332, DEFAULT::getNfaIndex1333, DEFAULT::getNfaIndex1334, DEFAULT::getNfaIndex1335, DEFAULT::getNfaIndex1336, DEFAULT::getNfaIndex1337, DEFAULT::getNfaIndex1338, DEFAULT::getNfaIndex1339, DEFAULT::getNfaIndex1340, DEFAULT::getNfaIndex1341, DEFAULT::getNfaIndex1342, DEFAULT::getNfaIndex1343, DEFAULT::getNfaIndex1344, DEFAULT::getNfaIndex1345, DEFAULT::getNfaIndex1346, DEFAULT::getNfaIndex1347, DEFAULT::getNfaIndex1348, DEFAULT::getNfaIndex1349, DEFAULT::getNfaIndex1350, DEFAULT::getNfaIndex1351, DEFAULT::getNfaIndex1352, DEFAULT::getNfaIndex1353, DEFAULT::getNfaIndex1354, DEFAULT::getNfaIndex1355, DEFAULT::getNfaIndex1356, DEFAULT::getNfaIndex1357, DEFAULT::getNfaIndex1358, DEFAULT::getNfaIndex1359, DEFAULT::getNfaIndex1360, DEFAULT::getNfaIndex1361, DEFAULT::getNfaIndex1362, DEFAULT::getNfaIndex1363, DEFAULT::getNfaIndex1364, DEFAULT::getNfaIndex1365, DEFAULT::getNfaIndex1366, DEFAULT::getNfaIndex1367, DEFAULT::getNfaIndex1368, DEFAULT::getNfaIndex1369, DEFAULT::getNfaIndex1370, DEFAULT::getNfaIndex1371, DEFAULT::getNfaIndex1372, DEFAULT::getNfaIndex1373, DEFAULT::getNfaIndex1374, DEFAULT::getNfaIndex1375, DEFAULT::getNfaIndex1376, DEFAULT::getNfaIndex1377, DEFAULT::getNfaIndex1378, DEFAULT::getNfaIndex1379, DEFAULT::getNfaIndex1380, DEFAULT::getNfaIndex1381, DEFAULT::getNfaIndex1382, DEFAULT::getNfaIndex1383, DEFAULT::getNfaIndex1384, DEFAULT::getNfaIndex1385, DEFAULT::getNfaIndex1386, DEFAULT::getNfaIndex1387, DEFAULT::getNfaIndex1388, DEFAULT::getNfaIndex1389, DEFAULT::getNfaIndex1390, DEFAULT::getNfaIndex1391, DEFAULT::getNfaIndex1392, DEFAULT::getNfaIndex1393, DEFAULT::getNfaIndex1394, DEFAULT::getNfaIndex1395, DEFAULT::getNfaIndex1396, DEFAULT::getNfaIndex1397, DEFAULT::getNfaIndex1398, DEFAULT::getNfaIndex1399, DEFAULT::getNfaIndex1400, DEFAULT::getNfaIndex1401, DEFAULT::getNfaIndex1402, DEFAULT::getNfaIndex1403, DEFAULT::getNfaIndex1404, DEFAULT::getNfaIndex1405, DEFAULT::getNfaIndex1406, DEFAULT::getNfaIndex1407, DEFAULT::getNfaIndex1408, DEFAULT::getNfaIndex1409, DEFAULT::getNfaIndex1410, DEFAULT::getNfaIndex1411, DEFAULT::getNfaIndex1412, DEFAULT::getNfaIndex1413, DEFAULT::getNfaIndex1414, DEFAULT::getNfaIndex1415, DEFAULT::getNfaIndex1416, DEFAULT::getNfaIndex1417, DEFAULT::getNfaIndex1418, DEFAULT::getNfaIndex1419, DEFAULT::getNfaIndex1420, DEFAULT::getNfaIndex1421, DEFAULT::getNfaIndex1422, DEFAULT::getNfaIndex1423, DEFAULT::getNfaIndex1424, DEFAULT::getNfaIndex1425, DEFAULT::getNfaIndex1426, DEFAULT::getNfaIndex1427, DEFAULT::getNfaIndex1428, DEFAULT::getNfaIndex1429, DEFAULT::getNfaIndex1430, DEFAULT::getNfaIndex1431, DEFAULT::getNfaIndex1432, DEFAULT::getNfaIndex1433, DEFAULT::getNfaIndex1434, DEFAULT::getNfaIndex1435, DEFAULT::getNfaIndex1436, DEFAULT::getNfaIndex1437, DEFAULT::getNfaIndex1438, DEFAULT::getNfaIndex1439, DEFAULT::getNfaIndex1440, DEFAULT::getNfaIndex1441, DEFAULT::getNfaIndex1442, DEFAULT::getNfaIndex1443, DEFAULT::getNfaIndex1444, DEFAULT::getNfaIndex1445, DEFAULT::getNfaIndex1446, DEFAULT::getNfaIndex1447, DEFAULT::getNfaIndex1448, DEFAULT::getNfaIndex1449, DEFAULT::getNfaIndex1450, DEFAULT::getNfaIndex1451, DEFAULT::getNfaIndex1452, DEFAULT::getNfaIndex1453, DEFAULT::getNfaIndex1454, DEFAULT::getNfaIndex1455, DEFAULT::getNfaIndex1456, DEFAULT::getNfaIndex1457, DEFAULT::getNfaIndex1458, DEFAULT::getNfaIndex1459, DEFAULT::getNfaIndex1460, DEFAULT::getNfaIndex1461, DEFAULT::getNfaIndex1462, DEFAULT::getNfaIndex1463, DEFAULT::getNfaIndex1464, DEFAULT::getNfaIndex1465, DEFAULT::getNfaIndex1466, DEFAULT::getNfaIndex1467, DEFAULT::getNfaIndex1468, DEFAULT::getNfaIndex1469, DEFAULT::getNfaIndex1470, DEFAULT::getNfaIndex1471, DEFAULT::getNfaIndex1472, DEFAULT::getNfaIndex1473, DEFAULT::getNfaIndex1474, DEFAULT::getNfaIndex1475, DEFAULT::getNfaIndex1476, DEFAULT::getNfaIndex1477, DEFAULT::getNfaIndex1478, DEFAULT::getNfaIndex1479, DEFAULT::getNfaIndex1480, DEFAULT::getNfaIndex1481, DEFAULT::getNfaIndex1482, DEFAULT::getNfaIndex1483, DEFAULT::getNfaIndex1484, DEFAULT::getNfaIndex1485, DEFAULT::getNfaIndex1486, DEFAULT::getNfaIndex1487, DEFAULT::getNfaIndex1488, DEFAULT::getNfaIndex1489, DEFAULT::getNfaIndex1490, DEFAULT::getNfaIndex1491, DEFAULT::getNfaIndex1492, DEFAULT::getNfaIndex1493, DEFAULT::getNfaIndex1494, DEFAULT::getNfaIndex1495, DEFAULT::getNfaIndex1496, DEFAULT::getNfaIndex1497, DEFAULT::getNfaIndex1498, DEFAULT::getNfaIndex1499, DEFAULT::getNfaIndex1500, DEFAULT::getNfaIndex1501, DEFAULT::getNfaIndex1502, DEFAULT::getNfaIndex1503, DEFAULT::getNfaIndex1504, DEFAULT::getNfaIndex1505, DEFAULT::getNfaIndex1506, DEFAULT::getNfaIndex1507, DEFAULT::getNfaIndex1508, DEFAULT::getNfaIndex1509, DEFAULT::getNfaIndex1510, DEFAULT::getNfaIndex1511, DEFAULT::getNfaIndex1512, DEFAULT::getNfaIndex1513, DEFAULT::getNfaIndex1514, DEFAULT::getNfaIndex1515, DEFAULT::getNfaIndex1516, DEFAULT::getNfaIndex1517, DEFAULT::getNfaIndex1518, DEFAULT::getNfaIndex1519, DEFAULT::getNfaIndex1520, DEFAULT::getNfaIndex1521, DEFAULT::getNfaIndex1522, DEFAULT::getNfaIndex1523, DEFAULT::getNfaIndex1524, DEFAULT::getNfaIndex1525, DEFAULT::getNfaIndex1526, DEFAULT::getNfaIndex1527, DEFAULT::getNfaIndex1528, DEFAULT::getNfaIndex1529, DEFAULT::getNfaIndex1530, DEFAULT::getNfaIndex1531, DEFAULT::getNfaIndex1532, DEFAULT::getNfaIndex1533, DEFAULT::getNfaIndex1534, DEFAULT::getNfaIndex1535, DEFAULT::getNfaIndex1536, DEFAULT::getNfaIndex1537, DEFAULT::getNfaIndex1538, DEFAULT::getNfaIndex1539, DEFAULT::getNfaIndex1540, DEFAULT::getNfaIndex1541, DEFAULT::getNfaIndex1542, DEFAULT::getNfaIndex1543, DEFAULT::getNfaIndex1544, DEFAULT::getNfaIndex1545, DEFAULT::getNfaIndex1546, DEFAULT::getNfaIndex1547, DEFAULT::getNfaIndex1548, DEFAULT::getNfaIndex1549, DEFAULT::getNfaIndex1550, DEFAULT::getNfaIndex1551, DEFAULT::getNfaIndex1552, DEFAULT::getNfaIndex1553, DEFAULT::getNfaIndex1554, DEFAULT::getNfaIndex1555, DEFAULT::getNfaIndex1556, DEFAULT::getNfaIndex1557, DEFAULT::getNfaIndex1558, DEFAULT::getNfaIndex1559, DEFAULT::getNfaIndex1560, DEFAULT::getNfaIndex1561, DEFAULT::getNfaIndex1562, DEFAULT::getNfaIndex1563, DEFAULT::getNfaIndex1564, DEFAULT::getNfaIndex1565, DEFAULT::getNfaIndex1566, DEFAULT::getNfaIndex1567, DEFAULT::getNfaIndex1568, DEFAULT::getNfaIndex1569, DEFAULT::getNfaIndex1570, DEFAULT::getNfaIndex1571, DEFAULT::getNfaIndex1572, DEFAULT::getNfaIndex1573, DEFAULT::getNfaIndex1574, DEFAULT::getNfaIndex1575, DEFAULT::getNfaIndex1576, DEFAULT::getNfaIndex1577, DEFAULT::getNfaIndex1578, DEFAULT::getNfaIndex1579, DEFAULT::getNfaIndex1580, DEFAULT::getNfaIndex1581, DEFAULT::getNfaIndex1582, DEFAULT::getNfaIndex1583, DEFAULT::getNfaIndex1584, DEFAULT::getNfaIndex1585, DEFAULT::getNfaIndex1586, DEFAULT::getNfaIndex1587, DEFAULT::getNfaIndex1588, DEFAULT::getNfaIndex1589, DEFAULT::getNfaIndex1590, DEFAULT::getNfaIndex1591, DEFAULT::getNfaIndex1592, DEFAULT::getNfaIndex1593, DEFAULT::getNfaIndex1594, DEFAULT::getNfaIndex1595, DEFAULT::getNfaIndex1596, DEFAULT::getNfaIndex1597, DEFAULT::getNfaIndex1598, DEFAULT::getNfaIndex1599, DEFAULT::getNfaIndex1600, DEFAULT::getNfaIndex1601, DEFAULT::getNfaIndex1602, DEFAULT::getNfaIndex1603, DEFAULT::getNfaIndex1604, DEFAULT::getNfaIndex1605, DEFAULT::getNfaIndex1606, DEFAULT::getNfaIndex1607, DEFAULT::getNfaIndex1608, DEFAULT::getNfaIndex1609, DEFAULT::getNfaIndex1610, DEFAULT::getNfaIndex1611, DEFAULT::getNfaIndex1612, DEFAULT::getNfaIndex1613, DEFAULT::getNfaIndex1614, DEFAULT::getNfaIndex1615, DEFAULT::getNfaIndex1616, DEFAULT::getNfaIndex1617, DEFAULT::getNfaIndex1618, DEFAULT::getNfaIndex1619, DEFAULT::getNfaIndex1620, DEFAULT::getNfaIndex1621, DEFAULT::getNfaIndex1622, DEFAULT::getNfaIndex1623, DEFAULT::getNfaIndex1624, DEFAULT::getNfaIndex1625, DEFAULT::getNfaIndex1626, DEFAULT::getNfaIndex1627, DEFAULT::getNfaIndex1628, DEFAULT::getNfaIndex1629, DEFAULT::getNfaIndex1630, DEFAULT::getNfaIndex1631, DEFAULT::getNfaIndex1632, DEFAULT::getNfaIndex1633, DEFAULT::getNfaIndex1634, DEFAULT::getNfaIndex1635, DEFAULT::getNfaIndex1636, DEFAULT::getNfaIndex1637, DEFAULT::getNfaIndex1638, DEFAULT::getNfaIndex1639, DEFAULT::getNfaIndex1640, DEFAULT::getNfaIndex1641, DEFAULT::getNfaIndex1642, DEFAULT::getNfaIndex1643, DEFAULT::getNfaIndex1644, DEFAULT::getNfaIndex1645, DEFAULT::getNfaIndex1646, DEFAULT::getNfaIndex1647, DEFAULT::getNfaIndex1648, DEFAULT::getNfaIndex1649, DEFAULT::getNfaIndex1650, DEFAULT::getNfaIndex1651, DEFAULT::getNfaIndex1652, DEFAULT::getNfaIndex1653, DEFAULT::getNfaIndex1654, DEFAULT::getNfaIndex1655, DEFAULT::getNfaIndex1656, DEFAULT::getNfaIndex1657, DEFAULT::getNfaIndex1658, DEFAULT::getNfaIndex1659, DEFAULT::getNfaIndex1660, DEFAULT::getNfaIndex1661, DEFAULT::getNfaIndex1662, DEFAULT::getNfaIndex1663, DEFAULT::getNfaIndex1664, DEFAULT::getNfaIndex1665, DEFAULT::getNfaIndex1666, DEFAULT::getNfaIndex1667, DEFAULT::getNfaIndex1668, DEFAULT::getNfaIndex1669, DEFAULT::getNfaIndex1670, DEFAULT::getNfaIndex1671, DEFAULT::getNfaIndex1672, DEFAULT::getNfaIndex1673, DEFAULT::getNfaIndex1674, DEFAULT::getNfaIndex1675, DEFAULT::getNfaIndex1676, DEFAULT::getNfaIndex1677, DEFAULT::getNfaIndex1678, DEFAULT::getNfaIndex1679, DEFAULT::getNfaIndex1680, DEFAULT::getNfaIndex1681, DEFAULT::getNfaIndex1682, DEFAULT::getNfaIndex1683, DEFAULT::getNfaIndex1684, DEFAULT::getNfaIndex1685, DEFAULT::getNfaIndex1686, DEFAULT::getNfaIndex1687, DEFAULT::getNfaIndex1688, DEFAULT::getNfaIndex1689, DEFAULT::getNfaIndex1690, DEFAULT::getNfaIndex1691, DEFAULT::getNfaIndex1692, DEFAULT::getNfaIndex1693, DEFAULT::getNfaIndex1694, DEFAULT::getNfaIndex1695, DEFAULT::getNfaIndex1696, DEFAULT::getNfaIndex1697, DEFAULT::getNfaIndex1698, DEFAULT::getNfaIndex1699, DEFAULT::getNfaIndex1700, DEFAULT::getNfaIndex1701, DEFAULT::getNfaIndex1702, DEFAULT::getNfaIndex1703, DEFAULT::getNfaIndex1704, DEFAULT::getNfaIndex1705, DEFAULT::getNfaIndex1706, DEFAULT::getNfaIndex1707, DEFAULT::getNfaIndex1708, DEFAULT::getNfaIndex1709, DEFAULT::getNfaIndex1710, DEFAULT::getNfaIndex1711, DEFAULT::getNfaIndex1712, DEFAULT::getNfaIndex1713, DEFAULT::getNfaIndex1714, DEFAULT::getNfaIndex1715, DEFAULT::getNfaIndex1716, DEFAULT::getNfaIndex1717, DEFAULT::getNfaIndex1718, DEFAULT::getNfaIndex1719, DEFAULT::getNfaIndex1720, DEFAULT::getNfaIndex1721, DEFAULT::getNfaIndex1722, DEFAULT::getNfaIndex1723, DEFAULT::getNfaIndex1724, DEFAULT::getNfaIndex1725, DEFAULT::getNfaIndex1726, DEFAULT::getNfaIndex1727, DEFAULT::getNfaIndex1728, DEFAULT::getNfaIndex1729, DEFAULT::getNfaIndex1730, DEFAULT::getNfaIndex1731, DEFAULT::getNfaIndex1732, DEFAULT::getNfaIndex1733, DEFAULT::getNfaIndex1734, DEFAULT::getNfaIndex1735, DEFAULT::getNfaIndex1736, DEFAULT::getNfaIndex1737, DEFAULT::getNfaIndex1738, DEFAULT::getNfaIndex1739, DEFAULT::getNfaIndex1740, DEFAULT::getNfaIndex1741, DEFAULT::getNfaIndex1742, DEFAULT::getNfaIndex1743, DEFAULT::getNfaIndex1744, DEFAULT::getNfaIndex1745, DEFAULT::getNfaIndex1746, DEFAULT::getNfaIndex1747, DEFAULT::getNfaIndex1748, DEFAULT::getNfaIndex1749, DEFAULT::getNfaIndex1750, DEFAULT::getNfaIndex1751, DEFAULT::getNfaIndex1752, DEFAULT::getNfaIndex1753, DEFAULT::getNfaIndex1754, DEFAULT::getNfaIndex1755, DEFAULT::getNfaIndex1756, DEFAULT::getNfaIndex1757, DEFAULT::getNfaIndex1758, DEFAULT::getNfaIndex1759, DEFAULT::getNfaIndex1760, DEFAULT::getNfaIndex1761, DEFAULT::getNfaIndex1762, DEFAULT::getNfaIndex1763, DEFAULT::getNfaIndex1764, DEFAULT::getNfaIndex1765, DEFAULT::getNfaIndex1766, DEFAULT::getNfaIndex1767, DEFAULT::getNfaIndex1768, DEFAULT::getNfaIndex1769, DEFAULT::getNfaIndex1770, DEFAULT::getNfaIndex1771, DEFAULT::getNfaIndex1772, DEFAULT::getNfaIndex1773, DEFAULT::getNfaIndex1774, DEFAULT::getNfaIndex1775, DEFAULT::getNfaIndex1776, DEFAULT::getNfaIndex1777, DEFAULT::getNfaIndex1778, DEFAULT::getNfaIndex1779, DEFAULT::getNfaIndex1780, DEFAULT::getNfaIndex1781, DEFAULT::getNfaIndex1782, DEFAULT::getNfaIndex1783, DEFAULT::getNfaIndex1784, DEFAULT::getNfaIndex1785, DEFAULT::getNfaIndex1786, DEFAULT::getNfaIndex1787, DEFAULT::getNfaIndex1788, DEFAULT::getNfaIndex1789, DEFAULT::getNfaIndex1790, DEFAULT::getNfaIndex1791, DEFAULT::getNfaIndex1792, DEFAULT::getNfaIndex1793, DEFAULT::getNfaIndex1794, DEFAULT::getNfaIndex1795, DEFAULT::getNfaIndex1796, DEFAULT::getNfaIndex1797, DEFAULT::getNfaIndex1798, DEFAULT::getNfaIndex1799, DEFAULT::getNfaIndex1800, DEFAULT::getNfaIndex1801, DEFAULT::getNfaIndex1802, DEFAULT::getNfaIndex1803, DEFAULT::getNfaIndex1804, DEFAULT::getNfaIndex1805, DEFAULT::getNfaIndex1806, DEFAULT::getNfaIndex1807, DEFAULT::getNfaIndex1808, DEFAULT::getNfaIndex1809, DEFAULT::getNfaIndex1810, DEFAULT::getNfaIndex1811, DEFAULT::getNfaIndex1812, DEFAULT::getNfaIndex1813, DEFAULT::getNfaIndex1814, DEFAULT::getNfaIndex1815, DEFAULT::getNfaIndex1816, DEFAULT::getNfaIndex1817, DEFAULT::getNfaIndex1818, DEFAULT::getNfaIndex1819, DEFAULT::getNfaIndex1820, DEFAULT::getNfaIndex1821, DEFAULT::getNfaIndex1822, DEFAULT::getNfaIndex1823, DEFAULT::getNfaIndex1824, DEFAULT::getNfaIndex1825, DEFAULT::getNfaIndex1826, DEFAULT::getNfaIndex1827, DEFAULT::getNfaIndex1828, DEFAULT::getNfaIndex1829, DEFAULT::getNfaIndex1830, DEFAULT::getNfaIndex1831, DEFAULT::getNfaIndex1832, DEFAULT::getNfaIndex1833, DEFAULT::getNfaIndex1834, DEFAULT::getNfaIndex1835};
        }
    }
}

